# This file has been autogenerated by the pywayland scanner

# Copyright © 2015, 2016 Red Hat
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ZwpPrimarySelectionOfferV1(Interface):
    """Offer to transfer primary selection contents

    A wp_primary_selection_offer represents an offer to transfer the contents
    of the primary selection clipboard to the client. Similar to
    :class:`~pywayland.protocol.wayland.WlDataOffer`, the offer also describes
    the mime types that the data can be converted to and provides the
    mechanisms for transferring the data directly to the client.
    """

    name = "zwp_primary_selection_offer_v1"
    version = 1


class ZwpPrimarySelectionOfferV1Proxy(Proxy[ZwpPrimarySelectionOfferV1]):
    interface = ZwpPrimarySelectionOfferV1

    @ZwpPrimarySelectionOfferV1.request(
        Argument(ArgumentType.String),
        Argument(ArgumentType.FileDescriptor),
    )
    def receive(self, mime_type: str, fd: int) -> None:
        """Request that the data is transferred

        To transfer the contents of the primary selection clipboard, the client
        issues this request and indicates the mime type that it wants to
        receive. The transfer happens through the passed file descriptor
        (typically created with the pipe system call). The source client writes
        the data in the mime type representation requested and then closes the
        file descriptor.

        The receiving client reads from the read end of the pipe until EOF and
        closes its end, at which point the transfer is complete.

        :param mime_type:
        :type mime_type:
            `ArgumentType.String`
        :param fd:
        :type fd:
            `ArgumentType.FileDescriptor`
        """
        self._marshal(0, mime_type, fd)

    @ZwpPrimarySelectionOfferV1.request()
    def destroy(self) -> None:
        """Destroy the primary selection offer

        Destroy the primary selection offer.
        """
        self._marshal(1)
        self._destroy()


class ZwpPrimarySelectionOfferV1Resource(Resource):
    interface = ZwpPrimarySelectionOfferV1

    @ZwpPrimarySelectionOfferV1.event(
        Argument(ArgumentType.String),
    )
    def offer(self, mime_type: str) -> None:
        """Advertise offered mime type

        Sent immediately after creating announcing the
        wp_primary_selection_offer through
        wp_primary_selection_device.data_offer. One event is sent per offered
        mime type.

        :param mime_type:
        :type mime_type:
            `ArgumentType.String`
        """
        self._post_event(0, mime_type)


class ZwpPrimarySelectionOfferV1Global(Global):
    interface = ZwpPrimarySelectionOfferV1


ZwpPrimarySelectionOfferV1._gen_c()
ZwpPrimarySelectionOfferV1.proxy_class = ZwpPrimarySelectionOfferV1Proxy
ZwpPrimarySelectionOfferV1.resource_class = ZwpPrimarySelectionOfferV1Resource
ZwpPrimarySelectionOfferV1.global_class = ZwpPrimarySelectionOfferV1Global
