/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class RoundShield
extends MeleeWeapon {
    public RoundShield() {
        this.image = ItemSpriteSheet.ROUND_SHIELD;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 3;
    }

    @Override
    public int max(int lvl) {
        return Math.round(3.0f * (float)(this.tier + 1)) + lvl * (this.tier - 1);
    }

    @Override
    public int defenseFactor(Char owner) {
        return 4 + this.buffedLvl();
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats_desc", 4 + this.buffedLvl());
        }
        return Messages.get(this, "typical_stats_desc", 4);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        RoundShield.guardAbility(hero, 8, this);
    }

    public static void guardAbility(Hero hero, int duration, MeleeWeapon wep) {
        wep.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, GuardTracker.class, duration);
        hero.sprite.operate(hero.pos);
        hero.spendAndNext(1.0f);
        wep.afterAbilityUsed(hero);
    }

    public static class GuardTracker
    extends FlavourBuff {
        public GuardTracker() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 61;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (7.0f - this.visualcooldown()) / 7.0f);
        }
    }
}

