/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.http.parser.Host;

public class RemoteIpValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(RemoteIpValve.class);
    private String hostHeader = null;
    private boolean changeLocalName = false;
    private int httpServerPort = 80;
    private int httpsServerPort = 443;
    private String portHeader = null;
    private boolean changeLocalPort = false;
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|100\\.6[4-9]{1}\\.\\d{1,3}\\.\\d{1,3}|100\\.[7-9]{1}\\d{1}\\.\\d{1,3}\\.\\d{1,3}|100\\.1[0-1]{1}\\d{1}\\.\\d{1,3}\\.\\d{1,3}|100\\.12[0-7]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1");
    private String protocolHeader = "X-Forwarded-Proto";
    private String protocolHeaderHttpsValue = "https";
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIpHeader = "X-Forwarded-For";
    private boolean requestAttributesEnabled = true;
    private Pattern trustedProxies = null;

    @Deprecated
    protected static String[] commaDelimitedListToStringArray(String string) {
        return StringUtils.splitCommaSeparated((String)string);
    }

    @Deprecated
    protected static String listToCommaDelimitedString(List<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string == null) continue;
            stringBuilder.append((Object)string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public RemoteIpValve() {
        super(true);
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public void setHostHeader(String string) {
        this.hostHeader = string;
    }

    public boolean isChangeLocalName() {
        return this.changeLocalName;
    }

    public void setChangeLocalName(boolean bl) {
        this.changeLocalName = bl;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public void setPortHeader(String string) {
        this.portHeader = string;
    }

    public boolean isChangeLocalPort() {
        return this.changeLocalPort;
    }

    public void setChangeLocalPort(boolean bl) {
        this.changeLocalPort = bl;
    }

    public String getInternalProxies() {
        if (this.internalProxies == null) {
            return null;
        }
        return this.internalProxies.toString();
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public String getProtocolHeaderHttpsValue() {
        return this.protocolHeaderHttpsValue;
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public String getTrustedProxies() {
        if (this.trustedProxies == null) {
            return null;
        }
        return this.trustedProxies.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        boolean bl;
        String string = request.getRemoteAddr();
        String string2 = request.getRemoteHost();
        String string3 = request.getScheme();
        boolean bl2 = request.isSecure();
        String string4 = request.getServerName();
        String string5 = this.isChangeLocalName() ? request.getLocalName() : null;
        int n = request.getServerPort();
        int n2 = request.getLocalPort();
        String string6 = request.getHeader(this.proxiesHeader);
        String string7 = request.getHeader(this.remoteIpHeader);
        boolean bl3 = bl = this.internalProxies != null && this.internalProxies.matcher(string).matches();
        if (bl || this.trustedProxies != null && this.trustedProxies.matcher(string).matches()) {
            Object object2;
            Object object3;
            int n3;
            object = null;
            ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = request.getHeaders(this.remoteIpHeader);
            while (stringArray.hasMoreElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)stringArray.nextElement());
            }
            stringArray = StringUtils.splitCommaSeparated((String)stringBuilder.toString());
            if (!bl) {
                arrayDeque.addFirst(string);
            }
            for (n3 = stringArray.length - 1; n3 >= 0; --n3) {
                object = object3 = stringArray[n3];
                if (this.internalProxies != null && this.internalProxies.matcher((CharSequence)object3).matches()) continue;
                if (this.trustedProxies != null && this.trustedProxies.matcher((CharSequence)object3).matches()) {
                    arrayDeque.addFirst(object3);
                    continue;
                }
                --n3;
                break;
            }
            object3 = new ArrayDeque();
            while (n3 >= 0) {
                object2 = stringArray[n3];
                object3.addFirst(object2);
                --n3;
            }
            if (object != null) {
                request.setRemoteAddr((String)object);
                if (request.getConnector().getEnableLookups()) {
                    try {
                        object2 = InetAddress.getByName((String)object);
                        request.setRemoteHost(((InetAddress)object2).getCanonicalHostName());
                    }
                    catch (UnknownHostException unknownHostException) {
                        log.debug((Object)sm.getString("remoteIpValve.invalidRemoteAddress", new Object[]{object}), (Throwable)unknownHostException);
                        request.setRemoteHost((String)object);
                    }
                } else {
                    request.setRemoteHost((String)object);
                }
                if (arrayDeque.size() == 0) {
                    request.getCoyoteRequest().getMimeHeaders().removeHeader(this.proxiesHeader);
                } else {
                    object2 = StringUtils.join(arrayDeque);
                    request.getCoyoteRequest().getMimeHeaders().setValue(this.proxiesHeader).setString((String)object2);
                }
                if (object3.size() == 0) {
                    request.getCoyoteRequest().getMimeHeaders().removeHeader(this.remoteIpHeader);
                } else {
                    object2 = StringUtils.join((Collection)object3);
                    request.getCoyoteRequest().getMimeHeaders().setValue(this.remoteIpHeader).setString((String)object2);
                }
            }
            if (this.protocolHeader != null && (object2 = request.getHeader(this.protocolHeader)) != null) {
                if (this.isForwardedProtoHeaderValueSecure((String)object2)) {
                    request.setSecure(true);
                    request.getCoyoteRequest().scheme().setString("https");
                    this.setPorts(request, this.httpsServerPort);
                } else {
                    request.setSecure(false);
                    request.getCoyoteRequest().scheme().setString("http");
                    this.setPorts(request, this.httpServerPort);
                }
            }
            if (this.hostHeader != null && (object2 = request.getHeader(this.hostHeader)) != null) {
                try {
                    int n4 = Host.parse((String)object2);
                    if (n4 > -1) {
                        log.debug((Object)sm.getString("remoteIpValve.invalidHostWithPort", new Object[]{object2, this.hostHeader}));
                        object2 = ((String)object2).substring(0, n4);
                    }
                    request.getCoyoteRequest().serverName().setString((String)object2);
                    if (this.isChangeLocalName()) {
                        request.getCoyoteRequest().localName().setString((String)object2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.debug((Object)sm.getString("remoteIpValve.invalidHostHeader", new Object[]{object2, this.hostHeader}));
                }
            }
            request.setAttribute("org.apache.tomcat.request.forwarded", Boolean.TRUE);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Incoming request " + request.getRequestURI() + " with originalRemoteAddr [" + string + "], originalRemoteHost=[" + string2 + "], originalSecure=[" + bl2 + "], originalScheme=[" + string3 + "], originalServerName=[" + string4 + "], originalServerPort=[" + n + "] will be seen as newRemoteAddr=[" + request.getRemoteAddr() + "], newRemoteHost=[" + request.getRemoteHost() + "], newSecure=[" + request.isSecure() + "], newScheme=[" + request.getScheme() + "], newServerName=[" + request.getServerName() + "], newServerPort=[" + request.getServerPort() + "]"));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Skip RemoteIpValve for request " + request.getRequestURI() + " with originalRemoteAddr '" + request.getRemoteAddr() + "'"));
        }
        if (this.requestAttributesEnabled) {
            request.setAttribute("org.apache.catalina.AccessLog.RemoteAddr", request.getRemoteAddr());
            request.setAttribute("org.apache.tomcat.remoteAddr", request.getRemoteAddr());
            request.setAttribute("org.apache.catalina.AccessLog.RemoteHost", request.getRemoteHost());
            request.setAttribute("org.apache.catalina.AccessLog.Protocol", request.getProtocol());
            request.setAttribute("org.apache.catalina.AccessLog.ServerName", request.getServerName());
            request.setAttribute("org.apache.catalina.AccessLog.ServerPort", request.getServerPort());
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (!request.isAsync()) {
                request.setRemoteAddr(string);
                request.setRemoteHost(string2);
                request.setSecure(bl2);
                request.getCoyoteRequest().scheme().setString(string3);
                request.getCoyoteRequest().serverName().setString(string4);
                if (this.isChangeLocalName()) {
                    request.getCoyoteRequest().localName().setString(string5);
                }
                request.setServerPort(n);
                request.setLocalPort(n2);
                object = request.getCoyoteRequest().getMimeHeaders();
                if (string6 == null || string6.length() == 0) {
                    object.removeHeader(this.proxiesHeader);
                } else {
                    object.setValue(this.proxiesHeader).setString(string6);
                }
                if (string7 == null || string7.length() == 0) {
                    object.removeHeader(this.remoteIpHeader);
                } else {
                    object.setValue(this.remoteIpHeader).setString(string7);
                }
            }
        }
    }

    private boolean isForwardedProtoHeaderValueSecure(String string) {
        if (!string.contains(",")) {
            return this.protocolHeaderHttpsValue.equalsIgnoreCase(string);
        }
        String[] stringArray = StringUtils.splitCommaSeparated((String)string);
        if (stringArray.length == 0) {
            return false;
        }
        for (String string2 : stringArray) {
            if (this.protocolHeaderHttpsValue.equalsIgnoreCase(string2)) continue;
            return false;
        }
        return true;
    }

    private void setPorts(Request request, int n) {
        int n2;
        block4: {
            String string;
            n2 = n;
            if (this.portHeader != null && (string = request.getHeader(this.portHeader)) != null) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)sm.getString("remoteIpValve.invalidPortHeader", new Object[]{string, this.portHeader}), (Throwable)numberFormatException);
                }
            }
        }
        request.setServerPort(n2);
        if (this.changeLocalPort) {
            request.setLocalPort(n2);
        }
    }

    public void setHttpServerPort(int n) {
        this.httpServerPort = n;
    }

    public void setHttpsServerPort(int n) {
        this.httpsServerPort = n;
    }

    public void setInternalProxies(String string) {
        this.internalProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public void setProtocolHeader(String string) {
        this.protocolHeader = string;
    }

    public void setProtocolHeaderHttpsValue(String string) {
        this.protocolHeaderHttpsValue = string;
    }

    public void setProxiesHeader(String string) {
        this.proxiesHeader = string;
    }

    public void setRemoteIpHeader(String string) {
        this.remoteIpHeader = string;
    }

    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    public void setTrustedProxies(String string) {
        this.trustedProxies = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }
}

