/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.LobCommonAccessorPrototype;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;

class T4CBfileAccessor
extends BfileAccessor {
    T4CMAREngine mare;

    T4CBfileAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 530, form, external_type, isOutBind, false);
        this.mare = _mare;
    }

    T4CBfileAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, 530, nullable, flags, precision, scale, contflag, total_elems, form);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            long previousOffset = this.getOffset(this.previousRowProcessed);
            long previousPrefetchedDataOffset = this.getPrefetchedDataOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                if (this.isPrefetched()) {
                    this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(this.previousRowProcessed));
                    this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(this.previousRowProcessed));
                    this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(this.previousRowProcessed));
                    this.setPrefetchedDataOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousPrefetchedDataOffset, this.getPrefetchedDataLength(this.previousRowProcessed));
                }
                this.setOffset(this.lastRowProcessed);
                this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else {
            this.previousRowProcessed = this.lastRowProcessed - 1;
            if (this.isPrefetched()) {
                this.setPrefetchedLength(this.lastRowProcessed, this.getPrefetchedLength(this.previousRowProcessed));
                this.setPrefetchedChunkSize(this.lastRowProcessed, this.getPrefetchedChunkSize(this.previousRowProcessed));
                this.setPrefetchedDataLength(this.lastRowProcessed, this.getPrefetchedDataLength(this.previousRowProcessed));
                this.setPrefetchedDataOffset(this.lastRowProcessed, this.getPrefetchedDataOffset(this.previousRowProcessed));
            }
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        int len = (int)this.mare.unmarshalUB4();
        if (len == 0) {
            this.setNull(this.lastRowProcessed, true);
            this.processIndicator(0);
        } else {
            if (this.isPrefetched()) {
                this.unmarshalPrefetchData();
            }
            this.setOffset(this.lastRowProcessed);
            int actualLength = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.setNull(this.lastRowProcessed, actualLength == 0);
            this.setLength(this.lastRowProcessed, actualLength);
            this.processIndicator(actualLength);
        }
        return false;
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
        this.setPrefetchedDataOffset(this.lastRowProcessed);
        this.setPrefetchedDataLength(this.lastRowProcessed, 0);
        if (this.getPrefetchLength() > 0) {
            this.mare.unmarshalUB1();
        }
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.definedColumnType == -13) {
            return this.getBFILE(currentRow);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        LobCommonAccessorPrototype p = new LobCommonAccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CBfileAccessor acc = new T4CBfileAccessor(stmt, T4CBfileAccessor.this.describeMaxLength, T4CBfileAccessor.this.nullable, -1, T4CBfileAccessor.this.precision, T4CBfileAccessor.this.scale, T4CBfileAccessor.this.contflag, -1, T4CBfileAccessor.this.formOfUse, T4CBfileAccessor.this.definedColumnType, T4CBfileAccessor.this.definedColumnSize, null);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

