/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationInstancePlatform;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetCapacityReservation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetCapacityReservation> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(FleetCapacityReservation.getter(FleetCapacityReservation::capacityReservationId)).setter(FleetCapacityReservation.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("capacityReservationId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(FleetCapacityReservation.getter(FleetCapacityReservation::availabilityZoneId)).setter(FleetCapacityReservation.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(FleetCapacityReservation.getter(FleetCapacityReservation::instanceTypeAsString)).setter(FleetCapacityReservation.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstancePlatform").getter(FleetCapacityReservation.getter(FleetCapacityReservation::instancePlatformAsString)).setter(FleetCapacityReservation.setter(Builder::instancePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform").unmarshallLocationName("instancePlatform").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(FleetCapacityReservation.getter(FleetCapacityReservation::availabilityZone)).setter(FleetCapacityReservation.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(FleetCapacityReservation.getter(FleetCapacityReservation::totalInstanceCount)).setter(FleetCapacityReservation.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").unmarshallLocationName("totalInstanceCount").build()}).build();
    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FulfilledCapacity").getter(FleetCapacityReservation.getter(FleetCapacityReservation::fulfilledCapacity)).setter(FleetCapacityReservation.setter(Builder::fulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity").unmarshallLocationName("fulfilledCapacity").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(FleetCapacityReservation.getter(FleetCapacityReservation::ebsOptimized)).setter(FleetCapacityReservation.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(FleetCapacityReservation.getter(FleetCapacityReservation::createDate)).setter(FleetCapacityReservation.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<Double> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Weight").getter(FleetCapacityReservation.getter(FleetCapacityReservation::weight)).setter(FleetCapacityReservation.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").unmarshallLocationName("weight").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(FleetCapacityReservation.getter(FleetCapacityReservation::priority)).setter(FleetCapacityReservation.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, FULFILLED_CAPACITY_FIELD, EBS_OPTIMIZED_FIELD, CREATE_DATE_FIELD, WEIGHT_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FleetCapacityReservation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityReservationId;
    private final String availabilityZoneId;
    private final String instanceType;
    private final String instancePlatform;
    private final String availabilityZone;
    private final Integer totalInstanceCount;
    private final Double fulfilledCapacity;
    private final Boolean ebsOptimized;
    private final Instant createDate;
    private final Double weight;
    private final Integer priority;

    private FleetCapacityReservation(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.ebsOptimized = builder.ebsOptimized;
        this.createDate = builder.createDate;
        this.weight = builder.weight;
        this.priority = builder.priority;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(this.instancePlatform);
    }

    public final String instancePlatformAsString() {
        return this.instancePlatform;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final Double weight() {
        return this.weight;
    }

    public final Integer priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacityReservation)) {
            return false;
        }
        FleetCapacityReservation other = (FleetCapacityReservation)obj;
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instancePlatformAsString(), other.instancePlatformAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.fulfilledCapacity(), other.fulfilledCapacity()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"FleetCapacityReservation").add("CapacityReservationId", (Object)this.capacityReservationId()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("InstancePlatform", (Object)this.instancePlatformAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("FulfilledCapacity", (Object)this.fulfilledCapacity()).add("EbsOptimized", (Object)this.ebsOptimized()).add("CreateDate", (Object)this.createDate()).add("Weight", (Object)this.weight()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstancePlatform": {
                return Optional.ofNullable(clazz.cast(this.instancePlatformAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "FulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.fulfilledCapacity()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("FulfilledCapacity", FULFILLED_CAPACITY_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetCapacityReservation, T> g) {
        return obj -> g.apply((FleetCapacityReservation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private String availabilityZoneId;
        private String instanceType;
        private String instancePlatform;
        private String availabilityZone;
        private Integer totalInstanceCount;
        private Double fulfilledCapacity;
        private Boolean ebsOptimized;
        private Instant createDate;
        private Double weight;
        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacityReservation model) {
            this.capacityReservationId(model.capacityReservationId);
            this.availabilityZoneId(model.availabilityZoneId);
            this.instanceType(model.instanceType);
            this.instancePlatform(model.instancePlatform);
            this.availabilityZone(model.availabilityZone);
            this.totalInstanceCount(model.totalInstanceCount);
            this.fulfilledCapacity(model.fulfilledCapacity);
            this.ebsOptimized(model.ebsOptimized);
            this.createDate(model.createDate);
            this.weight(model.weight);
            this.priority(model.priority);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInstancePlatform() {
            return this.instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Double getWeight() {
            return this.weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public FleetCapacityReservation build() {
            return new FleetCapacityReservation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetCapacityReservation> {
        public Builder capacityReservationId(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder instancePlatform(String var1);

        public Builder instancePlatform(CapacityReservationInstancePlatform var1);

        public Builder availabilityZone(String var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder createDate(Instant var1);

        public Builder weight(Double var1);

        public Builder priority(Integer var1);
    }
}

