/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import org.jooq.tools.StringUtils;

public final class XMLFormat {
    public static final XMLFormat DEFAULT_FOR_RESULTS = new XMLFormat();
    public static final XMLFormat DEFAULT_FOR_RECORDS = new XMLFormat().header(false).xmlns(false);
    final boolean xmlns;
    final boolean format;
    final String newline;
    final int indent;
    final String[] indented;
    final boolean header;
    final RecordFormat recordFormat;

    public XMLFormat() {
        this(true, false, "\n", 2, null, true, RecordFormat.VALUE_ELEMENTS_WITH_FIELD_ATTRIBUTE);
    }

    private XMLFormat(boolean xmlns, boolean format, String newline, int indent, String[] indented, boolean header, RecordFormat recordFormat) {
        String[] stringArray;
        this.xmlns = xmlns;
        this.format = format;
        this.newline = newline;
        this.indent = indent;
        if (indented != null) {
            stringArray = indented;
        } else {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "";
            stringArray2[1] = format ? StringUtils.rightPad("", indent * 1) : "";
            stringArray2[2] = format ? StringUtils.rightPad("", indent * 2) : "";
            stringArray = stringArray2;
            stringArray2[3] = format ? StringUtils.rightPad("", indent * 3) : "";
        }
        this.indented = stringArray;
        this.header = header;
        this.recordFormat = recordFormat;
    }

    public XMLFormat xmlns(boolean newXmlns) {
        return new XMLFormat(newXmlns, this.format, this.newline, this.indent, this.indented, this.header, this.recordFormat);
    }

    public boolean xmlns() {
        return this.xmlns;
    }

    public XMLFormat format(boolean newFormat) {
        return new XMLFormat(this.xmlns, newFormat, this.newline, this.indent, null, this.header, this.recordFormat);
    }

    public boolean format() {
        return this.format;
    }

    public XMLFormat newline(String newNewline) {
        return new XMLFormat(this.xmlns, this.format, newNewline, this.indent, this.indented, this.header, this.recordFormat);
    }

    public String newline() {
        return this.format ? this.newline : "";
    }

    public XMLFormat indent(int newIndent) {
        return new XMLFormat(this.xmlns, this.format, this.newline, newIndent, null, this.header, this.recordFormat);
    }

    public int indent() {
        return this.indent;
    }

    public String indentString(int level) {
        if (level < this.indented.length) {
            return this.indented[level];
        }
        if (this.format) {
            return StringUtils.rightPad("", this.indent * level);
        }
        return "";
    }

    public XMLFormat header(boolean newHeader) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.indent, this.indented, newHeader, this.recordFormat);
    }

    public boolean header() {
        return this.header;
    }

    public XMLFormat recordFormat(RecordFormat newRecordFormat) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.indent, this.indented, this.header, newRecordFormat);
    }

    public RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public static enum RecordFormat {
        VALUE_ELEMENTS_WITH_FIELD_ATTRIBUTE,
        VALUE_ELEMENTS,
        COLUMN_NAME_ELEMENTS;

    }
}

