\name{BinaryThresholdProjectionImageFilter}
\alias{BinaryThresholdProjectionImageFilter}
\title{BinaryThresholdProjectionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
BinaryThreshold projection.
BinaryThresholdProjectionImageFilter}
\details{
This class was contributed to the Insight Journal by Gaetan Lehmann.
the original paper can be found at https://www.insight-journal.org/browse/publication/71
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ProjectionImageFilter
MedianProjectionImageFilter
MeanProjectionImageFilter
MeanProjectionImageFilter
MaximumProjectionImageFilter
MinimumProjectionImageFilter
StandardDeviationProjectionImageFilter
SumProjectionImageFilter
BinaryThresholdProjection for the procedural interface
itk::BinaryThresholdProjectionImageFilter for the Doxygen on the original ITK class.
BinaryThresholdProjectionImageFilter}
%C++ includes: sitkBinaryThresholdProjectionImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryThresholdProjectionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint8_t GetBackgroundValue() const:}{
Set/Get the output value used as "background". Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{uint8_t GetForegroundValue() const:}{
Set/Get the output value used as "foreground". Defaults to maximum
value of PixelType.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetProjectionDimension() const:}{}
\item{double GetThresholdValue() const:}{
Set/Get the input value consider as "threshold". Defaults to NumericTraits<InputPixelType>::max()
}
\item{Self SetBackgroundValue(uint8_t BackgroundValue):}{
Set/Get the output value used as "background". Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(uint8_t ForegroundValue):}{
Set/Get the output value used as "foreground". Defaults to maximum
value of PixelType.
}
\item{Self SetProjectionDimension(unsigned int ProjectionDimension):}{}
\item{Self SetThresholdValue(double ThresholdValue):}{
Set/Get the input value consider as "threshold". Defaults to NumericTraits<InputPixelType>::max()
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryThresholdProjectionImageFilter():}{
Destructor
}
}
}
