\name{NeighborhoodConnectedImageFilter}
\alias{NeighborhoodConnectedImageFilter}
\title{NeighborhoodConnectedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Label pixels that are connected to a seed and lie within a neighborhood.
NeighborhoodConnectedImageFilter}
\details{
NeighborhoodConnectedImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND whose neighbors all lie within a Lower and Upper threshold range.
See:
NeighborhoodConnected for the procedural interface
itk::NeighborhoodConnectedImageFilter for the Doxygen on the original ITK class.
NeighborhoodConnectedImageFilter}
%C++ includes: sitkNeighborhoodConnectedImageFilter.h
\section{Methods}{
\describe{
\item{Self AddSeed(std::vector< unsigned int > point):}{
Add SeedList point.
}
\item{Self ClearSeeds():}{
Remove all SeedList points.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetLower() const:}{
Set/Get the lower threshold. The default is 0.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{
Get the radius of the neighborhood used to compute the median
}
\item{double GetReplaceValue() const:}{
Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.
}
\item{std::vector< std::vector< unsigned int > > GetSeedList() const:}{
Get list of seeds.
}
\item{double GetUpper() const:}{
Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.
}
\item{ NeighborhoodConnectedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetLower(double Lower):}{
Set/Get the lower threshold. The default is 0.
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{
Set the radius of the neighborhood used for a mask.
}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{Self SetReplaceValue(double ReplaceValue):}{
Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.
}
\item{Self SetSeedList(std::vector< std::vector< unsigned int > > SeedList):}{
Set list of image indexes for seeds.
}
\item{Self SetUpper(double Upper):}{
Set/Get the upper threshold. The default is the largest possible value
for the InputPixelType.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NeighborhoodConnectedImageFilter():}{
Destructor
}
}
}
