/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.CheckIn;
import io.sentry.DataCategory;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IMetricsAggregator;
import io.sentry.IScope;
import io.sentry.ISentryClient;
import io.sentry.ISentryExecutorService;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.ITransactionProfiler;
import io.sentry.Integration;
import io.sentry.NoOpScope;
import io.sentry.NoOpSentryClient;
import io.sentry.NoOpTransaction;
import io.sentry.ProfilingTraceData;
import io.sentry.PropagationContext;
import io.sentry.SamplingContext;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.SentryClient;
import io.sentry.SentryCrashLastRunState;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SentryTracer;
import io.sentry.Session;
import io.sentry.SpanContext;
import io.sentry.Stack;
import io.sentry.TraceContext;
import io.sentry.TracesSampler;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.UserFeedback;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.SessionEndHint;
import io.sentry.hints.SessionStartHint;
import io.sentry.metrics.LocalMetricsAggregator;
import io.sentry.metrics.MetricsApi;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.transport.RateLimiter;
import io.sentry.util.ExceptionUtils;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import io.sentry.util.Pair;
import io.sentry.util.TracingUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Hub
implements IHub,
MetricsApi.IMetricsInterface {
    @NotNull
    private volatile SentryId lastEventId;
    @NotNull
    private final SentryOptions options;
    private volatile boolean isEnabled;
    @NotNull
    private final Stack stack;
    @NotNull
    private final TracesSampler tracesSampler;
    @NotNull
    private final Map<Throwable, Pair<WeakReference<ISpan>, String>> throwableToSpan = Collections.synchronizedMap(new WeakHashMap());
    @NotNull
    private final TransactionPerformanceCollector transactionPerformanceCollector;
    @NotNull
    private final MetricsApi metricsApi;

    public Hub(@NotNull SentryOptions options2) {
        this(options2, Hub.createRootStackItem(options2));
    }

    private Hub(@NotNull SentryOptions options2, @NotNull Stack stack) {
        Hub.validateOptions(options2);
        this.options = options2;
        this.tracesSampler = new TracesSampler(options2);
        this.stack = stack;
        this.lastEventId = SentryId.EMPTY_ID;
        this.transactionPerformanceCollector = options2.getTransactionPerformanceCollector();
        this.isEnabled = true;
        this.metricsApi = new MetricsApi(this);
    }

    private Hub(@NotNull SentryOptions options2, @NotNull Stack.StackItem rootStackItem) {
        this(options2, new Stack(options2.getLogger(), rootStackItem));
    }

    private static void validateOptions(@NotNull SentryOptions options2) {
        Objects.requireNonNull(options2, "SentryOptions is required.");
        if (options2.getDsn() == null || options2.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Hub requires a DSN to be instantiated. Considering using the NoOpHub if no DSN is available.");
        }
    }

    private static Stack.StackItem createRootStackItem(@NotNull SentryOptions options2) {
        Hub.validateOptions(options2);
        Scope scope = new Scope(options2);
        SentryClient client = new SentryClient(options2);
        return new Stack.StackItem(options2, client, scope);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint) {
        return this.captureEventInternal(event, hint, null);
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return this.captureEventInternal(event, hint, callback);
    }

    @NotNull
    private SentryId captureEventInternal(@NotNull SentryEvent event, @Nullable Hint hint, @Nullable ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                this.assignTraceContext(event);
                Stack.StackItem item = this.stack.peek();
                IScope scope = this.buildLocalScope(item.getScope(), scopeCallback);
                this.lastEventId = sentryId = item.getClient().captureEvent(event, scope, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing event with id: " + event.getEventId(), e);
            }
        }
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return this.captureMessageInternal(message, level, null);
    }

    @Override
    @NotNull
    public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @NotNull ScopeCallback callback) {
        return this.captureMessageInternal(message, level, callback);
    }

    @NotNull
    private SentryId captureMessageInternal(@NotNull String message, @NotNull SentryLevel level, @Nullable ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureMessage' call is a no-op.", new Object[0]);
        } else if (message == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureMessage called with null parameter.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                IScope scope = this.buildLocalScope(item.getScope(), scopeCallback);
                sentryId = item.getClient().captureMessage(message, level, scope);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing message: " + message, e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Hint hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEnvelope' call is a no-op.", new Object[0]);
        } else {
            try {
                SentryId capturedEnvelopeId = this.stack.peek().getClient().captureEnvelope(envelope, hint);
                if (capturedEnvelopeId != null) {
                    sentryId = capturedEnvelopeId;
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing envelope.", e);
            }
        }
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return this.captureExceptionInternal(throwable, hint, null);
    }

    @Override
    @NotNull
    public SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return this.captureExceptionInternal(throwable, hint, callback);
    }

    @NotNull
    private SentryId captureExceptionInternal(@NotNull Throwable throwable, @Nullable Hint hint, @Nullable ScopeCallback scopeCallback) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                SentryEvent event = new SentryEvent(throwable);
                this.assignTraceContext(event);
                IScope scope = this.buildLocalScope(item.getScope(), scopeCallback);
                sentryId = item.getClient().captureEvent(event, scope, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing exception: " + throwable.getMessage(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    private void assignTraceContext(@NotNull SentryEvent event) {
        Pair<WeakReference<ISpan>, String> pair;
        if (this.options.isTracingEnabled() && event.getThrowable() != null && (pair = this.throwableToSpan.get(ExceptionUtils.findRootCause(event.getThrowable()))) != null) {
            ISpan span;
            WeakReference<ISpan> spanWeakRef = pair.getFirst();
            if (event.getContexts().getTrace() == null && spanWeakRef != null && (span = (ISpan)spanWeakRef.get()) != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            String transactionName = pair.getSecond();
            if (event.getTransaction() == null && transactionName != null) {
                event.setTransaction(transactionName);
            }
        }
    }

    @Override
    public void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureUserFeedback' call is a no-op.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                item.getClient().captureUserFeedback(userFeedback);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing captureUserFeedback: " + userFeedback.toString(), e);
            }
        }
    }

    @Override
    public void startSession() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'startSession' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Scope.SessionPair pair = item.getScope().startSession();
            if (pair != null) {
                Hint hint;
                if (pair.getPrevious() != null) {
                    hint = HintUtils.createWithTypeCheckHint(new SessionEndHint());
                    item.getClient().captureSession(pair.getPrevious(), hint);
                }
                hint = HintUtils.createWithTypeCheckHint(new SessionStartHint());
                item.getClient().captureSession(pair.getCurrent(), hint);
            } else {
                this.options.getLogger().log(SentryLevel.WARNING, "Session could not be started.", new Object[0]);
            }
        }
    }

    @Override
    public void endSession() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'endSession' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Session previousSession = item.getScope().endSession();
            if (previousSession != null) {
                Hint hint = HintUtils.createWithTypeCheckHint(new SessionEndHint());
                item.getClient().captureSession(previousSession, hint);
            }
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean isRestarting) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
        } else {
            try {
                for (Integration integration : this.options.getIntegrations()) {
                    if (!(integration instanceof Closeable)) continue;
                    try {
                        ((Closeable)((Object)integration)).close();
                    }
                    catch (IOException e) {
                        this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the integration {}.", integration, e);
                    }
                }
                this.configureScope(scope -> scope.clear());
                this.options.getTransactionProfiler().close();
                this.options.getTransactionPerformanceCollector().close();
                @NotNull ISentryExecutorService executorService = this.options.getExecutorService();
                if (isRestarting) {
                    executorService.submit(() -> executorService.close(this.options.getShutdownTimeoutMillis()));
                } else {
                    executorService.close(this.options.getShutdownTimeoutMillis());
                }
                Stack.StackItem item = this.stack.peek();
                item.getClient().close(isRestarting);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while closing the Hub.", e);
            }
            this.isEnabled = false;
        }
    }

    @Override
    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Hint hint) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'addBreadcrumb' call is a no-op.", new Object[0]);
        } else if (breadcrumb == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "addBreadcrumb called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().addBreadcrumb(breadcrumb, hint);
        }
    }

    @Override
    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.addBreadcrumb(breadcrumb, new Hint());
    }

    @Override
    public void setLevel(@Nullable SentryLevel level) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setLevel' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().setLevel(level);
        }
    }

    @Override
    public void setTransaction(@Nullable String transaction) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setTransaction' call is a no-op.", new Object[0]);
        } else if (transaction != null) {
            this.stack.peek().getScope().setTransaction(transaction);
        } else {
            this.options.getLogger().log(SentryLevel.WARNING, "Transaction cannot be null", new Object[0]);
        }
    }

    @Override
    public void setUser(@Nullable User user) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setUser' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().setUser(user);
        }
    }

    @Override
    public void setFingerprint(@NotNull List<String> fingerprint) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setFingerprint' call is a no-op.", new Object[0]);
        } else if (fingerprint == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setFingerprint called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setFingerprint(fingerprint);
        }
    }

    @Override
    public void clearBreadcrumbs() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'clearBreadcrumbs' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().clearBreadcrumbs();
        }
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value2) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setTag' call is a no-op.", new Object[0]);
        } else if (key == null || value2 == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setTag called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setTag(key, value2);
        }
    }

    @Override
    public void removeTag(@NotNull String key) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'removeTag' call is a no-op.", new Object[0]);
        } else if (key == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "removeTag called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().removeTag(key);
        }
    }

    @Override
    public void setExtra(@NotNull String key, @NotNull String value2) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setExtra' call is a no-op.", new Object[0]);
        } else if (key == null || value2 == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setExtra called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setExtra(key, value2);
        }
    }

    @Override
    public void removeExtra(@NotNull String key) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'removeExtra' call is a no-op.", new Object[0]);
        } else if (key == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "removeExtra called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().removeExtra(key);
        }
    }

    @Override
    @NotNull
    public SentryId getLastEventId() {
        return this.lastEventId;
    }

    @Override
    public void pushScope() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'pushScope' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Stack.StackItem newItem = new Stack.StackItem(this.options, item.getClient(), item.getScope().clone());
            this.stack.push(newItem);
        }
    }

    @Override
    @NotNull
    public SentryOptions getOptions() {
        return this.stack.peek().getOptions();
    }

    @Override
    @Nullable
    public Boolean isCrashedLastRun() {
        return SentryCrashLastRunState.getInstance().isCrashedLastRun(this.options.getCacheDirPath(), !this.options.isEnableAutoSessionTracking());
    }

    @Override
    public void reportFullyDisplayed() {
        if (this.options.isEnableTimeToFullDisplayTracing()) {
            this.options.getFullyDisplayedReporter().reportFullyDrawn();
        }
    }

    @Override
    public void popScope() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'popScope' call is a no-op.", new Object[0]);
        } else {
            this.stack.pop();
        }
    }

    @Override
    public void withScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            try {
                callback.run(NoOpScope.getInstance());
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'withScope' callback.", e);
            }
        } else {
            this.pushScope();
            try {
                callback.run(this.stack.peek().getScope());
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'withScope' callback.", e);
            }
            this.popScope();
        }
    }

    @Override
    public void configureScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'configureScope' call is a no-op.", new Object[0]);
        } else {
            try {
                callback.run(this.stack.peek().getScope());
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'configureScope' callback.", e);
            }
        }
    }

    @Override
    public void bindClient(@NotNull ISentryClient client) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'bindClient' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            if (client != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "New client bound to scope.", new Object[0]);
                item.setClient(client);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "NoOp client bound to scope.", new Object[0]);
                item.setClient(NoOpSentryClient.getInstance());
            }
        }
    }

    @Override
    public boolean isHealthy() {
        return this.stack.peek().getClient().isHealthy();
    }

    @Override
    public void flush(long timeoutMillis) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
        } else {
            try {
                this.stack.peek().getClient().flush(timeoutMillis);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'client.flush'.", e);
            }
        }
    }

    @Override
    @NotNull
    public IHub clone() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabled Hub cloned.", new Object[0]);
        }
        return new Hub(this.options, new Stack(this.stack));
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Hint hint, @Nullable ProfilingTraceData profilingTraceData) {
        Objects.requireNonNull(transaction, "transaction is required");
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureTransaction' call is a no-op.", new Object[0]);
        } else if (!transaction.isFinished()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Transaction: %s is not finished and this 'captureTransaction' call is a no-op.", transaction.getEventId());
        } else if (!Boolean.TRUE.equals(transaction.isSampled())) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s was dropped due to sampling decision.", transaction.getEventId());
            if (this.options.getBackpressureMonitor().getDownsampleFactor() > 0) {
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.BACKPRESSURE, DataCategory.Transaction);
            } else {
                this.options.getClientReportRecorder().recordLostEvent(DiscardReason.SAMPLE_RATE, DataCategory.Transaction);
            }
        } else {
            Stack.StackItem item = null;
            try {
                item = this.stack.peek();
                sentryId = item.getClient().captureTransaction(transaction, traceContext, item.getScope(), hint, profilingTraceData);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing transaction with id: " + transaction.getEventId(), e);
            }
        }
        return sentryId;
    }

    @Override
    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        return this.createTransaction(transactionContext, transactionOptions);
    }

    @NotNull
    private ITransaction createTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        ITransaction transaction;
        Objects.requireNonNull(transactionContext, "transactionContext is required");
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'startTransaction' returns a no-op.", new Object[0]);
            transaction = NoOpTransaction.getInstance();
        } else if (!this.options.getInstrumenter().equals((Object)transactionContext.getInstrumenter())) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Returning no-op for instrumenter %s as the SDK has been configured to use instrumenter %s", new Object[]{transactionContext.getInstrumenter(), this.options.getInstrumenter()});
            transaction = NoOpTransaction.getInstance();
        } else if (!this.options.isTracingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Tracing is disabled and this 'startTransaction' returns a no-op.", new Object[0]);
            transaction = NoOpTransaction.getInstance();
        } else {
            SamplingContext samplingContext = new SamplingContext(transactionContext, transactionOptions.getCustomSamplingContext());
            @NotNull TracesSamplingDecision samplingDecision = this.tracesSampler.sample(samplingContext);
            transactionContext.setSamplingDecision(samplingDecision);
            transaction = new SentryTracer(transactionContext, this, transactionOptions, this.transactionPerformanceCollector);
            if (samplingDecision.getSampled().booleanValue() && samplingDecision.getProfileSampled().booleanValue()) {
                ITransactionProfiler transactionProfiler = this.options.getTransactionProfiler();
                if (!transactionProfiler.isRunning()) {
                    transactionProfiler.start();
                    transactionProfiler.bindTransaction(transaction);
                } else if (transactionOptions.isAppStartTransaction()) {
                    transactionProfiler.bindTransaction(transaction);
                }
            }
        }
        if (transactionOptions.isBindToScope()) {
            this.configureScope(scope -> scope.setTransaction(transaction));
        }
        return transaction;
    }

    @Override
    @Deprecated
    @Nullable
    public SentryTraceHeader traceHeaders() {
        return this.getTraceparent();
    }

    @Override
    @Nullable
    public ISpan getSpan() {
        ISpan span = null;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getSpan' call is a no-op.", new Object[0]);
        } else {
            span = this.stack.peek().getScope().getSpan();
        }
        return span;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ITransaction getTransaction() {
        ITransaction span = null;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getTransaction' call is a no-op.", new Object[0]);
        } else {
            span = this.stack.peek().getScope().getTransaction();
        }
        return span;
    }

    @Override
    @ApiStatus.Internal
    public void setSpanContext(@NotNull Throwable throwable, @NotNull ISpan span, @NotNull String transactionName) {
        Objects.requireNonNull(throwable, "throwable is required");
        Objects.requireNonNull(span, "span is required");
        Objects.requireNonNull(transactionName, "transactionName is required");
        Throwable rootCause = ExceptionUtils.findRootCause(throwable);
        if (!this.throwableToSpan.containsKey(rootCause)) {
            this.throwableToSpan.put(rootCause, new Pair<WeakReference<ISpan>, String>(new WeakReference<ISpan>(span), transactionName));
        }
    }

    @Nullable
    SpanContext getSpanContext(@NotNull Throwable throwable) {
        ISpan span;
        WeakReference<ISpan> spanWeakRef;
        Objects.requireNonNull(throwable, "throwable is required");
        Throwable rootCause = ExceptionUtils.findRootCause(throwable);
        Pair<WeakReference<ISpan>, String> pair = this.throwableToSpan.get(rootCause);
        if (pair != null && (spanWeakRef = pair.getFirst()) != null && (span = (ISpan)spanWeakRef.get()) != null) {
            return span.getSpanContext();
        }
        return null;
    }

    private IScope buildLocalScope(@NotNull IScope scope, @Nullable ScopeCallback callback) {
        if (callback != null) {
            try {
                IScope localScope = scope.clone();
                callback.run(localScope);
                return localScope;
            }
            catch (Throwable t2) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'ScopeCallback' callback.", t2);
            }
        }
        return scope;
    }

    @Override
    @Nullable
    public TransactionContext continueTrace(@Nullable String sentryTrace, @Nullable List<String> baggageHeaders) {
        @NotNull PropagationContext propagationContext = PropagationContext.fromHeaders(this.getOptions().getLogger(), sentryTrace, baggageHeaders);
        this.configureScope(scope -> scope.setPropagationContext(propagationContext));
        if (this.options.isTracingEnabled()) {
            return TransactionContext.fromPropagationContext(propagationContext);
        }
        return null;
    }

    @Override
    @Nullable
    public SentryTraceHeader getTraceparent() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getTraceparent' call is a no-op.", new Object[0]);
        } else {
            @Nullable TracingUtils.TracingHeaders headers = TracingUtils.trace(this, null, this.getSpan());
            if (headers != null) {
                return headers.getSentryTraceHeader();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BaggageHeader getBaggage() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getBaggage' call is a no-op.", new Object[0]);
        } else {
            @Nullable TracingUtils.TracingHeaders headers = TracingUtils.trace(this, null, this.getSpan());
            if (headers != null) {
                return headers.getBaggageHeader();
            }
        }
        return null;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public SentryId captureCheckIn(@NotNull CheckIn checkIn) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureCheckIn' call is a no-op.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                sentryId = item.getClient().captureCheckIn(checkIn, item.getScope(), null);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing check-in for slug", e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public RateLimiter getRateLimiter() {
        Stack.StackItem item = this.stack.peek();
        return item.getClient().getRateLimiter();
    }

    @Override
    @NotNull
    public MetricsApi metrics() {
        return this.metricsApi;
    }

    @Override
    @NotNull
    public IMetricsAggregator getMetricsAggregator() {
        return this.stack.peek().getClient().getMetricsAggregator();
    }

    @Override
    @NotNull
    public Map<String, String> getDefaultTagsForMetrics() {
        String txnName;
        String environment;
        if (!this.options.isEnableDefaultTagsForMetrics()) {
            return Collections.emptyMap();
        }
        @NotNull HashMap<String, String> tags = new HashMap<String, String>();
        @Nullable String release = this.options.getRelease();
        if (release != null) {
            tags.put("release", release);
        }
        if ((environment = this.options.getEnvironment()) != null) {
            tags.put("environment", environment);
        }
        if ((txnName = this.stack.peek().getScope().getTransactionName()) != null) {
            tags.put("transaction", txnName);
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    @Nullable
    public ISpan startSpanForMetric(@NotNull String op, @NotNull String description) {
        @Nullable ISpan span = this.getSpan();
        if (span != null) {
            return span.startChild(op, description);
        }
        return null;
    }

    @Override
    @Nullable
    public LocalMetricsAggregator getLocalMetricsAggregator() {
        if (!this.options.isEnableSpanLocalMetricAggregation()) {
            return null;
        }
        @Nullable ISpan span = this.getSpan();
        if (span != null) {
            return span.getLocalMetricsAggregator();
        }
        return null;
    }
}

