/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class Counter64
extends AbstractVariable
implements AssignableFromLong,
AssignableFromString {
    private static final long serialVersionUID = 8741539680564150071L;
    private long value = 0L;

    public Counter64() {
    }

    public Counter64(long value) {
        this.setValue(value);
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInt64(outputStream, (byte)70, this.value);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        long newValue = BER.decodeUnsignedInt64(inputStream, type);
        if (type.getValue() != 70) {
            throw new IOException("Wrong type encountered when decoding Counter64: " + type.getValue());
        }
        this.setValue(newValue);
    }

    @Override
    public int getSyntax() {
        return 70;
    }

    @Override
    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int getBERLength() {
        if (this.value < 0L) {
            return 11;
        }
        if (this.value < 0x80000000L) {
            if (this.value < 32768L) {
                return this.value < 128L ? 3 : 4;
            }
            return this.value < 0x800000L ? 5 : 6;
        }
        if (this.value < 0x800000000000L) {
            return this.value < 0x8000000000L ? 7 : 8;
        }
        return this.value < 0x80000000000000L ? 9 : 10;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Counter64 && ((Counter64)o).value == this.value;
    }

    @Override
    public int compareTo(Variable o) {
        long other = ((Counter64)o).value;
        for (int i = 63; i >= 0; --i) {
            if ((this.value >> i & 1L) == (other >> i & 1L)) continue;
            if ((this.value >> i & 1L) != 0L) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        if (this.value > 0L && this.value < Long.MAX_VALUE) {
            return Long.toString(this.value);
        }
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(this.value >> (7 - i) * 8 & 0xFFL);
        }
        BigInteger i64 = new BigInteger(1, bytes);
        return i64.toString();
    }

    @Override
    public void setValue(String value) {
        this.value = Long.parseLong(value);
    }

    @Override
    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new Counter64(this.value);
    }

    public void increment() {
        ++this.value;
    }

    public long increment(long increment) {
        if (increment < 0L) {
            throw new IllegalArgumentException("Counter64 allows only positive increments: " + increment);
        }
        return this.value += increment;
    }

    @Override
    public final int toInt() {
        return (int)this.getValue();
    }

    @Override
    public final long toLong() {
        return this.getValue();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }
}

