/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.UndoHandler;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.DirectActions;
import org.apache.derby.impl.store.raw.data.DirectAllocActions;
import org.apache.derby.impl.store.raw.data.EncryptOrDecryptData;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.InputStreamContainer;
import org.apache.derby.impl.store.raw.data.LoggableActions;
import org.apache.derby.impl.store.raw.data.LoggableAllocActions;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.impl.store.raw.data.RFResource;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.ReclaimSpaceHelper;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.impl.store.raw.data.StreamFileContainerHandle;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.ProductVersionHolder;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class BaseDataFileFactory
implements DataFactory,
CacheableFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction<Object> {
    StorageFactory storageFactory;
    WritableStorageFactory writableStorageFactory;
    private long nextContainerId = System.currentTimeMillis();
    private boolean databaseEncrypted;
    private CacheManager pageCache;
    private CacheManager containerCache;
    private LogFactory logFactory;
    private ProductVersionHolder jbmsVersion;
    private String jvmVersion;
    private String osInfo;
    private String jarCPath;
    private RawStoreFactory rawStoreFactory;
    private String dataDirectory;
    private boolean throwDBlckException;
    private UUID identifier;
    private final Object freezeSemaphore = new Object();
    private boolean isFrozen;
    private int writersInProgress;
    private boolean removeStubsOK;
    private boolean isCorrupt;
    private boolean inCreateNoLog;
    private StorageRandomAccessFile fileLockOnDB;
    private StorageFile exFileLock;
    private HeaderPrintWriter istream;
    private static final String LINE = "----------------------------------------------------------------";
    boolean dataNotSyncedAtAllocation = true;
    boolean dataNotSyncedAtCheckpoint = false;
    private PageActions loggablePageActions;
    private AllocationActions loggableAllocActions;
    private boolean readOnly;
    private boolean supportsRandomAccess;
    private FileResource fileHandler;
    private Hashtable<LogInstant, Object[]> droppedTableStubInfo;
    private Hashtable<String, StorageFile> postRecoveryRemovedFiles;
    private int actionCode;
    private static final int REMOVE_TEMP_DIRECTORY_ACTION = 2;
    private static final int GET_CONTAINER_PATH_ACTION = 3;
    private static final int GET_ALTERNATE_CONTAINER_PATH_ACTION = 4;
    private static final int FIND_MAX_CONTAINER_ID_ACTION = 5;
    private static final int DELETE_IF_EXISTS_ACTION = 6;
    private static final int GET_PATH_ACTION = 7;
    private static final int POST_RECOVERY_REMOVE_ACTION = 8;
    private static final int REMOVE_STUBS_ACTION = 9;
    private static final int BOOT_ACTION = 10;
    private static final int GET_LOCK_ON_DB_ACTION = 11;
    private static final int RELEASE_LOCK_ON_DB_ACTION = 12;
    private static final int RESTORE_DATA_DIRECTORY_ACTION = 13;
    private static final int GET_CONTAINER_NAMES_ACTION = 14;
    private ContainerKey containerId;
    private boolean stub;
    private StorageFile actionFile;
    private UUID myUUID;
    private UUIDFactory uuidFactory;
    private String databaseDirectory;
    private File backupRoot;
    private String[] bfilelist;
    private UndoHandler undo_handler = null;

    public BaseDataFileFactory() {
        SecurityUtil.checkDerbyInternalsPrivilege();
    }

    @Override
    public boolean canSupport(Properties startParams) {
        String serviceType = startParams.getProperty("derby.__rt.serviceType");
        if (serviceType == null) {
            return false;
        }
        if (!this.handleServiceType(serviceType)) {
            return false;
        }
        return startParams.getProperty("derby.__rt.serviceDirectory") != null;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        String encryptionProp22;
        this.jbmsVersion = BaseDataFileFactory.getMonitor().getEngineVersion();
        this.jvmVersion = BaseDataFileFactory.buildJvmVersion();
        this.osInfo = BaseDataFileFactory.buildOSinfo();
        this.jarCPath = BaseDataFileFactory.jarClassPath(this.getClass());
        this.dataDirectory = startParams.getProperty("derby.__rt.serviceDirectory");
        UUIDFactory uf = BaseDataFileFactory.getMonitor().getUUIDFactory();
        this.identifier = uf.createUUID();
        PersistentService ps = BaseDataFileFactory.getMonitor().getServiceType(this);
        try {
            this.storageFactory = ps.getStorageFactoryInstance(true, this.dataDirectory, startParams.getProperty("derby.storage.tempDirectory", PropertyUtil.getSystemProperty("derby.storage.tempDirectory")), this.identifier.toANSIidentifier());
        }
        catch (IOException ioe) {
            if (create) {
                throw StandardException.newException((String)"XBM0H.D", (Throwable)ioe, (Object[])new Object[]{this.dataDirectory});
            }
            throw StandardException.newException((String)"XJ004.C", (Throwable)ioe, (Object[])new Object[]{this.dataDirectory});
        }
        if (this.luceneLoaded() && (encryptionProp22 = startParams.getProperty("dataEncryption")) != null && "TRUE".equals(encryptionProp22.toUpperCase())) {
            throw StandardException.newException((String)"42XBL", (Object[])new Object[0]);
        }
        if (this.storageFactory instanceof WritableStorageFactory) {
            this.writableStorageFactory = (WritableStorageFactory)this.storageFactory;
        }
        this.actionCode = 10;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException encryptionProp22) {
            // empty catch block
        }
        String value = startParams.getProperty("derby.database.forceDatabaseLock", PropertyUtil.getSystemProperty("derby.database.forceDatabaseLock"));
        this.throwDBlckException = Boolean.valueOf(value != null ? value.trim() : value);
        if (!this.isReadOnly()) {
            this.getJBMSLockOnDB(this.identifier, uf, this.dataDirectory);
        }
        String restoreFrom = null;
        restoreFrom = startParams.getProperty("createFrom");
        if (restoreFrom == null) {
            restoreFrom = startParams.getProperty("restoreFrom");
        }
        if (restoreFrom == null) {
            restoreFrom = startParams.getProperty("rollForwardRecoveryFrom");
        }
        if (restoreFrom != null) {
            try {
                String dataEncryption = startParams.getProperty("dataEncryption");
                this.databaseEncrypted = Boolean.valueOf(dataEncryption);
                this.restoreDataDirectory(restoreFrom);
            }
            catch (StandardException se) {
                this.releaseJBMSLockOnDB();
                throw se;
            }
        }
        this.logMsg(LINE);
        String messageID = this.isReadOnly() ? "D000" : "D001";
        boolean logBootTrace = Boolean.valueOf(startParams.getProperty("derby.stream.error.logBootTrace", PropertyUtil.getSystemProperty("derby.stream.error.logBootTrace")));
        this.logMsg(new Date() + MessageService.getTextMessage((String)messageID, (Object[])new Object[]{this.jbmsVersion, this.identifier, this.dataDirectory, this.getClass().getClassLoader(), this.jarCPath}));
        this.logMsg(this.jvmVersion);
        this.logMsg(this.osInfo);
        this.logMsg("derby.system.home=" + PropertyUtil.getSystemProperty("derby.system.home"));
        String target = PropertyUtil.getSystemProperty("derby.stream.error.style");
        if (target != null) {
            this.logMsg("derby.stream.error.style=" + target);
        }
        if ((target = PropertyUtil.getSystemProperty("derby.stream.error.file")) != null) {
            this.logMsg("derby.stream.error.file=" + target);
        }
        if ((target = PropertyUtil.getSystemProperty("derby.stream.error.method")) != null) {
            this.logMsg("derby.stream.error.method=" + target);
        }
        if ((target = PropertyUtil.getSystemProperty("derby.stream.error.field")) != null) {
            this.logMsg("derby.stream.error.field=" + target);
        }
        if (logBootTrace) {
            Monitor.logThrowable(new Throwable("boot trace"));
        }
        uf = null;
        CacheFactory cf = (CacheFactory)BaseDataFileFactory.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        int pageCacheSize = this.getIntParameter("derby.storage.pageCacheSize", null, 1000, 40, Integer.MAX_VALUE);
        this.pageCache = cf.newCacheManager(this, "PageCache", pageCacheSize / 2, pageCacheSize);
        int fileCacheSize = this.getIntParameter("derby.storage.fileCacheSize", null, 100, 2, Integer.MAX_VALUE);
        this.containerCache = cf.newCacheManager(this, "ContainerCache", fileCacheSize / 2, fileCacheSize);
        this.pageCache.registerMBean(this.dataDirectory);
        this.containerCache.registerMBean(this.dataDirectory);
        if (create) {
            String noLog = startParams.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = noLog != null && Boolean.valueOf(noLog) != false;
        }
        this.droppedTableStubInfo = new Hashtable();
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.dataNotSyncedAtCheckpoint = true;
            Monitor.logMessage(MessageService.getTextMessage((String)"D013", (Object[])new Object[]{"derby.system.durability", "test"}));
        }
        this.fileHandler = new RFResource(this);
    }

    @Override
    public void stop() {
        DaemonService rawStoreDaemon;
        boolean OK = false;
        if (this.rawStoreFactory != null && (rawStoreDaemon = this.rawStoreFactory.getDaemon()) != null) {
            rawStoreDaemon.stop();
        }
        boolean logBootTrace = PropertyUtil.getSystemBoolean("derby.stream.error.logBootTrace");
        this.logMsg(LINE);
        this.logMsg(new Date() + MessageService.getTextMessage((String)"D002", (Object[])new Object[]{this.getIdentifier(), this.getRootDirectory(), this.getClass().getClassLoader()}));
        if (logBootTrace) {
            Monitor.logThrowable(new Throwable("shutdown trace"));
        }
        if (!this.isCorrupt) {
            try {
                if (this.pageCache != null && this.containerCache != null) {
                    this.pageCache.shutdown();
                    this.containerCache.shutdown();
                    OK = true;
                }
            }
            catch (StandardException se) {
                se.printStackTrace(this.istream.getPrintWriter());
            }
        }
        this.removeTempDirectory();
        if (this.isReadOnly()) {
            if (this.storageFactory != null) {
                this.storageFactory.shutdown();
            }
            return;
        }
        if (this.removeStubsOK && OK) {
            this.removeStubs();
        }
        this.releaseJBMSLockOnDB();
        if (this.writableStorageFactory != null) {
            this.writableStorageFactory.shutdown();
        }
    }

    @Override
    public Cacheable newCacheable(CacheManager cm) {
        if (cm == this.pageCache) {
            StoredPage sp = new StoredPage();
            sp.setFactory(this);
            return sp;
        }
        return this.newContainerObject();
    }

    @Override
    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException((String)"XSDG5.D", (Object[])new Object[0]);
        }
        this.checkpoint();
        this.inCreateNoLog = false;
    }

    @Override
    public ContainerHandle openContainer(RawTransaction t, ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        return this.openContainer(t, containerId, locking, mode, false);
    }

    @Override
    public RawContainerHandle openDroppedContainer(RawTransaction t, ContainerKey containerId, LockingPolicy locking, int mode) throws StandardException {
        return this.openContainer(t, containerId, locking, mode |= 0x400, true);
    }

    private RawContainerHandle openContainer(RawTransaction t, ContainerKey identity, LockingPolicy locking, int mode, boolean droppedOK) throws StandardException {
        boolean waitForLock;
        if ((mode & 0xC) == 12) {
            SanityManager.THROWASSERT((String)"update and readonly mode specified");
        }
        boolean bl = waitForLock = (mode & 0x80) == 0;
        if ((mode & 0x40) != 0) {
            BaseContainerHandle lockOnlyHandle = new BaseContainerHandle(this.getIdentifier(), t, identity, locking, mode);
            if (lockOnlyHandle.useContainer(true, waitForLock)) {
                return lockOnlyHandle;
            }
            return null;
        }
        FileContainer container = (FileContainer)this.containerCache.find(identity);
        if (container == null) {
            return null;
        }
        if (identity.getSegmentId() == -1L) {
            SanityManager.ASSERT((boolean)(container instanceof TempRAFContainer));
            mode = (mode & 0x800) == 2048 ? (mode |= 1) : (mode |= 0x101);
            locking = t.newLockingPolicy(0, 0, true);
        } else {
            if (this.inCreateNoLog) {
                mode |= 3;
            } else if (this.logFactory.logArchived() || this.logFactory.inReplicationMasterMode()) {
                mode &= 0xFFFFFFFC;
            } else if (!((mode & 1) != 1 && (mode & 2) != 2 || t.blockBackup(false))) {
                mode &= 0xFFFFFFFC;
            }
            if ((mode & 1) == 1 && (mode & 2) == 0) {
                mode |= 0x200;
            }
        }
        PageActions pageActions = null;
        AllocationActions allocActions = null;
        if ((mode & 4) == 4) {
            if ((mode & 1) == 0) {
                pageActions = this.getLoggablePageActions();
                allocActions = this.getLoggableAllocationActions();
            } else {
                pageActions = new DirectActions();
                allocActions = new DirectAllocActions();
            }
        }
        BaseContainerHandle c = new BaseContainerHandle(this.getIdentifier(), t, pageActions, allocActions, locking, container, mode);
        try {
            if (!c.useContainer(droppedOK, waitForLock)) {
                this.containerCache.release(container);
                return null;
            }
        }
        catch (StandardException se) {
            this.containerCache.release(container);
            throw se;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addContainer(RawTransaction t, long segmentId, long input_containerid, int mode, Properties tableProperties, int temporaryFlag) throws StandardException {
        if ((mode & 2) != 0) {
            SanityManager.ASSERT(((mode & 1) != 0 ? 1 : 0) != 0, (String)"cannot have CREATE_UNLOGGED set but UNLOGGED not set");
        }
        long containerId = input_containerid != 0L ? input_containerid : this.getNextId();
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        boolean tmpContainer = segmentId == -1L;
        ContainerHandle ch = null;
        LockingPolicy cl = null;
        if (!tmpContainer) {
            if (this.isReadOnly()) {
                throw StandardException.newException((String)"40XD1", (Object[])new Object[0]);
            }
            cl = t.newLockingPolicy(2, 5, true);
            SanityManager.ASSERT((cl != null ? 1 : 0) != 0);
            ch = t.openContainer(identity, cl, 68);
        }
        FileContainer container = (FileContainer)this.containerCache.create(identity, tableProperties);
        ContainerHandle containerHdl = null;
        Page firstPage = null;
        try {
            if (tmpContainer && (temporaryFlag & 2) == 2) {
                mode |= 0x800;
            }
            SanityManager.ASSERT(((containerHdl = t.openContainer(identity, null, 4 | mode)) != null ? 1 : 0) != 0);
            if (!tmpContainer) {
                RawContainerHandle rch = (RawContainerHandle)containerHdl;
                ContainerOperation lop = new ContainerOperation(rch, 1);
                rch.preDirty(true);
                try {
                    t.logAndDo(lop);
                    this.flush(t.getLastLogInstant());
                }
                finally {
                    rch.preDirty(false);
                }
            }
            firstPage = containerHdl.addPage();
        }
        finally {
            if (firstPage != null) {
                firstPage.unlatch();
                firstPage = null;
            }
            this.containerCache.release(container);
            if (containerHdl != null) {
                containerHdl.close();
                containerHdl = null;
            }
            if (!tmpContainer) {
                cl.unlockContainer(t, ch);
            }
        }
        return containerId;
    }

    @Override
    public long addAndLoadStreamContainer(RawTransaction t, long segmentId, Properties tableProperties, RowSource rowSource) throws StandardException {
        long containerId = this.getNextId();
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        StreamFileContainer sContainer = new StreamFileContainer(identity, this, tableProperties);
        sContainer.load(rowSource);
        return containerId;
    }

    @Override
    public StreamContainerHandle openStreamContainer(RawTransaction t, long segmentId, long containerId, boolean hold) throws StandardException {
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        StreamFileContainer container = new StreamFileContainer(identity, this);
        if ((container = container.open(false)) == null) {
            return null;
        }
        StreamFileContainerHandle c = new StreamFileContainerHandle(this.getIdentifier(), t, container, hold);
        if (c.useContainer()) {
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropStreamContainer(RawTransaction t, long segmentId, long containerId) throws StandardException {
        boolean tmpContainer = segmentId == -1L;
        try (StreamContainerHandle containerHdl = null;){
            ContainerKey ckey = new ContainerKey(segmentId, containerId);
            t.notifyObservers(ckey);
            containerHdl = t.openStreamContainer(segmentId, containerId, false);
            if (tmpContainer && containerHdl != null) {
                containerHdl.removeContainer();
                return;
            }
        }
    }

    @Override
    public void reCreateContainerForRedoRecovery(RawTransaction t, long segmentId, long containerId, ByteArray containerInfo) throws StandardException {
        SanityManager.ASSERT((segmentId != -1L ? 1 : 0) != 0, (String)"Cannot recreate temp container during load tran");
        ContainerKey identity = new ContainerKey(segmentId, containerId);
        FileContainer container = (FileContainer)this.containerCache.create(identity, containerInfo);
        this.containerCache.release(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropContainer(RawTransaction t, ContainerKey ckey) throws StandardException {
        block15: {
            boolean tmpContainer = ckey.getSegmentId() == -1L;
            LockingPolicy cl = null;
            if (!tmpContainer) {
                if (this.isReadOnly()) {
                    throw StandardException.newException((String)"40XD1", (Object[])new Object[0]);
                }
                cl = t.newLockingPolicy(2, 5, true);
                SanityManager.ASSERT((cl != null ? 1 : 0) != 0);
            }
            t.notifyObservers(ckey);
            try (RawContainerHandle containerHdl = (RawContainerHandle)t.openContainer(ckey, cl, 4);){
                if (containerHdl == null || containerHdl.getContainerStatus() != 1) {
                    if (tmpContainer) {
                        if (containerHdl != null) {
                            containerHdl.removeContainer(null);
                        }
                        return;
                    }
                    throw StandardException.newException((String)"40XD2", (Object[])new Object[]{ckey});
                }
                if (tmpContainer) {
                    containerHdl.dropContainer(null, true);
                    containerHdl.removeContainer(null);
                    break block15;
                }
                ContainerOperation lop = new ContainerOperation(containerHdl, 2);
                containerHdl.preDirty(true);
                try {
                    t.logAndDo(lop);
                }
                finally {
                    containerHdl.preDirty(false);
                }
                ReclaimSpace p = new ReclaimSpace(1, ckey, (DataFactory)this, true);
                if (SanityManager.DEBUG_ON((String)DaemonService.DaemonTrace)) {
                    SanityManager.DEBUG((String)DaemonService.DaemonTrace, (String)("Add post commit work " + p));
                }
                t.addPostCommitWork(p);
            }
        }
    }

    @Override
    public void checkpoint() throws StandardException {
        this.pageCache.cleanAll();
        this.containerCache.cleanAll();
    }

    @Override
    public void idle() throws StandardException {
        this.pageCache.ageOut();
        this.containerCache.ageOut();
    }

    @Override
    public void setRawStoreFactory(RawStoreFactory rsf, boolean create, Properties startParams) throws StandardException {
        this.rawStoreFactory = rsf;
        this.bootLogFactory(create, startParams);
    }

    @Override
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Override
    public int reclaimSpace(Serviceable work, ContextManager contextMgr) throws StandardException {
        if (work == null) {
            return 1;
        }
        Transaction tran = this.rawStoreFactory.findUserTransaction(contextMgr, "SystemTransaction");
        SanityManager.ASSERT((tran != null ? 1 : 0) != 0, (String)"null transaction");
        if (SanityManager.DEBUG_ON((String)DaemonService.DaemonTrace)) {
            SanityManager.DEBUG((String)DaemonService.DaemonTrace, (String)("Performing post commit work " + work));
        }
        return ReclaimSpaceHelper.reclaimSpace(this, (RawTransaction)tran, (ReclaimSpace)work);
    }

    @Override
    public StandardException markCorrupt(StandardException originalError) {
        boolean firsttime = !this.isCorrupt;
        this.isCorrupt = true;
        if (this.getLogFactory() != null) {
            this.getLogFactory().markCorrupt(originalError);
        }
        if (firsttime) {
            if (this.pageCache != null) {
                this.pageCache.discard(null);
            }
            if (this.containerCache != null) {
                this.containerCache.discard(null);
            }
            this.pageCache = null;
            this.containerCache = null;
            this.releaseJBMSLockOnDB();
        }
        return originalError;
    }

    @Override
    public FileResource getFileHandler() {
        return this.fileHandler;
    }

    @Override
    public void removeStubsOK() {
        this.removeStubsOK = true;
    }

    @Override
    public void setUndoInsertEventHandler(UndoHandler input_undo_handle) {
        this.undo_handler = input_undo_handle;
    }

    protected void insertUndoNotify(RawTransaction rxact, PageKey page_key) throws StandardException {
        if (this.undo_handler != null) {
            this.undo_handler.insertUndoNotify(rxact, page_key);
        }
    }

    public int getIntParameter(String parameterName, Properties properties, int defaultValue, int minimumValue, int maximumValue) {
        String parameter = null;
        if (properties != null) {
            parameter = properties.getProperty(parameterName);
        }
        if (parameter == null) {
            parameter = PropertyUtil.getSystemProperty(parameterName);
        }
        if (parameter != null) {
            try {
                int newValue = Integer.parseInt(parameter);
                if (newValue >= minimumValue && newValue <= maximumValue) {
                    return newValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    CacheManager getContainerCache() {
        return this.containerCache;
    }

    CacheManager getPageCache() {
        return this.pageCache;
    }

    void flush(LogInstant instant) throws StandardException {
        this.getLogFactory().flush(instant);
    }

    LogFactory getLogFactory() {
        return this.logFactory;
    }

    RawStoreFactory getRawStoreFactory() {
        return this.rawStoreFactory;
    }

    @Override
    public String getRootDirectory() {
        return this.dataDirectory;
    }

    Cacheable newContainerObject() {
        if (this.supportsRandomAccess) {
            return this.newRAFContainer(this);
        }
        return new InputStreamContainer(this);
    }

    protected Cacheable newRAFContainer(BaseDataFileFactory factory) {
        return new RAFContainer(factory);
    }

    private PageActions getLoggablePageActions() throws StandardException {
        if (this.loggablePageActions == null) {
            this.loggablePageActions = new LoggableActions();
        }
        return this.loggablePageActions;
    }

    private AllocationActions getLoggableAllocationActions() {
        if (this.loggableAllocActions == null) {
            this.loggableAllocActions = new LoggableAllocActions();
        }
        return this.loggableAllocActions;
    }

    private synchronized void removeTempDirectory() {
        if (this.storageFactory != null) {
            this.actionCode = 2;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    public StorageFile getContainerPath(ContainerKey containerId, boolean stub) {
        return this.getContainerPath(containerId, stub, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StorageFile getContainerPath(ContainerKey containerId, boolean stub, int code) {
        this.actionCode = code;
        try {
            this.containerId = containerId;
            this.stub = stub;
            try {
                StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
                return storageFile;
            }
            catch (PrivilegedActionException pae) {
                StorageFile storageFile = null;
                this.containerId = null;
                return storageFile;
            }
        }
        finally {
            this.containerId = null;
        }
    }

    public StorageFile getAlternateContainerPath(ContainerKey containerId, boolean stub) {
        return this.getContainerPath(containerId, stub, 4);
    }

    private synchronized void removeStubs() {
        if (this.storageFactory != null) {
            this.actionCode = 9;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
    }

    public void stubFileToRemoveAfterCheckPoint(StorageFile file, LogInstant logInstant, Object identity) {
        if (this.droppedTableStubInfo != null) {
            Object[] removeInfo = new Object[]{file, identity};
            this.droppedTableStubInfo.put(logInstant, removeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDroppedContainerFileStubs(LogInstant redoLWM) throws StandardException {
        if (this.droppedTableStubInfo != null) {
            Hashtable<LogInstant, Object[]> hashtable = this.droppedTableStubInfo;
            synchronized (hashtable) {
                Enumeration<LogInstant> e = this.droppedTableStubInfo.keys();
                while (e.hasMoreElements()) {
                    LogInstant logInstant = e.nextElement();
                    if (!logInstant.lessThan(redoLWM)) continue;
                    Object[] removeInfo = this.droppedTableStubInfo.get(logInstant);
                    Object identity = removeInfo[1];
                    Cacheable ccentry = this.containerCache.findCached(identity);
                    if (ccentry != null) {
                        this.containerCache.remove(ccentry);
                    }
                    BaseDataFileFactory baseDataFileFactory = this;
                    synchronized (baseDataFileFactory) {
                        this.actionFile = (StorageFile)removeInfo[0];
                        this.actionCode = 6;
                        try {
                            if (AccessController.doPrivileged(this) != null) {
                                this.droppedTableStubInfo.remove(logInstant);
                            }
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private synchronized long findMaxContainerId() {
        this.actionCode = 5;
        try {
            return (Long)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return 0L;
        }
    }

    private void bootLogFactory(boolean create, Properties startParams) throws StandardException {
        if (this.isReadOnly()) {
            startParams.put("derby.__rt.storage.log", "readonly");
        }
        this.logFactory = (LogFactory)BaseDataFileFactory.bootServiceModule(create, this, this.rawStoreFactory.getLogFactoryModule(), startParams);
    }

    private boolean handleServiceType(String type) {
        try {
            PersistentService ps = BaseDataFileFactory.getMonitor().getServiceProvider(type);
            return ps != null && ps.hasStorageFactory();
        }
        catch (StandardException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJBMSLockOnDB(UUID myUUID, UUIDFactory uuidFactory, String databaseDirectory) throws StandardException {
        if (this.fileLockOnDB != null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        if (myUUID == null) {
            SanityManager.THROWASSERT((String)"myUUID == null");
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 11;
            this.myUUID = myUUID;
            this.uuidFactory = uuidFactory;
            this.databaseDirectory = databaseDirectory;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
                throw (StandardException)((Object)pae.getException());
            }
            finally {
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privGetJBMSLockOnDB() throws StandardException {
        boolean fileLockExisted = false;
        String blownUUID = null;
        StorageFile fileLock = this.storageFactory.newStorageFile("db.lck");
        try {
            if (fileLock.exists()) {
                fileLockExisted = true;
                this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
                try {
                    blownUUID = this.fileLockOnDB.readUTF();
                }
                catch (IOException ioe) {
                    fileLockExisted = false;
                }
                this.fileLockOnDB.close();
                this.fileLockOnDB = null;
                if (!fileLock.delete()) {
                    throw StandardException.newException((String)"XSDB6.D", (Object[])new Object[]{this.databaseDirectory});
                }
            }
            this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
            fileLock.limitAccessToOwner();
            this.fileLockOnDB.writeUTF(this.myUUID.toString());
            this.fileLockOnDB.sync();
            this.fileLockOnDB.seek(0L);
            UUID checkUUID = this.uuidFactory.recreateUUID(this.fileLockOnDB.readUTF());
            if (!checkUUID.equals(this.myUUID)) {
                throw StandardException.newException((String)"XSDB6.D", (Object[])new Object[]{this.databaseDirectory});
            }
        }
        catch (IOException ioe) {
            this.readOnly = true;
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileLockOnDB = null;
            return;
        }
        if (fileLock.delete()) {
            Object[] args = new Object[]{this.myUUID, this.databaseDirectory, blownUUID};
            int exLockStatus = 0;
            if (!this.throwDBlckException) {
                this.exFileLock = this.storageFactory.newStorageFile("dbex.lck");
                exLockStatus = this.exFileLock.getExclusiveFileLock();
            }
            if (exLockStatus == 0 && fileLockExisted && !this.throwDBlckException) {
                String warningMsg = MessageService.getTextMessage((String)"XSDB7.D", (Object[])args);
                this.logMsg(warningMsg);
                System.err.println(warningMsg);
            }
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
                this.fileLockOnDB = fileLock.getRandomAccessFile("rw");
                fileLock.limitAccessToOwner();
                this.fileLockOnDB.writeUTF(this.myUUID.toString());
                this.fileLockOnDB.sync();
                this.fileLockOnDB.close();
            }
            catch (IOException ioe) {
                try {
                    this.fileLockOnDB.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.fileLockOnDB = null;
            }
            if (fileLockExisted && this.throwDBlckException) {
                throw StandardException.newException((String)"XSDB8.D", (Object[])args);
            }
            if (exLockStatus == 2) {
                throw StandardException.newException((String)"XSDB6.D", (Object[])new Object[]{this.databaseDirectory});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJBMSLockOnDB() {
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 12;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            finally {
                this.fileLockOnDB = null;
            }
        }
    }

    private void privReleaseJBMSLockOnDB() throws IOException {
        if (this.fileLockOnDB != null) {
            this.fileLockOnDB.close();
        }
        if (this.storageFactory != null) {
            StorageFile fileLock = this.storageFactory.newStorageFile("db.lck");
            fileLock.delete();
        }
        if (this.exFileLock != null) {
            this.exFileLock.releaseExclusiveFileLock();
        }
    }

    private void logMsg(String msg) {
        if (this.istream == null) {
            this.istream = Monitor.getStream();
        }
        this.istream.println(msg);
    }

    @Override
    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    @Override
    public void setDatabaseEncrypted(boolean isEncrypted) {
        this.databaseEncrypted = isEncrypted;
    }

    @Override
    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset, boolean newEngine) throws StandardException {
        return this.rawStoreFactory.encrypt(cleartext, offset, length, ciphertext, outputOffset, newEngine);
    }

    @Override
    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        return this.rawStoreFactory.decrypt(ciphertext, offset, length, cleartext, outputOffset);
    }

    @Override
    public void decryptAllContainers(RawTransaction t) throws StandardException {
        EncryptOrDecryptData containerDecrypter = new EncryptOrDecryptData(this);
        containerDecrypter.decryptAllContainers(t);
    }

    @Override
    public void encryptAllContainers(RawTransaction t) throws StandardException {
        EncryptOrDecryptData containerEncrypter = new EncryptOrDecryptData(this);
        containerEncrypter.encryptAllContainers(t);
    }

    @Override
    public void removeOldVersionOfContainers() throws StandardException {
        EncryptOrDecryptData containerCryptoOp = new EncryptOrDecryptData(this);
        containerCryptoOp.removeOldVersionOfContainers();
    }

    private static String jarClassPath(final Class cls) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                CodeSource cs = null;
                try {
                    cs = cls.getProtectionDomain().getCodeSource();
                }
                catch (SecurityException se) {
                    return se.getMessage();
                }
                if (cs == null || cs.getLocation() == null) {
                    return null;
                }
                URL result = cs.getLocation();
                return result.toString();
            }
        });
    }

    private static String buildOSinfo() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                Object osInfo = "";
                try {
                    String currentProp = PropertyUtil.getSystemProperty("os.name");
                    if (currentProp != null) {
                        osInfo = "os.name=" + currentProp + "\n";
                    }
                    if ((currentProp = PropertyUtil.getSystemProperty("os.arch")) != null) {
                        osInfo = (String)osInfo + "os.arch=" + currentProp + "\n";
                    }
                    if ((currentProp = PropertyUtil.getSystemProperty("os.version")) != null) {
                        osInfo = (String)osInfo + "os.version=" + currentProp;
                    }
                }
                catch (SecurityException se) {
                    return se.getMessage();
                }
                return osInfo;
            }
        });
    }

    private static String buildJvmVersion() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                Object jvmversion = "";
                try {
                    String currentProp = PropertyUtil.getSystemProperty("java.vendor");
                    if (currentProp != null) {
                        jvmversion = "java.vendor=" + currentProp;
                    }
                    if ((currentProp = PropertyUtil.getSystemProperty("java.runtime.version")) != null) {
                        jvmversion = (String)jvmversion + "\njava.runtime.version=" + currentProp;
                    }
                    if ((currentProp = PropertyUtil.getSystemProperty("java.fullversion")) != null) {
                        jvmversion = (String)jvmversion + "\njava.fullversion=" + currentProp;
                    }
                    if ((currentProp = PropertyUtil.getSystemProperty("user.dir")) != null) {
                        jvmversion = (String)jvmversion + "\nuser.dir=" + currentProp;
                    }
                }
                catch (SecurityException se) {
                    return se.getMessage();
                }
                return jvmversion;
            }
        });
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public String getVersionedName(String name, long generationId) {
        return name.concat(".G".concat(Long.toString(generationId)));
    }

    @Override
    public long getMaxContainerId() throws StandardException {
        return this.findMaxContainerId();
    }

    synchronized long getNextId() {
        return this.nextContainerId++;
    }

    int random() {
        return this.databaseEncrypted ? this.rawStoreFactory.random() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileToRemove(StorageFile file, boolean remove) {
        if (this.postRecoveryRemovedFiles == null) {
            this.postRecoveryRemovedFiles = new Hashtable();
        }
        String path = null;
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 7;
            this.actionFile = file;
            try {
                path = (String)AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            finally {
                this.actionFile = null;
            }
        }
        if (remove) {
            this.postRecoveryRemovedFiles.put(path, file);
        } else {
            this.postRecoveryRemovedFiles.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRecovery() throws StandardException {
        DaemonService daemon = this.rawStoreFactory.getDaemon();
        if (daemon == null) {
            return;
        }
        if (this.postRecoveryRemovedFiles != null) {
            BaseDataFileFactory baseDataFileFactory = this;
            synchronized (baseDataFileFactory) {
                this.actionCode = 8;
                try {
                    AccessController.doPrivileged(this);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    // empty catch block
                }
            }
            this.postRecoveryRemovedFiles = null;
        }
    }

    @Override
    public void setupCacheCleaner(DaemonService daemon) {
        this.containerCache.useDaemonService(daemon);
        this.pageCache.useDaemonService(daemon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezePersistentStore() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            if (this.isFrozen) {
                throw StandardException.newException((String)"XSRS0.S", (Object[])new Object[0]);
            }
            this.isFrozen = true;
            try {
                while (this.writersInProgress > 0) {
                    try {
                        this.freezeSemaphore.wait();
                    }
                    catch (InterruptedException ie) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
            catch (RuntimeException rte) {
                this.isFrozen = false;
                this.freezeSemaphore.notifyAll();
                throw rte;
            }
            SanityManager.ASSERT((this.writersInProgress == 0 && this.isFrozen ? 1 : 0) != 0, (String)"data store is not properly frozen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreezePersistentStore() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            this.isFrozen = false;
            this.freezeSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInProgress() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            while (this.isFrozen) {
                try {
                    this.freezeSemaphore.wait();
                }
                catch (InterruptedException ie) {
                    InterruptStatus.setInterrupted();
                }
            }
            ++this.writersInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFinished() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            SanityManager.ASSERT((this.writersInProgress > 0 ? 1 : 0) != 0, (String)"no writers in progress");
            --this.writersInProgress;
            this.freezeSemaphore.notifyAll();
        }
    }

    @Override
    public void backupDataFiles(Transaction rt, File backupDir) throws StandardException {
        String[] files = this.getContainerNames();
        if (files != null) {
            LockingPolicy lockPolicy = rt.newLockingPolicy(0, 0, false);
            long segmentId = 0L;
            for (int f = files.length - 1; f >= 0; --f) {
                long containerId;
                try {
                    containerId = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                }
                catch (Throwable t) {
                    continue;
                }
                ContainerKey identity = new ContainerKey(segmentId, containerId);
                RawContainerHandle containerHdl = this.openDroppedContainer((RawTransaction)rt, identity, lockPolicy, 8);
                if (containerHdl == null) continue;
                containerHdl.backupContainer(backupDir.getPath());
                containerHdl.close();
            }
        } else {
            SanityManager.THROWASSERT((String)"backup process is unable to read container names in seg0");
        }
    }

    synchronized String[] getContainerNames() {
        this.actionCode = 14;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDataDirectory(String backupPath) throws StandardException {
        final File backupRoot = new File(backupPath);
        String[] bfilelist = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return backupRoot.list();
            }
        });
        if (bfilelist != null) {
            boolean segmentexist = false;
            for (int i = 0; i < bfilelist.length; ++i) {
                boolean isDirectory;
                File bsegdir;
                boolean bsegdirExists;
                if (!bfilelist[i].startsWith("seg") || !(bsegdirExists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                    final /* synthetic */ File val$bsegdir;
                    {
                        this.val$bsegdir = file;
                    }

                    @Override
                    public Boolean run() {
                        return this.val$bsegdir.exists();
                    }
                }).booleanValue()) || !(isDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return bsegdir.isDirectory();
                    }
                }).booleanValue())) continue;
                segmentexist = true;
                break;
            }
            if (!segmentexist) {
                throw StandardException.newException((String)"XSDG6.D", (Object[])new Object[]{backupRoot});
            }
        } else {
            throw StandardException.newException((String)"XSDG6.D", (Object[])new Object[]{backupRoot});
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 13;
            this.backupRoot = backupRoot;
            this.bfilelist = bfilelist;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
                throw (StandardException)((Object)pae.getException());
            }
            finally {
                this.backupRoot = null;
                this.bfilelist = null;
            }
        }
    }

    private void privRestoreDataDirectory() throws StandardException {
        StorageFile csegdir;
        int i;
        StorageFile dataRoot = this.storageFactory.newStorageFile(null);
        String[] cfilelist = dataRoot.list();
        if (cfilelist != null) {
            for (i = 0; i < cfilelist.length; ++i) {
                if (!cfilelist[i].startsWith("seg") && !"LUCENE".equals(cfilelist[i]) || (csegdir = this.storageFactory.newStorageFile(cfilelist[i])).deleteAll()) continue;
                throw StandardException.newException((String)"XSDG7.D", (Object[])new Object[]{csegdir});
            }
        }
        for (i = 0; i < this.bfilelist.length; ++i) {
            StorageFile toFile;
            File fromFile;
            if (this.bfilelist[i].startsWith("seg") || "LUCENE".equals(this.bfilelist[i])) {
                File bsegdir1 = new File(this.backupRoot, this.bfilelist[i]);
                csegdir = this.storageFactory.newStorageFile(this.bfilelist[i]);
                if (FileUtil.copyDirectory(this.writableStorageFactory, bsegdir1, csegdir)) continue;
                throw StandardException.newException((String)"XSDG8.D", (Object[])new Object[]{bsegdir1, csegdir});
            }
            if (!this.databaseEncrypted || !this.bfilelist[i].startsWith("verifyKey.dat") || FileUtil.copyFile(this.writableStorageFactory, fromFile = new File(this.backupRoot, this.bfilelist[i]), toFile = this.storageFactory.newStorageFile(this.bfilelist[i]))) continue;
            throw StandardException.newException((String)"XSDG8.D", (Object[])new Object[]{this.bfilelist[i], toFile});
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean luceneLoaded() throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    StorageFactory storageFactory = BaseDataFileFactory.this.getStorageFactory();
                    StorageFile luceneDir = storageFactory.newStorageFile("LUCENE");
                    return luceneDir.exists();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }

    @Override
    public StorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    @Override
    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 10: {
                this.readOnly = this.storageFactory.isReadOnlyDatabase();
                this.supportsRandomAccess = this.storageFactory.supportsRandomAccess();
                return null;
            }
            case 2: {
                StorageFile tempDir = this.storageFactory.getTempDir();
                if (tempDir != null) {
                    tempDir.deleteAll();
                }
                return null;
            }
            case 3: 
            case 4: {
                StringBuffer sb = new StringBuffer("seg");
                sb.append(this.containerId.getSegmentId());
                sb.append(this.storageFactory.getSeparator());
                if (this.actionCode == 3) {
                    sb.append(this.stub ? (char)'d' : 'c');
                    sb.append(Long.toHexString(this.containerId.getContainerId()));
                    sb.append(".dat");
                } else {
                    sb.append(this.stub ? (char)'D' : 'C');
                    sb.append(Long.toHexString(this.containerId.getContainerId()));
                    sb.append(".DAT");
                }
                return this.storageFactory.newStorageFile(sb.toString());
            }
            case 9: {
                char separator = this.storageFactory.getSeparator();
                StorageFile root = this.storageFactory.newStorageFile(null);
                String[] segs = root.list();
                for (int s = segs.length - 1; s >= 0; --s) {
                    StorageFile seg;
                    if (!segs[s].startsWith("seg") || !(seg = this.storageFactory.newStorageFile(root, segs[s])).exists() || !seg.isDirectory()) continue;
                    String[] files = seg.list();
                    for (int f = files.length - 1; f >= 0; --f) {
                        StorageFile stub;
                        boolean delete_status;
                        if (!files[f].startsWith("D") && !files[f].startsWith("d") || (delete_status = (stub = this.storageFactory.newStorageFile(root, segs[s] + separator + files[f])).delete())) continue;
                        SanityManager.THROWASSERT((String)("delete of stub (" + stub + ") failed."));
                    }
                }
                break;
            }
            case 5: {
                long maxnum = 1L;
                StorageFile seg = this.storageFactory.newStorageFile("seg0");
                if (seg.exists() && seg.isDirectory()) {
                    String[] files = seg.list();
                    for (int f = files.length - 1; f >= 0; --f) {
                        try {
                            long fileNumber = Long.parseLong(files[f].substring(1, files[f].length() - 4), 16);
                            if (fileNumber <= maxnum) continue;
                            maxnum = fileNumber;
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return maxnum;
            }
            case 6: {
                boolean ret = this.actionFile.exists() && this.actionFile.delete();
                this.actionFile = null;
                return ret ? this : null;
            }
            case 7: {
                String path = this.actionFile.getPath();
                this.actionFile = null;
                return path;
            }
            case 8: {
                Enumeration<StorageFile> e = this.postRecoveryRemovedFiles.elements();
                while (e.hasMoreElements()) {
                    boolean delete_status;
                    StorageFile f = e.nextElement();
                    if (!f.exists() || (delete_status = f.delete())) continue;
                    SanityManager.THROWASSERT((String)("delete of stub (" + this.stub + ") failed."));
                }
                return null;
            }
            case 11: {
                this.privGetJBMSLockOnDB();
                return null;
            }
            case 12: {
                this.privReleaseJBMSLockOnDB();
                return null;
            }
            case 13: {
                this.privRestoreDataDirectory();
                return null;
            }
            case 14: {
                StorageFile seg = this.storageFactory.newStorageFile("seg0");
                if (seg.exists() && seg.isDirectory()) {
                    return seg.list();
                }
                return null;
            }
        }
        return null;
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object startSystemModule(final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule(factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }

    private static Object bootServiceModule(final boolean create, final Object serviceModule, final String factoryInterface, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(create, serviceModule, factoryInterface, properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException((Throwable)pae);
        }
    }
}

