/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.AllocationCache;
import org.apache.derby.impl.store.raw.data.BaseContainer;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.SpaceInformation;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class FileContainer
extends BaseContainer
implements Cacheable,
TypedFormat {
    protected static final int formatIdInteger = 116;
    protected final CacheManager pageCache;
    protected final CacheManager containerCache;
    protected final BaseDataFileFactory dataFactory;
    protected int pageSize;
    protected int spareSpace;
    protected int minimumRecordSize;
    protected short initialPages;
    protected boolean canUpdate;
    private int PreAllocThreshold;
    private int PreAllocSize;
    private boolean bulkIncreaseContainerSize;
    private static final int PRE_ALLOC_THRESHOLD = 8;
    private static final int MIN_PRE_ALLOC_SIZE = 1;
    private static final int DEFAULT_PRE_ALLOC_SIZE = 8;
    private static final int MAX_PRE_ALLOC_SIZE = 1000;
    protected long firstAllocPageNumber;
    protected long firstAllocPageOffset;
    protected long containerVersion;
    protected long estimatedRowCount;
    protected LogInstant lastLogInstant;
    private long reusableRecordIdSequenceNumber;
    private long[] lastInsertedPage;
    private int lastInsertedPage_index;
    private long lastUnfilledPage;
    private long lastAllocatedPage;
    private long estimatedPageCount;
    protected boolean preDirty;
    protected boolean isDirty;
    protected AllocationCache allocCache;
    byte[] containerInfo;
    private CRC32 checksum;
    private byte[] encryptionBuffer;
    private static final int CONTAINER_FORMAT_ID_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int CONTAINER_INFO_SIZE = 80;
    public static final long FIRST_ALLOC_PAGE_NUMBER = 0L;
    public static final long FIRST_ALLOC_PAGE_OFFSET = 0L;
    private static final int FILE_DROPPED = 1;
    private static final int FILE_COMMITTED_DROP = 2;
    private static final int FILE_REUSABLE_RECORDID = 8;
    protected static final String SPACE_TRACE = "SpaceTrace";

    @Override
    public int getTypeFormatId() {
        return 116;
    }

    FileContainer(BaseDataFileFactory factory) {
        this.dataFactory = factory;
        this.pageCache = factory.getPageCache();
        this.containerCache = factory.getContainerCache();
        this.initContainerHeader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceInfo getSpaceInfo(BaseContainerHandle handle) throws StandardException {
        SpaceInformation spaceInfo;
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            spaceInfo = this.allocCache.getAllPageCounts(handle, this.firstAllocPageNumber);
        }
        spaceInfo.setPageSize(this.pageSize);
        return spaceInfo;
    }

    @Override
    public Cacheable setIdentity(Object key) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() == -1L) {
            return new TempRAFContainer(this.dataFactory).setIdent(newIdentity);
        }
        return this.setIdent(newIdentity);
    }

    protected Cacheable setIdent(ContainerKey newIdentity) throws StandardException {
        boolean ok = this.openContainer(newIdentity);
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.estimatedPageCount = -1L;
        if (ok) {
            this.fillInIdentity(newIdentity);
            return this;
        }
        return null;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        ContainerKey newIdentity = (ContainerKey)key;
        if (newIdentity.getSegmentId() == -1L) {
            TempRAFContainer tmpContainer = new TempRAFContainer(this.dataFactory);
            return tmpContainer.createIdent(newIdentity, createParameter);
        }
        return this.createIdent(newIdentity, createParameter);
    }

    protected Cacheable createIdent(ContainerKey newIdentity, Object createParameter) throws StandardException {
        if (createParameter != this) {
            this.initContainerHeader(true);
            if (createParameter != null && createParameter instanceof ByteArray) {
                this.createInfoFromLog((ByteArray)createParameter);
            } else {
                if (createParameter != null && !(createParameter instanceof Properties)) {
                    SanityManager.THROWASSERT((String)("Expecting a  non-null createParameter to a Properties instead of " + createParameter.getClass().getName()));
                }
                this.createInfoFromProp((Properties)createParameter);
            }
        } else {
            this.initContainerHeader(false);
        }
        if (this.initialPages > 1) {
            this.PreAllocThreshold = 0;
            this.PreAllocSize = this.initialPages;
            this.bulkIncreaseContainerSize = true;
        } else {
            this.PreAllocThreshold = 8;
        }
        this.createContainer(newIdentity);
        this.setDirty(true);
        this.fillInIdentity(newIdentity);
        return this;
    }

    @Override
    public void clearIdentity() {
        this.closeContainer();
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.canUpdate = false;
        super.clearIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.isDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDirty(boolean preDirtyOn) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            if (preDirtyOn) {
                this.preDirty = true;
            } else {
                this.preDirty = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty(boolean dirty) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.preDirty = false;
            this.isDirty = dirty;
            this.notifyAll();
        }
    }

    abstract void createContainer(ContainerKey var1) throws StandardException;

    abstract boolean openContainer(ContainerKey var1) throws StandardException;

    abstract void closeContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropContainer(LogInstant instant, boolean isDropped) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.setDroppedState(isDropped);
            this.setDirty(true);
            this.bumpContainerVersion(instant);
        }
    }

    protected final void bumpContainerVersion(LogInstant instant) {
        this.lastLogInstant = instant;
        ++this.containerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getContainerVersion() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.containerVersion;
        }
    }

    @Override
    public void getContainerProperties(Properties prop) throws StandardException {
        if (prop.getProperty("derby.storage.pageSize") != null) {
            prop.put("derby.storage.pageSize", Integer.toString(this.pageSize));
        }
        if (prop.getProperty("derby.storage.minimumRecordSize") != null) {
            prop.put("derby.storage.minimumRecordSize", Integer.toString(this.minimumRecordSize));
        }
        if (prop.getProperty("derby.storage.pageReservedSpace") != null) {
            prop.put("derby.storage.pageReservedSpace", Integer.toString(this.spareSpace));
        }
        if (prop.getProperty("derby.storage.reusableRecordId") != null) {
            Boolean bool = this.isReusableRecordId();
            prop.put("derby.storage.reusableRecordId", bool.toString());
        }
        if (prop.getProperty("derby.storage.initialPages") != null) {
            prop.put("derby.storage.initialPages", Integer.toString(this.initialPages));
        }
    }

    protected void readHeader(byte[] epage) throws IOException, StandardException {
        AllocPage.ReadContainerInfo(this.containerInfo, epage);
        this.readHeaderFromArray(this.containerInfo);
    }

    private void initContainerHeader(boolean changeContainer) {
        if (this.containerInfo == null) {
            this.containerInfo = new byte[80];
        }
        if (this.checksum == null) {
            this.checksum = new CRC32();
        } else {
            this.checksum.reset();
        }
        if (this.allocCache == null) {
            this.allocCache = new AllocationCache();
        } else {
            this.allocCache.reset();
        }
        if (changeContainer) {
            this.pageSize = 0;
            this.spareSpace = 0;
            this.minimumRecordSize = 0;
        }
        this.initialPages = 1;
        this.firstAllocPageNumber = -1L;
        this.firstAllocPageOffset = -1L;
        this.containerVersion = 0L;
        this.estimatedRowCount = 0L;
        this.reusableRecordIdSequenceNumber = 0L;
        this.setDroppedState(false);
        this.setCommittedDropState(false);
        this.setReusableRecordIdState(false);
        this.lastLogInstant = null;
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.estimatedPageCount = -1L;
        this.PreAllocThreshold = 8;
        this.PreAllocSize = 8;
        this.bulkIncreaseContainerSize = false;
    }

    private void readHeaderFromArray(byte[] a) throws StandardException, IOException {
        ArrayInputStream inStream = new ArrayInputStream(a);
        inStream.setLimit(80);
        int fid = inStream.readInt();
        if (fid != 116) {
            throw StandardException.newException((String)"XSDB2.D", (Object[])new Object[]{this.getIdentity(), fid});
        }
        int status = inStream.readInt();
        this.pageSize = inStream.readInt();
        this.spareSpace = inStream.readInt();
        this.minimumRecordSize = inStream.readInt();
        this.initialPages = inStream.readShort();
        this.PreAllocSize = inStream.readShort();
        this.firstAllocPageNumber = inStream.readLong();
        this.firstAllocPageOffset = inStream.readLong();
        this.containerVersion = inStream.readLong();
        this.estimatedRowCount = inStream.readLong();
        this.reusableRecordIdSequenceNumber = inStream.readLong();
        this.lastLogInstant = null;
        if (this.PreAllocSize == 0) {
            this.PreAllocSize = 8;
        }
        long spare3 = inStream.readLong();
        if (this.initialPages == 0) {
            this.initialPages = 1;
        }
        this.PreAllocThreshold = 8;
        long onDiskChecksum = inStream.readLong();
        this.checksum.reset();
        this.checksum.update(a, 0, 72);
        if (onDiskChecksum != this.checksum.getValue()) {
            PageKey pk = new PageKey(this.identity, 0L);
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG2.D", (Object[])new Object[]{pk, this.checksum.getValue(), onDiskChecksum, StringUtil.hexDump(a)}));
        }
        this.allocCache.reset();
        this.setDroppedState((status & 1) != 0);
        this.setCommittedDropState((status & 2) != 0);
        this.setReusableRecordIdState((status & 8) != 0);
    }

    protected void writeHeader(Object identity, byte[] pageData) throws StandardException, IOException {
        this.writeHeaderToArray(this.containerInfo);
        try {
            AllocPage.WriteContainerInfo(this.containerInfo, pageData, false);
        }
        catch (StandardException se) {
            throw StandardException.newException((String)"XSDBC.D", (Throwable)se, (Object[])new Object[]{identity});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader(Object identity, StorageRandomAccessFile file, boolean create, byte[] epage) throws IOException, StandardException {
        this.writeHeaderToArray(this.containerInfo);
        try {
            AllocPage.WriteContainerInfo(this.containerInfo, epage, create);
        }
        catch (StandardException se) {
            throw StandardException.newException((String)"XSDBC.D", (Throwable)se, (Object[])new Object[]{identity});
        }
        this.dataFactory.flush(this.lastLogInstant);
        if (this.lastLogInstant != null) {
            this.lastLogInstant = null;
        }
        this.dataFactory.writeInProgress();
        try {
            this.writeAtOffset(file, epage, 0L);
        }
        finally {
            this.dataFactory.writeFinished();
        }
    }

    void writeAtOffset(StorageRandomAccessFile file, byte[] bytes, long offset) throws IOException, StandardException {
        file.seek(offset);
        file.write(bytes);
    }

    protected byte[] getEmbryonicPage(DataInput fileData) throws IOException, StandardException {
        byte[] epage = new byte[204];
        fileData.readFully(epage);
        return epage;
    }

    byte[] getEmbryonicPage(StorageRandomAccessFile file, long offset) throws IOException, StandardException {
        file.seek(offset);
        return this.getEmbryonicPage(file);
    }

    private void writeHeaderToArray(byte[] a) throws IOException {
        SanityManager.ASSERT((a.length >= 80 ? 1 : 0) != 0, (String)"header won't fit in array");
        ArrayOutputStream a_out = new ArrayOutputStream(a);
        FormatIdOutputStream outStream = new FormatIdOutputStream(a_out);
        int status = 0;
        if (this.getDroppedState()) {
            status |= 1;
        }
        if (this.getCommittedDropState()) {
            status |= 2;
        }
        if (this.isReusableRecordId()) {
            status |= 8;
        }
        a_out.setPosition(0);
        a_out.setLimit(80);
        outStream.writeInt(116);
        outStream.writeInt(status);
        outStream.writeInt(this.pageSize);
        outStream.writeInt(this.spareSpace);
        outStream.writeInt(this.minimumRecordSize);
        outStream.writeShort(this.initialPages);
        outStream.writeShort(this.PreAllocSize);
        outStream.writeLong(this.firstAllocPageNumber);
        outStream.writeLong(this.firstAllocPageOffset);
        outStream.writeLong(this.containerVersion);
        outStream.writeLong(this.estimatedRowCount);
        outStream.writeLong(this.reusableRecordIdSequenceNumber);
        outStream.writeLong(0L);
        this.checksum.reset();
        this.checksum.update(a, 0, 72);
        outStream.writeLong(this.checksum.getValue());
        a_out.clearLimit();
    }

    @Override
    protected ByteArray logCreateContainerInfo() throws StandardException {
        byte[] array = new byte[80];
        try {
            this.writeHeaderToArray(array);
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
        return new ByteArray(array);
    }

    private void createInfoFromLog(ByteArray byteArray) throws StandardException {
        SanityManager.ASSERT((byteArray != null ? 1 : 0) != 0, (String)"setCreateContainerInfoFromLog: ByteArray is null");
        SanityManager.ASSERT((byteArray.getLength() == 80 ? 1 : 0) != 0, (String)"setCreateContainerInfoFromLog: ByteArrays.length() != CONTAINER_INFO_SIZE");
        byte[] array = byteArray.getArray();
        ArrayInputStream inStream = new ArrayInputStream(array);
        int status = 0;
        try {
            inStream.setLimit(80);
            int fid = inStream.readInt();
            if (fid != 116) {
                throw StandardException.newException((String)"XSDB2.D", (Object[])new Object[]{this.getIdentity(), fid});
            }
            status = inStream.readInt();
            this.pageSize = inStream.readInt();
            this.spareSpace = inStream.readInt();
            this.minimumRecordSize = inStream.readInt();
            this.initialPages = inStream.readShort();
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
        this.setReusableRecordIdState((status & 8) != 0);
        SanityManager.ASSERT(((status & 1) == 0 && (status & 2) == 0 ? 1 : 0) != 0, (String)"cannot load a dropped container");
    }

    private void createInfoFromProp(Properties createArgs) throws StandardException {
        AccessFactory af = (AccessFactory)FileContainer.getServiceModule(this.dataFactory, "org.apache.derby.iapi.store.access.AccessFactory");
        TransactionController tc = af == null ? null : af.getTransaction(FileContainer.getContextService().getCurrentContextManager());
        this.pageSize = PropertyUtil.getServiceInt(tc, createArgs, "derby.storage.pageSize", 4096, 32768, 4096);
        if (this.pageSize != 4096 && this.pageSize != 8192 && this.pageSize != 16384 && this.pageSize != 32768) {
            this.pageSize = 4096;
        }
        this.spareSpace = PropertyUtil.getServiceInt(tc, createArgs, "derby.storage.pageReservedSpace", 0, 100, 20);
        this.PreAllocSize = PropertyUtil.getServiceInt(tc, createArgs, "derby.storage.pagePerAllocate", 1, 1000, 8);
        this.minimumRecordSize = createArgs == null ? PropertyUtil.getServiceInt(tc, "derby.storage.minimumRecordSize", 12, this.pageSize * (1 - this.spareSpace / 100) - 100, 12) : PropertyUtil.getServiceInt(tc, createArgs, "derby.storage.minimumRecordSize", 1, this.pageSize * (1 - this.spareSpace / 100) - 100, 12);
        if (createArgs != null) {
            String containerInitialPageParameter;
            String reusableRecordIdParameter = createArgs.getProperty("derby.storage.reusableRecordId");
            if (reusableRecordIdParameter != null) {
                Boolean reusableRecordId = Boolean.parseBoolean(reusableRecordIdParameter);
                this.setReusableRecordIdState(reusableRecordId);
            }
            if ((containerInitialPageParameter = createArgs.getProperty("derby.storage.initialPages")) != null) {
                this.initialPages = Short.parseShort(containerInitialPageParameter);
                if (this.initialPages > 1 && this.initialPages > 1000) {
                    this.initialPages = (short)1000;
                }
            }
        }
    }

    @Override
    protected boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    protected void deallocatePage(BaseContainerHandle handle, BasePage page) throws StandardException {
        SanityManager.ASSERT((boolean)page.isLatched(), (String)"page is not latched");
        SanityManager.ASSERT((page.getPageNumber() != 0L ? 1 : 0) != 0, (String)"cannot deallocate an alloc page");
        long pnum = page.getPageNumber();
        this.deallocatePagenum(handle, pnum);
        page.deallocatePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocatePagenum(BaseContainerHandle handle, long pnum) throws StandardException {
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            AllocPage allocPage;
            long allocPageNum = this.allocCache.getAllocPageNumber(handle, pnum, this.firstAllocPageNumber);
            if (allocPageNum == -1L) {
                this.allocCache.dumpAllocationCache();
            }
            if (allocPageNum == -1L) {
                SanityManager.THROWASSERT((String)("can't find alloc page for page number " + pnum));
            }
            if ((allocPage = (AllocPage)handle.getAllocPage(allocPageNum)) == null) {
                PageKey pkey = new PageKey(this.identity, allocPageNum);
                throw StandardException.newException((String)"XSDF6.S", (Object[])new Object[]{pkey});
            }
            try {
                this.allocCache.invalidate(allocPage, allocPageNum);
                allocPage.deallocatePage(handle, pnum);
            }
            finally {
                allocPage.unlatch();
            }
        }
        if (pnum <= this.lastAllocatedPage) {
            this.lastAllocatedPage = pnum - 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compressContainer(RawTransaction ntt, BaseContainerHandle allocHandle) throws StandardException {
        CachedPage alloc_page = null;
        CachedPage prev_alloc_page = null;
        if (this.firstAllocPageNumber == -1L) {
            return;
        }
        this.dataFactory.getRawStoreFactory().checkpoint();
        ntt.blockBackup(true);
        try {
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                alloc_page = (AllocPage)allocHandle.getAllocPage(this.firstAllocPageNumber);
                while (!((AllocPage)alloc_page).isLast()) {
                    if (prev_alloc_page != null) {
                        prev_alloc_page.unlatch();
                    }
                    prev_alloc_page = alloc_page;
                    alloc_page = null;
                    long nextAllocPageNumber = ((AllocPage)prev_alloc_page).getNextAllocPageNumber();
                    long nextAllocPageOffset = ((AllocPage)prev_alloc_page).getNextAllocPageOffset();
                    alloc_page = (AllocPage)allocHandle.getAllocPage(nextAllocPageNumber);
                }
                this.allocCache.invalidate();
                this.lastUnfilledPage = -1L;
                this.lastAllocatedPage = -1L;
                ((AllocPage)alloc_page).compress(ntt, this);
            }
        }
        finally {
            if (alloc_page != null) {
                alloc_page.unlatch();
                alloc_page = null;
            }
            if (prev_alloc_page != null) {
                prev_alloc_page.unlatch();
                prev_alloc_page = null;
            }
            this.flushAll();
            this.pageCache.discard(this.identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getReusableRecordIdSequenceNumber() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.reusableRecordIdSequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void incrementReusableRecordIdSequenceNumber() {
        boolean readOnly = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            ++this.reusableRecordIdSequenceNumber;
            if (!readOnly) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage newPage(BaseContainerHandle userHandle, RawTransaction ntt, BaseContainerHandle allocHandle, boolean isOverflow) throws StandardException {
        boolean useNTT;
        boolean bl = useNTT = ntt != null;
        if (!useNTT) {
            ntt = userHandle.getTransaction();
        }
        long pageNumber = -1L;
        int numtries = 0;
        int maxTries = 120;
        long startSearch = this.lastAllocatedPage;
        CachedPage allocPage = null;
        BasePage page = null;
        try {
            boolean retry;
            do {
                boolean prealloced;
                boolean noIO;
                retry = false;
                AllocationCache allocationCache = this.allocCache;
                synchronized (allocationCache) {
                    SanityManager.ASSERT((boolean)ntt.getId().equals(allocHandle.getTransaction().getId()));
                    if (useNTT) {
                        SanityManager.ASSERT((!ntt.getId().equals(userHandle.getTransaction().getId()) ? 1 : 0) != 0);
                    }
                    try {
                        allocPage = this.findAllocPageForAdd(allocHandle, ntt, startSearch);
                    }
                    catch (InterruptDetectedException e) {
                        if (--maxTries > 0) {
                            this.firstAllocPageNumber = -1L;
                            retry = true;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ee) {
                                InterruptStatus.setInterrupted();
                            }
                            continue;
                        }
                        throw StandardException.newException((String)"XSDG9.D", (Throwable)((Object)e), (Object[])new Object[0]);
                    }
                    this.allocCache.invalidate((AllocPage)allocPage, allocPage.getPageNumber());
                }
                if (allocPage == null) {
                    this.allocCache.dumpAllocationCache();
                }
                SanityManager.ASSERT((allocPage != null ? 1 : 0) != 0, (String)"findAllocPageForAdd returned a null alloc page");
                pageNumber = ((AllocPage)allocPage).nextFreePageNumber(startSearch);
                long lastPage = ((AllocPage)allocPage).getLastPagenum();
                long lastPreallocPage = ((AllocPage)allocPage).getLastPreallocPagenum();
                boolean reuse = pageNumber <= lastPage;
                PageKey pkey = new PageKey(this.identity, pageNumber);
                if (reuse) {
                    RecordHandle deallocLock = BasePage.MakeRecordHandle(pkey, 2);
                    if (!this.getDeallocLock(allocHandle, deallocLock, false, true)) {
                        if (numtries == 0) {
                            startSearch = -1L;
                            this.lastAllocatedPage = pageNumber;
                        } else {
                            startSearch = pageNumber;
                        }
                        ++numtries;
                        allocPage.unlatch();
                        allocPage = null;
                        retry = true;
                    } else {
                        this.lastAllocatedPage = pageNumber;
                    }
                } else {
                    this.lastAllocatedPage = numtries > 0 ? -1L : pageNumber;
                }
                if (retry) continue;
                SanityManager.ASSERT((!retry ? 1 : 0) != 0);
                if (lastPage > lastPreallocPage) {
                    SanityManager.THROWASSERT((String)("last page " + lastPage + " > lastPreallocPage " + lastPreallocPage));
                }
                boolean bl2 = noIO = (allocHandle.getMode() & 1) == 1;
                if (!noIO && (this.bulkIncreaseContainerSize || pageNumber > lastPreallocPage && pageNumber > (long)this.PreAllocThreshold)) {
                    ((AllocPage)allocPage).preAllocatePage(this, this.PreAllocThreshold, this.PreAllocSize);
                }
                boolean bl3 = prealloced = pageNumber <= (lastPreallocPage = ((AllocPage)allocPage).getLastPreallocPagenum());
                PageCreationArgs createPageArgs = new PageCreationArgs(117, prealloced ? 0 : (noIO ? 0 : 1), this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
                long pageOffset = pageNumber * (long)this.pageSize;
                try {
                    page = this.initPage(allocHandle, pkey, createPageArgs, pageOffset, reuse, isOverflow);
                }
                catch (StandardException se) {
                    SanityManager.DEBUG_PRINT((String)"FileContainer", (String)("got exception from initPage:\nreuse = " + reuse + "\nsyncFlag = " + createPageArgs.syncFlag + "\nallocPage = " + (AllocPage)allocPage));
                    this.allocCache.dumpAllocationCache();
                    throw se;
                }
                SanityManager.ASSERT((page != null ? 1 : 0) != 0, (String)"initPage returns null page");
                SanityManager.ASSERT((boolean)page.isLatched(), (String)"initPage returns unlatched page");
                ((AllocPage)allocPage).addPage(this, pageNumber, ntt, userHandle);
                if (!useNTT) continue;
                page.unlatch();
                page = null;
                page = (BasePage)((Object)this.pageCache.find(pkey));
                page = this.latchPage(userHandle, page, false);
                if (page != null && page.recordCount() == 0 && page.getPageStatus() == 1) continue;
                retry = true;
                if (page != null) {
                    page.unlatch();
                    page = null;
                }
                allocPage.unlatch();
                allocPage = null;
            } while (retry);
            SanityManager.ASSERT((boolean)page.isLatched());
        }
        catch (StandardException se) {
            if (page != null) {
                page.unlatch();
            }
            page = null;
            throw se;
        }
        finally {
            if (!useNTT && allocPage != null) {
                allocPage.unlatch();
                allocPage = null;
            }
        }
        SanityManager.ASSERT((boolean)page.isLatched());
        if (this.bulkIncreaseContainerSize) {
            this.bulkIncreaseContainerSize = false;
            this.PreAllocSize = 8;
        }
        if (!isOverflow && page != null) {
            this.setLastInsertedPage(pageNumber);
        }
        if (this.estimatedPageCount >= 0L) {
            ++this.estimatedPageCount;
        }
        if (!this.identity.equals(page.getPageId().getContainerId())) {
            SanityManager.THROWASSERT((String)("just created a new page from a different container\n this.identity = " + this.identity + "\n page.getPageId().getContainerId() = " + page.getPageId().getContainerId() + "\n userHandle is: " + userHandle + "\n allocHandle is: " + allocHandle + "\n this container is: " + this));
            throw StandardException.newException((String)"XSDAC.S", (Object[])new Object[]{this.identity, page.getPageId().getContainerId()});
        }
        return page;
    }

    @Override
    protected void clearPreallocThreshold() {
        this.PreAllocThreshold = 0;
    }

    @Override
    protected void prepareForBulkLoad(BaseContainerHandle handle, int numPage) {
        this.clearPreallocThreshold();
        RawTransaction tran = handle.getTransaction();
        AllocPage allocPage = this.findLastAllocPage(handle, tran);
        if (allocPage != null) {
            allocPage.preAllocatePage(this, 0, numPage);
            allocPage.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pageValid(BaseContainerHandle handle, long pagenum) throws StandardException {
        boolean done;
        boolean retval = false;
        int maxTries = 120;
        do {
            done = true;
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                try {
                    if (pagenum <= this.allocCache.getLastPageNumber(handle, this.firstAllocPageNumber) && this.allocCache.getPageStatus(handle, pagenum, this.firstAllocPageNumber) == 0) {
                        retval = true;
                    }
                }
                catch (InterruptDetectedException e) {
                    if (--maxTries > 0) {
                        done = false;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ee) {
                            InterruptStatus.setInterrupted();
                        }
                        continue;
                    }
                    throw StandardException.newException((String)"XSDG9.D", (Throwable)((Object)e), (Object[])new Object[0]);
                }
            }
        } while (!done);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastPageNumber(BaseContainerHandle handle) throws StandardException {
        long retval;
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            retval = this.firstAllocPageNumber == -1L ? -1L : this.allocCache.getLastPageNumber(handle, this.firstAllocPageNumber);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocPage findAllocPageForAdd(BaseContainerHandle allocHandle, RawTransaction ntt, long lastAllocatedPage) throws StandardException {
        CachedPage allocPage = null;
        CachedPage oldAllocPage = null;
        boolean success = false;
        try {
            if (this.firstAllocPageNumber == -1L) {
                allocPage = this.makeAllocPage(ntt, allocHandle, 0L, 0L, 80);
                SanityManager.ASSERT((this.firstAllocPageNumber == 0L ? 1 : 0) != 0, (String)"first Alloc Page number is still not set");
                SanityManager.ASSERT((this.firstAllocPageOffset == 0L ? 1 : 0) != 0, (String)"first Alloc Page offset is still not set");
            } else {
                allocPage = (AllocPage)allocHandle.getAllocPage(this.firstAllocPageNumber);
            }
            if (!((AllocPage)allocPage).canAddFreePage(lastAllocatedPage)) {
                boolean found = false;
                while (!((AllocPage)allocPage).isLast()) {
                    long nextAllocPageNumber = ((AllocPage)allocPage).getNextAllocPageNumber();
                    long nextAllocPageOffset = ((AllocPage)allocPage).getNextAllocPageOffset();
                    allocPage.unlatch();
                    allocPage = null;
                    allocPage = (AllocPage)allocHandle.getAllocPage(nextAllocPageNumber);
                    if (!((AllocPage)allocPage).canAddFreePage(lastAllocatedPage)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    long newAllocPageNum;
                    oldAllocPage = allocPage;
                    allocPage = null;
                    SanityManager.ASSERT((((AllocPage)oldAllocPage).getLastPagenum() == ((AllocPage)oldAllocPage).getMaxPagenum() ? 1 : 0) != 0, (String)"expect allocpage to be full but last pagenum != maxpagenum");
                    long newAllocPageOffset = newAllocPageNum = ((AllocPage)oldAllocPage).getMaxPagenum() + 1L;
                    allocPage = this.makeAllocPage(ntt, allocHandle, newAllocPageNum, newAllocPageOffset, 0);
                    ((AllocPage)oldAllocPage).chainNewAllocPage(allocHandle, newAllocPageNum, newAllocPageOffset);
                    oldAllocPage.unlatch();
                    oldAllocPage = null;
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                if (oldAllocPage != null) {
                    oldAllocPage.unlatch();
                }
                if (allocPage != null) {
                    allocPage.unlatch();
                }
                allocPage = null;
            }
        }
        return allocPage;
    }

    private AllocPage findLastAllocPage(BaseContainerHandle handle, RawTransaction tran) {
        AllocPage allocPage = null;
        Object oldAllocPage = null;
        if (this.firstAllocPageNumber == -1L) {
            return null;
        }
        try {
            allocPage = (AllocPage)handle.getAllocPage(this.firstAllocPageNumber);
            while (!allocPage.isLast()) {
                long nextAllocPageNumber = allocPage.getNextAllocPageNumber();
                long nextAllocPageOffset = allocPage.getNextAllocPageOffset();
                allocPage.unlatch();
                allocPage = null;
                allocPage = (AllocPage)handle.getAllocPage(nextAllocPageNumber);
            }
        }
        catch (StandardException se) {
            if (allocPage != null) {
                allocPage.unlatch();
            }
            allocPage = null;
        }
        return allocPage;
    }

    private AllocPage makeAllocPage(RawTransaction ntt, BaseContainerHandle handle, long pageNumber, long pageOffset, int containerInfoSize) throws StandardException {
        if (containerInfoSize != 0 && containerInfoSize != 80) {
            SanityManager.THROWASSERT((String)("expect 0 or 80, got " + containerInfoSize));
        }
        if (pageNumber != 0L && containerInfoSize != 0) {
            SanityManager.THROWASSERT((String)("Not first alloc page but container info size " + containerInfoSize));
        }
        boolean noIO = (handle.getMode() & 1) == 1;
        PageCreationArgs createAllocPageArgs = new PageCreationArgs(118, noIO ? 0 : 1, this.pageSize, 0, this.minimumRecordSize, containerInfoSize);
        if (SanityManager.DEBUG_ON((String)SPACE_TRACE)) {
            SanityManager.DEBUG((String)SPACE_TRACE, (String)("making new allocation page at " + pageNumber));
        }
        if (pageNumber == 0L) {
            this.firstAllocPageNumber = pageNumber;
            this.firstAllocPageOffset = pageOffset;
        }
        PageKey pkey = new PageKey(this.identity, pageNumber);
        return (AllocPage)this.initPage(handle, pkey, createAllocPageArgs, pageOffset, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasePage initPage(BaseContainerHandle allochandle, PageKey pkey, PageCreationArgs createArgs, long pageOffset, boolean reuse, boolean overflow) throws StandardException {
        BasePage page = null;
        boolean releasePage = true;
        try {
            if (reuse) {
                if (SanityManager.DEBUG_ON((String)SPACE_TRACE)) {
                    SanityManager.DEBUG((String)SPACE_TRACE, (String)("reusing page " + pkey));
                }
                if ((page = (BasePage)((Object)this.pageCache.find(pkey))) == null) {
                    throw StandardException.newException((String)"XSDF8.S", (Object[])new Object[]{pkey});
                }
            } else {
                if (SanityManager.DEBUG_ON((String)SPACE_TRACE)) {
                    SanityManager.DEBUG((String)SPACE_TRACE, (String)("allocation new page " + pkey));
                }
                SanityManager.ASSERT(((page = (BasePage)((Object)this.pageCache.create(pkey, createArgs))) != null ? 1 : 0) != 0, (String)"page Cache create return a null page");
            }
            releasePage = false;
            if ((page = this.latchPage(allochandle, page, true)) == null) {
                throw StandardException.newException((String)"XSDF7.S", (Object[])new Object[]{pkey});
            }
            int initPageFlag = 0;
            if (reuse) {
                initPageFlag |= 1;
            }
            if (overflow) {
                initPageFlag |= 2;
            }
            if (reuse && this.isReusableRecordId()) {
                initPageFlag |= 4;
            }
            page.initPage(initPageFlag, pageOffset);
            page.setContainerRowCount(this.estimatedRowCount);
        }
        finally {
            if (releasePage && page != null) {
                this.pageCache.release((Cacheable)((Object)page));
                page = null;
            }
        }
        return page;
    }

    private BasePage getUserPage(BaseContainerHandle handle, long pageNumber, boolean overflowOK, boolean wait) throws StandardException {
        SanityManager.ASSERT((pageNumber != 0L ? 1 : 0) != 0, (String)("getUserPage trying to get an alloc page, pageNumber = " + pageNumber));
        if (pageNumber < 1L) {
            SanityManager.THROWASSERT((String)("pageNumber = " + pageNumber));
        }
        if (pageNumber < 1L) {
            return null;
        }
        if (this.getCommittedDropState()) {
            return null;
        }
        if (!this.pageValid(handle, pageNumber)) {
            return null;
        }
        PageKey pageSearch = new PageKey(this.identity, pageNumber);
        BasePage page = (BasePage)((Object)this.pageCache.find(pageSearch));
        if (page == null) {
            return page;
        }
        if (this.latchPage(handle, page, wait) == null) {
            return null;
        }
        if (page.isOverflowPage() && !overflowOK || page.getPageStatus() != 1) {
            page.unlatch();
            page = null;
        }
        return page;
    }

    protected void trackUnfilledPage(long pagenumber, boolean unfilled) {
        if (!this.dataFactory.isReadOnly()) {
            this.allocCache.trackUnfilledPage(pagenumber, unfilled);
        }
    }

    @Override
    protected BasePage getPage(BaseContainerHandle handle, long pageNumber, boolean wait) throws StandardException {
        return this.getUserPage(handle, pageNumber, true, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage getAnyPage(BaseContainerHandle handle, long pageNumber) throws StandardException {
        if (this.getCommittedDropState()) {
            return null;
        }
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            this.allocCache.invalidate();
        }
        PageKey pageSearch = new PageKey(this.identity, pageNumber);
        BasePage page = (BasePage)((Object)this.pageCache.find(pageSearch));
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage reCreatePageForRedoRecovery(BaseContainerHandle handle, int pageFormat, long pageNumber, long pageOffset) throws StandardException {
        BasePage page;
        block15: {
            PageCreationArgs reCreatePageArgs;
            boolean rollForwardRecovery = handle.getTransaction().inRollForwardRecovery();
            if (!rollForwardRecovery && !PropertyUtil.getSystemBoolean("derby.storage.patchInitPageRecoverError")) {
                return null;
            }
            PageKey pkey = new PageKey(this.identity, pageNumber);
            if (pageFormat == 117) {
                reCreatePageArgs = new PageCreationArgs(pageFormat, 1, this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
            } else if (pageFormat == 118) {
                int containerInfoSize = 0;
                if (pageNumber == 0L) {
                    containerInfoSize = 80;
                    this.firstAllocPageNumber = pageNumber;
                    this.firstAllocPageOffset = pageOffset;
                }
                reCreatePageArgs = new PageCreationArgs(pageFormat, 1, this.pageSize, 0, this.minimumRecordSize, containerInfoSize);
            } else {
                throw StandardException.newException((String)"XSDB1.D", (Object[])new Object[]{pkey});
            }
            if (SanityManager.DEBUG_ON((String)"LoadTran")) {
                SanityManager.DEBUG_PRINT((String)"Trace", (String)("recreating page " + pkey + " for load tran"));
            }
            page = null;
            boolean releasePage = true;
            try {
                try {
                    page = (BasePage)((Object)this.pageCache.create(pkey, reCreatePageArgs));
                }
                catch (StandardException se) {
                    throw StandardException.newException((String)"XSDFI.S", (Throwable)se, (Object[])new Object[]{pkey});
                }
                if (page != null) {
                    releasePage = false;
                    if ((page = this.latchPage(handle, page, false)) == null) {
                        throw StandardException.newException((String)"XSDF7.S", (Object[])new Object[]{pkey});
                    }
                    break block15;
                }
                throw StandardException.newException((String)"XSDFI.S", (Object[])new Object[]{pkey});
            }
            finally {
                if (releasePage && page != null) {
                    this.pageCache.release((Cacheable)((Object)page));
                    page = null;
                }
            }
        }
        return page;
    }

    @Override
    protected BasePage getAllocPage(long pageNumber) throws StandardException {
        if (this.getCommittedDropState()) {
            return null;
        }
        PageKey pageSearch = new PageKey(this.identity, pageNumber);
        BasePage page = (BasePage)((Object)this.pageCache.find(pageSearch));
        if (page == null) {
            SanityManager.THROWASSERT((String)("getting a null alloc page page " + this.getIdentity() + pageNumber));
        }
        if (!(page instanceof AllocPage)) {
            SanityManager.THROWASSERT((String)("trying to get a user page as an alloc page " + this.getIdentity() + pageNumber));
        }
        return page;
    }

    @Override
    protected BasePage getHeadPage(BaseContainerHandle handle, long pageNumber, boolean wait) throws StandardException {
        return this.getUserPage(handle, pageNumber, false, wait);
    }

    @Override
    protected BasePage getFirstHeadPage(BaseContainerHandle handle, boolean wait) throws StandardException {
        return this.getNextHeadPage(handle, 0L, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage getNextHeadPage(BaseContainerHandle handle, long pageNumber, boolean wait) throws StandardException {
        while (true) {
            long nextNumber;
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                nextNumber = this.allocCache.getNextValidPage(handle, pageNumber, this.firstAllocPageNumber);
            }
            if (nextNumber == -1L) {
                return null;
            }
            BasePage p = this.getUserPage(handle, nextNumber, false, wait);
            if (p != null) {
                return p;
            }
            pageNumber = nextNumber;
        }
    }

    private BasePage getInsertablePage(BaseContainerHandle handle, long pageNumber, boolean wait, boolean overflowOK) throws StandardException {
        if (pageNumber == -1L) {
            return null;
        }
        BasePage p = this.getUserPage(handle, pageNumber, overflowOK, wait);
        if (p != null && !p.allowInsert()) {
            p.unlatch();
            p = null;
            this.allocCache.trackUnfilledPage(pageNumber, false);
        }
        return p;
    }

    @Override
    protected BasePage getPageForCompress(BaseContainerHandle handle, int flag, long pageno) throws StandardException {
        boolean getLastInserted;
        BasePage p = null;
        boolean bl = getLastInserted = (flag & 1) == 0;
        if (getLastInserted) {
            long localLastInsertedPage = this.getLastInsertedPage();
            if (localLastInsertedPage < pageno && localLastInsertedPage != -1L && (p = this.getInsertablePage(handle, localLastInsertedPage, true, false)) == null) {
                if (localLastInsertedPage == this.getLastUnfilledPage()) {
                    this.setLastUnfilledPage(-1L);
                }
                if (localLastInsertedPage == this.getLastInsertedPage()) {
                    this.setLastInsertedPage(-1L);
                }
            }
        } else {
            long localLastUnfilledPage = this.getLastUnfilledPage();
            if (localLastUnfilledPage == -1L || localLastUnfilledPage >= pageno || localLastUnfilledPage == this.getLastInsertedPage()) {
                localLastUnfilledPage = this.getUnfilledPageNumber(handle, 0L);
            }
            if (localLastUnfilledPage != -1L && localLastUnfilledPage < pageno) {
                p = this.getInsertablePage(handle, localLastUnfilledPage, true, false);
            }
            if (p != null) {
                this.setLastUnfilledPage(localLastUnfilledPage);
                this.setLastInsertedPage(localLastUnfilledPage);
            }
        }
        return p;
    }

    @Override
    protected BasePage getPageForInsert(BaseContainerHandle handle, int flag) throws StandardException {
        boolean getLastInserted;
        BasePage p = null;
        boolean bl = getLastInserted = (flag & 1) == 0;
        if (getLastInserted) {
            long localLastInsertedPage = this.getLastInsertedPage();
            if (localLastInsertedPage != -1L && (p = this.getInsertablePage(handle, localLastInsertedPage, false, false)) == null) {
                localLastInsertedPage = this.getLastInsertedPage();
                p = this.getInsertablePage(handle, localLastInsertedPage, true, false);
            }
            if (p == null) {
                if (localLastInsertedPage == this.getLastUnfilledPage()) {
                    this.setLastUnfilledPage(-1L);
                }
                if (localLastInsertedPage == this.getLastInsertedPage()) {
                    this.setLastInsertedPage(-1L);
                }
            }
        } else {
            long localLastUnfilledPage = this.getLastUnfilledPage();
            if (localLastUnfilledPage == -1L || localLastUnfilledPage == this.getLastInsertedPage()) {
                localLastUnfilledPage = this.getUnfilledPageNumber(handle, localLastUnfilledPage);
            }
            if (localLastUnfilledPage != -1L && (p = this.getInsertablePage(handle, localLastUnfilledPage, true, false)) == null && (localLastUnfilledPage = this.getUnfilledPageNumber(handle, localLastUnfilledPage)) != -1L) {
                p = this.getInsertablePage(handle, localLastUnfilledPage, true, false);
            }
            if (p != null) {
                this.setLastUnfilledPage(localLastUnfilledPage);
                this.setLastInsertedPage(localLastUnfilledPage);
            }
        }
        return p;
    }

    protected BasePage getLatchedPage(BaseContainerHandle handle, long pageNumber) throws StandardException {
        PageKey pageKey = new PageKey(this.identity, pageNumber);
        BasePage page = (BasePage)((Object)this.pageCache.find(pageKey));
        SanityManager.ASSERT((page != null ? 1 : 0) != 0, (String)("page is not found :" + pageKey));
        page = this.latchPage(handle, page, true);
        SanityManager.ASSERT((boolean)page.isLatched(), (String)("page is not latched:" + pageKey));
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUnfilledPageNumber(BaseContainerHandle handle, long pagenum) throws StandardException {
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            return this.allocCache.getUnfilledPageNumber(handle, this.firstAllocPageNumber, pagenum);
        }
    }

    @Override
    public long getEstimatedRowCount(int flag) {
        return this.estimatedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEstimatedRowCount(long count, int flag) {
        boolean readOnly = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.estimatedRowCount = count;
            if (!readOnly) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEstimatedRowCount(int delta) {
        boolean readOnly = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.estimatedRowCount += (long)delta;
            if (this.estimatedRowCount < 0L) {
                this.estimatedRowCount = 0L;
            }
            if (!readOnly) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEstimatedPageCount(BaseContainerHandle handle, int flag) throws StandardException {
        if (this.estimatedPageCount < 0L) {
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                this.estimatedPageCount = this.allocCache.getEstimatedPageCount(handle, this.firstAllocPageNumber);
            }
        }
        SanityManager.ASSERT((this.estimatedPageCount >= 0L ? 1 : 0) != 0, (String)"AllocCache returns negatie estimatedPageCount");
        return this.estimatedPageCount;
    }

    protected abstract void readPage(long var1, byte[] var3) throws IOException, StandardException;

    protected abstract void writePage(long var1, byte[] var3, boolean var4) throws IOException, StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decryptPage(byte[] pageData, int pageSize) throws StandardException {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            int len;
            if (this.encryptionBuffer == null || this.encryptionBuffer.length < pageSize) {
                this.encryptionBuffer = new byte[pageSize];
            }
            SanityManager.ASSERT(((len = this.dataFactory.decrypt(pageData, 0, pageSize, this.encryptionBuffer, 0)) == pageSize ? 1 : 0) != 0, (String)"Encrypted page length != page length");
            System.arraycopy(this.encryptionBuffer, 8, pageData, 0, pageSize - 8);
            System.arraycopy(this.encryptionBuffer, 0, pageData, pageSize - 8, 8);
        }
    }

    protected byte[] encryptPage(byte[] pageData, int pageSize, byte[] encryptionBuffer, boolean newEngine) throws StandardException {
        System.arraycopy(pageData, pageSize - 8, encryptionBuffer, 0, 8);
        System.arraycopy(pageData, 0, encryptionBuffer, 8, pageSize - 8);
        int len = this.dataFactory.encrypt(encryptionBuffer, 0, pageSize, encryptionBuffer, 0, newEngine);
        SanityManager.ASSERT((len == pageSize ? 1 : 0) != 0, (String)"Encrypted page length != page length");
        return encryptionBuffer;
    }

    protected byte[] getEncryptionBuffer() {
        if (this.encryptionBuffer == null || this.encryptionBuffer.length < this.pageSize) {
            this.encryptionBuffer = new byte[this.pageSize];
        }
        return this.encryptionBuffer;
    }

    protected abstract int preAllocate(long var1, int var3);

    protected int doPreAllocatePages(long lastPreallocPagenum, int preAllocSize) {
        int count;
        SanityManager.ASSERT((!this.dataFactory.isReadOnly() ? 1 : 0) != 0, (String)"how can we be Preallocating pages in a read only database?");
        PageCreationArgs createArgs = new PageCreationArgs(117, 2, this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
        StoredPage page = new StoredPage();
        page.setFactory(this.dataFactory);
        boolean error = false;
        for (count = 0; count < preAllocSize; ++count) {
            PageKey pkey = new PageKey(this.identity, lastPreallocPagenum + (long)count + 1L);
            try {
                page.createIdentity(pkey, createArgs);
                SanityManager.ASSERT((!page.isDirty() ? 1 : 0) != 0, (String)"create identity failed to do a write page");
                page.clearIdentity();
            }
            catch (StandardException se) {
                error = true;
            }
            if (error) break;
        }
        return count;
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected int getSpareSpace() {
        return this.spareSpace;
    }

    protected int getMinimumRecordSize() {
        return this.minimumRecordSize;
    }

    private synchronized void switchToMultiInsertPageMode(BaseContainerHandle handle) throws StandardException {
        if (this.lastInsertedPage.length == 1) {
            long last = this.lastInsertedPage[0];
            this.lastInsertedPage = new long[4];
            this.lastInsertedPage[0] = last;
            for (int i = 3; i > 0; --i) {
                Page page = this.addPage(handle, false);
                this.lastInsertedPage[i] = page.getPageNumber();
                page.unlatch();
            }
        }
    }

    private synchronized long getLastInsertedPage() {
        if (this.lastInsertedPage.length == 1) {
            SanityManager.ASSERT((this.lastInsertedPage_index == 0 ? 1 : 0) != 0);
            return this.lastInsertedPage[0];
        }
        long ret = this.lastInsertedPage[this.lastInsertedPage_index++];
        if (this.lastInsertedPage_index > this.lastInsertedPage.length - 1) {
            this.lastInsertedPage_index = 0;
        }
        return ret;
    }

    private synchronized long getLastUnfilledPage() {
        return this.lastUnfilledPage;
    }

    private synchronized void initializeLastInsertedPage(int size) {
        this.lastInsertedPage = new long[size];
        for (int i = this.lastInsertedPage.length - 1; i >= 0; --i) {
            this.lastInsertedPage[i] = -1L;
        }
        this.lastInsertedPage_index = 0;
    }

    private synchronized void setLastInsertedPage(long val) {
        this.lastInsertedPage[this.lastInsertedPage_index] = val;
    }

    private synchronized void setLastUnfilledPage(long val) {
        this.lastUnfilledPage = val;
    }

    @Override
    protected void letGo(BaseContainerHandle handle) {
        super.letGo(handle);
        this.containerCache.release(this);
    }

    @Override
    protected BasePage latchPage(BaseContainerHandle handle, BasePage foundPage, boolean wait) throws StandardException {
        if (foundPage == null) {
            return null;
        }
        BasePage ret = super.latchPage(handle, foundPage, wait);
        if (ret == null) {
            this.pageCache.release((Cacheable)((Object)foundPage));
        }
        return ret;
    }

    @Override
    protected abstract void backupContainer(BaseContainerHandle var1, String var2) throws StandardException;

    static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object getServiceModule(final Object serviceModule, final String factoryInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(serviceModule, factoryInterface);
            }
        });
    }
}

