/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class IndexedItemIterator<R>
implements ReversibleIndexedIterator<R> {
    private final Indexed<R> items;
    private final boolean reversed;
    private int next;
    private int last;
    private int modificationCount;

    public IndexedItemIterator(@NotNull Indexed<R> items) {
        this(items, false);
    }

    public IndexedItemIterator(@NotNull Indexed<R> items, boolean isReversed) {
        this.items = items;
        this.reversed = isReversed;
        int n = this.next = this.reversed ? items.size() - 1 : 0;
        if (this.next >= items.size()) {
            this.next = -1;
        }
        this.last = -1;
        this.modificationCount = items.modificationCount();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean hasNext() {
        return this.next != -1;
    }

    @Override
    @NotNull
    public R next() {
        if (this.modificationCount != this.items.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        this.last = this.next;
        this.next = this.reversed ? (this.next <= 0 ? -1 : this.next - 1) : (this.next == this.items.size() - 1 ? -1 : this.next + 1);
        return this.items.get(this.last);
    }

    @Override
    public void remove() {
        if (this.last == -1) {
            throw new NoSuchElementException();
        }
        if (this.modificationCount != this.items.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.items.removeAt(this.last);
        this.last = -1;
        this.modificationCount = this.items.modificationCount();
    }

    @Override
    public int getIndex() {
        if (this.last < 0) {
            throw new NoSuchElementException();
        }
        return this.last;
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super R> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

