/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

class BaseTabLayoutModel
implements TabLayoutModel {
    protected TabDataModel model;
    protected int textHeight = -1;
    protected int padX = 5;
    protected int padY = 5;
    protected JComponent renderTarget;
    private static Map<String, Integer> widthMap = new HashMap<String, Integer>(31);

    protected BaseTabLayoutModel(TabDataModel tabDataModel, JComponent jComponent) {
        this.model = tabDataModel;
        this.renderTarget = jComponent;
    }

    private Font getFont() {
        return this.renderTarget.getFont();
    }

    protected int iconWidth(int n) {
        Icon icon = this.model.getTab(n).getIcon();
        int n2 = icon != null ? icon.getIconWidth() : 0;
        return n2;
    }

    protected int iconHeight(int n) {
        Icon icon = this.model.getTab(n).getIcon();
        int n2 = icon != null ? icon.getIconHeight() : 0;
        return n2;
    }

    protected int textWidth(int n) {
        try {
            String string = this.model.getTab(n).getText();
            return BaseTabLayoutModel.textWidth(string, this.getFont());
        }
        catch (NullPointerException nullPointerException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error fetching width for tab " + n + " - model size is " + this.model.size() + " TabData is " + this.model.getTab(n) + " model contents: " + this.model);
            throw illegalArgumentException;
        }
    }

    static int textWidth(String string, Font font) {
        Integer n = widthMap.get(string);
        if (n == null) {
            double d = HtmlRenderer.renderString((String)string, (Graphics)BasicScrollingTabDisplayerUI.getOffscreenGraphics(), (int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)font, (Color)Color.BLACK, (int)1, (boolean)false);
            n = new Integer(Math.round(Math.round(d)));
            widthMap.put(string, n);
        }
        return n;
    }

    protected int textHeight(int n) {
        if (this.textHeight == -1) {
            String string = "Zgj";
            Font font = this.getFont();
            this.textHeight = new Double(font.getStringBounds(string, BasicScrollingTabDisplayerUI.getOffscreenGraphics().getFontRenderContext()).getWidth()).intValue() + 2;
        }
        return this.textHeight;
    }

    public int getX(int n) {
        int n2 = this.renderTarget.getInsets().left;
        for (int i = 0; i < n; ++i) {
            n2 += this.getW(i);
        }
        return n2;
    }

    public int getY(int n) {
        return this.renderTarget.getInsets().top;
    }

    public int getH(int n) {
        return Math.max(this.textHeight(n) + this.padY, this.model.getTab(n).getIcon().getIconHeight() + this.padY);
    }

    public int getW(int n) {
        return this.textWidth(n) + this.iconWidth(n) + this.padX;
    }

    public int indexOfPoint(int n, int n2) {
        int n3 = this.model.size();
        int n4 = this.renderTarget.getInsets().left;
        for (int i = 0; i < n3; ++i) {
            if ((n4 += this.getW(i)) <= n) continue;
            return i;
        }
        return -1;
    }

    public int dropIndexOfPoint(int n, int n2) {
        Insets insets = this.renderTarget.getInsets();
        int n3 = this.renderTarget.getWidth() - (insets.left + insets.right);
        int n4 = this.renderTarget.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.model.size();
        int n6 = insets.left;
        for (int i = 0; i < n5; ++i) {
            int n7 = this.getW(i);
            if (n <= (n6 += n7) - n7 / 2) {
                return i;
            }
            if (n >= n6) continue;
            return i + 1;
        }
        return n5;
    }

    public void setPadding(Dimension dimension) {
        this.padX = dimension.width;
        this.padY = dimension.height;
    }
}

