/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.repository.Messages;
import org.pentaho.di.repository.ProfileMeta;
import org.pentaho.di.repository.Repository;

public class UserInfo {
    private long id;
    private String login;
    private String password;
    private String name;
    private String description;
    private boolean enabled;
    private ProfileMeta profile;

    public UserInfo(String login, String password, String name, String description, boolean enabled, ProfileMeta profile) {
        this.login = login;
        this.password = password;
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.profile = profile;
    }

    public UserInfo() {
        this.login = null;
        this.password = null;
        this.name = null;
        this.description = null;
        this.enabled = true;
        this.profile = null;
    }

    public UserInfo(Repository rep, String login) throws KettleException {
        try {
            RowMetaAndData r;
            this.setID(rep.getUserID(login));
            if (this.getID() > 0L) {
                r = rep.getUser(this.getID());
                if (r == null) {
                    this.setID(-1L);
                    throw new KettleDatabaseException(Messages.getString("UserInfo.Error.UserNotFound", login));
                }
            } else {
                this.setID(-1L);
                throw new KettleDatabaseException(Messages.getString("UserInfo.Error.UserNotFound", login));
            }
            this.login = r.getString("LOGIN", null);
            this.password = Encr.decryptPassword((String)r.getString("PASSWORD", null));
            this.name = r.getString("NAME", null);
            this.description = r.getString("DESCRIPTION", null);
            this.enabled = r.getBoolean("ENABLED", false);
            long id_profile = r.getInteger("ID_PROFILE", 0L);
            this.profile = new ProfileMeta(rep, id_profile);
        }
        catch (KettleDatabaseException dbe) {
            rep.log.logError(this.toString(), Messages.getString("UserInfo.Error.UserNotLoaded", login, dbe.getMessage()), new Object[0]);
            throw new KettleException(Messages.getString("UserInfo.Error.UserNotLoaded", login, ""), (Throwable)dbe);
        }
    }

    public UserInfo(Repository rep, String login, String passwd) throws KettleException {
        this(rep, login);
        if (this.getID() < 0L || !passwd.equals(this.getPassword())) {
            throw new KettleDatabaseException(Messages.getString("UserInfo.Error.IncorrectPasswortLogin"));
        }
        rep.setUserInfo(this);
    }

    public void saveRep(Repository rep) throws KettleException {
        try {
            if (this.getID() <= 0L) {
                this.setID(rep.getUserID(this.login));
            }
            if (this.getID() <= 0L) {
                this.setID(rep.getNextUserID());
                rep.insertTableRow("R_USER", this.fillTableRow());
            } else {
                rep.updateTableRow("R_USER", "ID_USER", this.fillTableRow());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("UserInfo.Error.SavingUser", this.login), (Throwable)dbe);
        }
    }

    public RowMetaAndData fillTableRow() {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue(new ValueMeta("ID_USER", 5), (Object)new Long(this.getID()));
        r.addValue(new ValueMeta("LOGIN", 2), (Object)this.login);
        r.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPassword((String)this.password));
        r.addValue(new ValueMeta("NAME", 2), (Object)this.name);
        r.addValue(new ValueMeta("DESCRIPTION", 2), (Object)this.description);
        r.addValue(new ValueMeta("ENABLED", 4), (Object)this.enabled);
        r.addValue(new ValueMeta("ID_PROFILE", 5), (Object)this.profile.getID());
        return r;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setDisabled() {
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProfile(ProfileMeta profile) {
        this.profile = profile;
    }

    public ProfileMeta getProfile() {
        return this.profile;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        if (this.profile == null) {
            return true;
        }
        return this.profile.isReadonly();
    }

    public boolean isAdministrator() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.isAdministrator();
    }

    public boolean useTransformations() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useTransformations();
    }

    public boolean useJobs() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useJobs();
    }

    public boolean useSchemas() {
        if (this.profile == null) {
            return false;
        }
        return this.profile.useSchemas();
    }
}

