/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.table.model;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.CollectionData;
import com.almworks.tracklink.codelinks.cache.ArtifactInfoCache;
import com.almworks.tracklink.toolwindow.table.IssueTableController;
import com.almworks.tracklink.toolwindow.table.model.ArtifactInfoRow;
import com.almworks.tracklink.toolwindow.table.model.IssueTableModel;
import com.almworks.tracklink.toolwindow.table.model.TableCollectionRow;
import com.almworks.tracklink.toolwindow.table.model.TableFilteringRow;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.Lifecycle;
import org.almworks.util.detach.Lifespan;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactCollectionRow
extends TableCollectionRow {
    private final Lifecycle myLifespan = new Lifecycle();
    private final Map<String, ArtifactInfoRow> myChildByUrlMap = new HashMap<String, ArtifactInfoRow>();
    private final IssueTableController myController;
    private CollectionData myCollection;
    private String myIdPrefix;
    private int myIncludeCount;
    private String myCollectionName;

    public ArtifactCollectionRow(CollectionData data, IssueTableController controller, IssueTableModel model) {
        super(model);
        this.myCollection = data;
        this.myController = controller;
        this.init();
    }

    protected void init() {
        this.myLifespan.cycle();
        this.myLifespan.lifespan().add(new Detach(){

            protected void doDetach() {
                ArtifactCollectionRow.this.removeAllArtifacts();
            }
        });
        this.cacheName();
    }

    public String getCollectionName() {
        return this.myCollectionName;
    }

    public Lifespan getLifespan() {
        return this.myLifespan.lifespan();
    }

    public void detach() {
        this.myLifespan.cycle();
    }

    public void cacheName() {
        CollectionData cdata = this.getCollectionData();
        this.myCollectionName = (String)cdata.getProperty(CollectionData.COLLECTION_NAME);
    }

    @Override
    public String getColumn(int index) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.myCollectionName);
        buf.append(" (");
        if (this.myModel.isFiltering()) {
            buf.append(this.myFilteringCache.include(this.myChildren, this.myModel.getFilterPattern()).size()).append('/');
        }
        buf.append(this.getCollectionSize());
        buf.append(")");
        return buf.toString();
    }

    public CollectionData getCollectionData() {
        return this.myCollection;
    }

    public void onUpdate(@Nullable CollectionData collectionData, @Nullable Collection<String> urls, @NotNull ArtifactInfoCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/almworks/tracklink/toolwindow/table/model/ArtifactCollectionRow.onUpdate must not be null");
        }
        if (collectionData != null) {
            this.setCollectionData(collectionData);
            boolean updated = false;
            HashSet<String> urlsToRemove = new HashSet<String>(this.myChildByUrlMap.keySet());
            urlsToRemove.removeAll(urls);
            HashSet<String> urlsToInsert = new HashSet<String>(urls);
            urlsToInsert.removeAll(this.myChildByUrlMap.keySet());
            if (!urlsToInsert.isEmpty()) {
                this.insertArtifacts(urlsToInsert, cache);
                updated = true;
            }
            if (!urlsToRemove.isEmpty()) {
                this.removeArtifacts(urlsToRemove);
                updated = true;
            }
            this.updateFiltering(true);
            this.cacheName();
            this.myController.getModel().fireTableDataChanged();
        } else {
            this.removeAllArtifacts();
            this.myModel.fireTableDataChanged();
        }
    }

    public void setCollectionData(CollectionData collection) {
        this.myCollection = collection;
    }

    private boolean removeAllArtifacts() {
        HashSet<String> dereferencedUrls = new HashSet<String>();
        if (this.getCollectionSize() == 0) {
            return false;
        }
        for (TableFilteringRow child : this.myChildren) {
            if (!(child instanceof ArtifactInfoRow)) continue;
            ArtifactInfoRow anode = (ArtifactInfoRow)child;
            anode.dereference();
            dereferencedUrls.add(anode.getUrl());
        }
        this.removeAllChildren();
        this.deactivateUnreferenced(dereferencedUrls);
        return true;
    }

    private void deactivateUnreferenced(Set<String> dereferencedUrls) {
        for (String dereferencedUrl : dereferencedUrls) {
            this.myChildByUrlMap.remove(dereferencedUrl);
        }
        this.myChildByUrlMap.clear();
    }

    private void insertArtifacts(Collection<String> urls, ArtifactInfoCache cache) {
        for (String url : urls) {
            ArtifactInfoRow artifactNode = new ArtifactInfoRow(url, cache, this);
            this.myChildByUrlMap.put(url, artifactNode);
            this.insert(artifactNode, this.findIndexFor(artifactNode));
        }
    }

    private int findIndexFor(ArtifactInfoRow newNode) {
        int count = this.myChildren.size();
        if (count == 0) {
            return 0;
        }
        int r = Collections.binarySearch(this.myChildren, newNode, TableFilteringRow.ROW_COMPARATOR);
        if (r < 0) {
            r = -r - 1;
        }
        assert (r >= 0 && r <= count);
        return r;
    }

    private void removeArtifacts(Set<String> urls) {
        assert (!urls.isEmpty());
        for (String url : urls) {
            ArtifactInfoRow anode = this.findChild(url);
            this.removeChild(anode);
            this.myChildByUrlMap.remove(url);
        }
    }

    public void updateArtifact(ArtifactInfo newInfo) {
        ArtifactInfoRow artRow = this.findChild(newInfo.getUrl());
        if (artRow != null) {
            artRow.setArtifactInfo(newInfo);
            this.myFilteringCache.clear();
            if (this.myModel.isFiltering()) {
                this.updateFiltering(true);
            }
        }
    }

    @Nullable
    public ArtifactInfoRow findChild(String url) {
        return this.myChildByUrlMap.get(url);
    }
}

