/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.constants;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum MIMEType {
    CSS("text/css"),
    DTBOOK("application/x-dtbook+xml"),
    EPUB("application/epub+zip"),
    HTML("text/html"),
    IMAGE_JPEG("image/jpeg"),
    IMAGE_GIF("image/gif"),
    IMAGE_PNG("image/png"),
    OEBPS("text/x-oeb1-document"),
    PACKAGE_DOC("application/oebps-package+xml"),
    SEARCH_KEY_MAP("application/vnd.epub.search-key-map+xml"),
    SMIL("application/smil+xml"),
    SVG("image/svg+xml"),
    XHTML("application/xhtml+xml"),
    OTHER("*/*");

    private static final Map<String, MIMEType> ENUM_MAP;
    private final String definition;

    private MIMEType(String definition) {
        this.definition = definition;
    }

    public String toString() {
        return this.definition;
    }

    public boolean is(String string) {
        return string != null && this.toString().equals(string.toLowerCase(Locale.ROOT));
    }

    public static MIMEType get(String name) {
        return name != null ? ENUM_MAP.getOrDefault(name.toLowerCase(Locale.ROOT), OTHER) : OTHER;
    }

    public static String removeParams(String typeString) {
        if (typeString == null) {
            return null;
        }
        int semicolon = (typeString = typeString.trim()).indexOf(59);
        return semicolon > 0 ? typeString.substring(0, semicolon) : typeString;
    }

    static {
        ConcurrentHashMap<String, MIMEType> map = new ConcurrentHashMap<String, MIMEType>();
        for (MIMEType value : MIMEType.values()) {
            map.put(value.toString(), value);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

