/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.jboss.galleon.config.ConfigId;

public interface CliErrors {
    public static String addFeatureFailed() {
        return CliErrors.failed("Add feature");
    }

    public static String addRepositoryFailed() {
        return CliErrors.failed("Add repository");
    }

    public static String addUniverseFailed() {
        return CliErrors.failed("Add universe");
    }

    public static String cantExcludeLayer(String layer) {
        return "Layer " + layer + " has been included, can't be excluded.";
    }

    public static String checkForUpdatesFailed() {
        return CliErrors.failed("Check for updates");
    }

    public static String commandNotFound(String cmd) {
        return "Command named " + cmd + " was not found.";
    }

    public static String clearHistoryFailed() {
        return CliErrors.failed("Clear history");
    }

    public static String configurationAlreadyExists(ConfigId id) {
        return "Configuration " + id + " already exists";
    }

    public static String configurationNotFound(ConfigId id) {
        return "Configuration " + id + " not found";
    }

    public static String diffFailed() {
        return CliErrors.failed("Diff");
    }

    public static String defineConfigFailed() {
        return CliErrors.failed("Define config");
    }

    public static String displayContentFailed() {
        return CliErrors.failed("Display content");
    }

    public static String editCommandFailed() {
        return CliErrors.failed("Edit Command");
    }

    public static String emptyOption(String opt) {
        return "Empty option " + opt;
    }

    public static String enterFPFailed() {
        return CliErrors.failed("Enter feature-pack");
    }

    public static String excludeFailed() {
        return CliErrors.failed("Exclude");
    }

    public static String exploreFailed() {
        return CliErrors.failed("Explore");
    }

    public static String exportProvisionedFailed() {
        return CliErrors.failed("Export provisioned state");
    }

    public static String failed(String action) {
        return action + " failed.";
    }

    public static String resolveFeaturePackFailed() {
        return CliErrors.failed("Resolve feature pack");
    }

    public static String getHistoryLimitFailed() {
        return CliErrors.failed("Get history limit");
    }

    public static String invalidBoolean(String value) {
        return "Invalid boolean value " + value;
    }

    public static String invalidConfigDirectory(Path galleonDir) {
        return "Configuration directory " + galleonDir + " is not a directory.";
    }

    public static String invalidHistoryLimit(String limit) {
        return "Invalid history limit " + limit;
    }

    public static String invalidInfoType() {
        return "Invalid info type";
    }

    public static String invalidMavenUpdatePolicy(String policy) {
        return "Invalid update policy " + policy;
    }

    public static String invalidUniverse() {
        return "Invalid universe";
    }

    public static String importFeaturePackFailed() {
        return CliErrors.failed("Import feature-pack");
    }

    public static String includeFailed() {
        return CliErrors.failed("Include");
    }

    public static String infoFailed() {
        return CliErrors.failed("Retrieve info");
    }

    public static String layerAlreadyExists(String l, Collection<ConfigId> layers) {
        return "Layer " + l + " already exists in configuration: " + layers;
    }

    public static String layerNotIncluded(String l, Collection<ConfigId> layers) {
        return "Layer " + l + " not included in configuration: " + layers;
    }

    public static String layerNotIncluded(String l, Set<String> layers) {
        return "Layer " + l + " not present in included layers: " + layers;
    }

    public static String layerNotExcluded(String l, Set<String> layers) {
        return "Layer " + l + " not present in excluded layers: " + layers;
    }

    public static String installFailed() {
        return CliErrors.failed("Install");
    }

    public static String missingPattern() {
        return "Pattern is missing.";
    }

    public static String newStateFailed() {
        return CliErrors.failed("Create new state");
    }

    public static String noDirectoryProvided() {
        return "No directory provided";
    }

    public static String notValidInstallation(Path dir) {
        return dir + " is not a valid installation";
    }

    public static String notFile(String absolutePath) {
        return "Not a file: " + absolutePath;
    }

    public static String onlyOneConfigurationWithlayers() {
        return "Only one configuration is allowed when using layers";
    }

    public static String onlyOneOptionOf(String ... options) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < options.length; ++i) {
            builder.append(options[i]);
            if (i >= options.length - 1) continue;
            builder.append(", ");
        }
        return "Only one of " + builder + " options can be set";
    }

    public static String provisioningFailed() {
        return CliErrors.failed("Provisioning");
    }

    public static String readContentFailed() {
        return CliErrors.failed("Read content state");
    }

    public static String readProvisionedStateFailed() {
        return CliErrors.failed("Read provisioned state");
    }

    public static String removeFailed() {
        return CliErrors.failed("Remove");
    }

    public static String removeFeatureFailed() {
        return CliErrors.failed("Remove feature");
    }

    public static String removeRepositoryFailed() {
        return CliErrors.failed("Remove repository");
    }

    public static String removeUniverseFailed() {
        return CliErrors.failed("Remove universe");
    }

    public static String resetConfigFailed() {
        return CliErrors.failed("Reset configuration");
    }

    public static String resolveLocationFailed() {
        return CliErrors.failed("Resolve location");
    }

    public static String resolvedUniverseFailed() {
        return CliErrors.failed("Resolve universe");
    }

    public static String retrievePath() {
        return CliErrors.failed("Retrieve path");
    }

    public static String retrieveProducerFailed() {
        return CliErrors.failed("Retrieve producer");
    }

    public static String retrieveFeaturePackID() {
        return CliErrors.failed("Retrieve feature-pack id");
    }

    public static String searchFailed() {
        return CliErrors.failed("Search");
    }

    public static String setHistoryLimitFailed() {
        return CliErrors.failed("Set history limit");
    }

    public static String setLocalRepositoryFailed() {
        return CliErrors.failed("Set local repository");
    }

    public static String setSettingsFailed() {
        return CliErrors.failed("Set settings");
    }

    public static String stateCommandFailed() {
        return CliErrors.failed("State Command");
    }

    public static String subCommandMissing() {
        return "Sub command is missing";
    }

    public static String tooMuchModels() {
        return "More than one layer model, model must be specified";
    }

    public static String undoFailed() {
        return CliErrors.failed("Undo");
    }

    public static String uninstallFailed() {
        return CliErrors.failed("Uninstall");
    }

    public static String unknownDirectory(String dir) {
        return "Directory " + dir + " doesn't exist";
    }

    public static String noExcludedLayers() {
        return "No layer have been excluded in the current installation, can't remove layer exclusion.";
    }

    public static String notDependencyLayer(String layer) {
        return "Layer " + layer + " is not a dependency of the provisioned layers.";
    }

    public static String notExcludedLayer(String layer) {
        return "Layer " + layer + " has not been excluded.";
    }

    public static String unknownFile(String absolutePath) {
        return "File " + absolutePath + " doesn't exist";
    }

    public static String unknownLayer(String layer) {
        return "Unknown layer " + layer;
    }

    public static String noLayers() {
        return "No layers";
    }

    public static String noLayersForModel(String model) {
        return "No layers for model " + model;
    }

    public static String updateFailed() {
        return CliErrors.failed("Update");
    }

    public static String stateAddFeaturePackVersionFailed() {
        return "The feature-pack version is greater than current state version, you must upgrade Galleon CLI r add the dependency when calling 'state new' command.";
    }
}

