/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "", "maxHeight", "", "maxFrameRate", "", "<init>", "(ID)V", "getMaxHeight", "()I", "getMaxFrameRate", "()D", "toString", "", "heightIsLimited", "", "frameRateIsLimited", "isDisabled", "component1", "component2", "copy", "equals", "other", "hashCode", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVideoConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoConstraints.kt\norg/jitsi/videobridge/cc/allocation/VideoConstraints\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class VideoConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxHeight;
    private final double maxFrameRate;
    public static final int UNLIMITED_HEIGHT = -1;
    public static final double UNLIMITED_FRAME_RATE = -1.0;
    @NotNull
    private static final VideoConstraints NOTHING = new VideoConstraints(0, 0.0, 2, null);
    @NotNull
    private static final VideoConstraints UNLIMITED = new VideoConstraints(-1, -1.0);

    @JvmOverloads
    public VideoConstraints(int maxHeight, double maxFrameRate) {
        this.maxHeight = maxHeight;
        this.maxFrameRate = maxFrameRate;
        if (!(this.maxHeight == -1 || this.maxHeight >= 0)) {
            boolean $i$a$-require-VideoConstraints$32 = false;
            String $i$a$-require-VideoConstraints$32 = "maxHeight must be either -1, 0, or positive.";
            throw new IllegalArgumentException($i$a$-require-VideoConstraints$32.toString());
        }
        if (!(this.maxFrameRate == -1.0 || this.maxFrameRate >= 0.0)) {
            boolean bl = false;
            String string = "maxFrameRate must be either -1, or >= 0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ VideoConstraints(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 2) != 0) {
            d = -1.0;
        }
        this(n, d);
    }

    public final int getMaxHeight() {
        return this.maxHeight;
    }

    public final double getMaxFrameRate() {
        return this.maxFrameRate;
    }

    @NotNull
    public String toString() {
        JSONObject jSONObject;
        JSONObject $this$toString_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$toString_u24lambda_u242).put("maxHeight", this.maxHeight);
        ((Map)$this$toString_u24lambda_u242).put("maxFrameRate", this.maxFrameRate);
        String string = jSONObject.toJSONString();
        Intrinsics.checkNotNullExpressionValue(string, "toJSONString(...)");
        return string;
    }

    public final boolean heightIsLimited() {
        return this.maxHeight != -1;
    }

    public final boolean frameRateIsLimited() {
        return !(this.maxFrameRate == -1.0);
    }

    public final boolean isDisabled() {
        return this.maxHeight == 0 || this.maxFrameRate == 0.0;
    }

    public final int component1() {
        return this.maxHeight;
    }

    public final double component2() {
        return this.maxFrameRate;
    }

    @NotNull
    public final VideoConstraints copy(int maxHeight, double maxFrameRate) {
        return new VideoConstraints(maxHeight, maxFrameRate);
    }

    public static /* synthetic */ VideoConstraints copy$default(VideoConstraints videoConstraints, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = videoConstraints.maxHeight;
        }
        if ((n2 & 2) != 0) {
            d = videoConstraints.maxFrameRate;
        }
        return videoConstraints.copy(n, d);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.maxHeight);
        result = result * 31 + Double.hashCode(this.maxFrameRate);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VideoConstraints)) {
            return false;
        }
        VideoConstraints videoConstraints = (VideoConstraints)other;
        if (this.maxHeight != videoConstraints.maxHeight) {
            return false;
        }
        return Double.compare(this.maxFrameRate, videoConstraints.maxFrameRate) == 0;
    }

    @JvmOverloads
    public VideoConstraints(int maxHeight) {
        this(maxHeight, 0.0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/cc/allocation/VideoConstraints$Companion;", "", "<init>", "()V", "UNLIMITED_HEIGHT", "", "UNLIMITED_FRAME_RATE", "", "NOTHING", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "getNOTHING", "()Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "UNLIMITED", "getUNLIMITED", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VideoConstraints getNOTHING() {
            return NOTHING;
        }

        @NotNull
        public final VideoConstraints getUNLIMITED() {
            return UNLIMITED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

