/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.Element;

abstract class AbstractElement<T>
implements Element<T> {
    private Element _parent;
    private Element _next;
    private Element _prev;

    AbstractElement(Element parent, Element prev) {
        this._parent = parent;
        this._prev = prev;
    }

    protected boolean isElementOfArray() {
        return this._parent instanceof ArrayElement && (!((ArrayElement)this.parent()).isDescribed() || this != this._parent.child());
    }

    @Override
    public Element next() {
        return this._next;
    }

    @Override
    public Element prev() {
        return this._prev;
    }

    @Override
    public Element parent() {
        return this._parent;
    }

    @Override
    public void setNext(Element elt) {
        this._next = elt;
    }

    @Override
    public void setPrev(Element elt) {
        this._prev = elt;
    }

    @Override
    public void setParent(Element elt) {
        this._parent = elt;
    }

    @Override
    public Element replaceWith(Element elt) {
        if (this._parent != null) {
            elt = this._parent.checkChild(elt);
        }
        elt.setPrev(this._prev);
        elt.setNext(this._next);
        elt.setParent(this._parent);
        if (this._prev != null) {
            this._prev.setNext(elt);
        }
        if (this._next != null) {
            this._next.setPrev(elt);
        }
        if (this._parent != null && this._parent.child() == this) {
            this._parent.setChild(elt);
        }
        return elt;
    }

    public String toString() {
        return String.format("%s[%h]{parent=%h, prev=%h, next=%h}", this.getClass().getSimpleName(), System.identityHashCode(this), System.identityHashCode(this._parent), System.identityHashCode(this._prev), System.identityHashCode(this._next));
    }

    abstract String startSymbol();

    abstract String stopSymbol();

    @Override
    public void render(StringBuilder sb) {
        if (this.canEnter()) {
            sb.append(this.startSymbol());
            boolean first = true;
            for (Element el = this.child(); el != null; el = el.next()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                el.render(sb);
            }
            sb.append(this.stopSymbol());
        } else {
            sb.append((Object)this.getDataType()).append(" ").append(this.getValue());
        }
    }
}

