/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.logstash.ingest.IngestAppend;
import org.logstash.ingest.IngestConvert;
import org.logstash.ingest.IngestDate;
import org.logstash.ingest.IngestGeoIp;
import org.logstash.ingest.IngestGrok;
import org.logstash.ingest.IngestGsub;
import org.logstash.ingest.IngestJson;
import org.logstash.ingest.IngestLowercase;
import org.logstash.ingest.IngestPipeline;
import org.logstash.ingest.IngestRename;
import org.logstash.ingest.IngestSet;

final class JsUtil {
    private static final String[] SCRIPTS = new String[]{"shared", "date", "grok", "geoip", "gsub", "pipeline", "convert", "append", "json", "rename", "lowercase", "set"};

    private JsUtil() {
    }

    public static ScriptEngine engine() {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            for (String file : SCRIPTS) {
                JsUtil.add(engine, String.format("/ingest-%s.js", file));
            }
        }
        catch (IOException | ScriptException ex) {
            throw new IllegalStateException(ex);
        }
        return engine;
    }

    public static void convert(String[] args, String jsFunc) throws ScriptException, NoSuchMethodException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec input = parser.accepts("input", "Input JSON file location URI. Only supports 'file://' as URI schema.").withRequiredArg().ofType(URI.class).required().forHelp();
        AbstractOptionSpec output = parser.accepts("output", "Output Logstash DSL file location URI. Only supports 'file://' as URI schema.").withRequiredArg().ofType(URI.class).required().forHelp();
        AbstractOptionSpec appendStdio = parser.accepts("append-stdio", "Flag to append stdin and stdout as outputs instead of the default ES output.").forHelp();
        try {
            OptionSet options;
            try {
                options = parser.parse(args);
            }
            catch (OptionException ex) {
                parser.printHelpOn(System.out);
                throw ex;
            }
            switch (jsFunc) {
                case "ingest_append_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestAppend.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_convert_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestConvert.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_to_logstash_date": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestDate.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_to_logstash_geoip": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestGeoIp.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_to_logstash_grok": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestGrok.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_to_logstash_gsub": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestGsub.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_json_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestJson.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_lowercase_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestLowercase.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_rename_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestRename.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_set_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestSet.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                case "ingest_pipeline_to_logstash": {
                    Files.write(Paths.get((URI)options.valueOf(output)), IngestPipeline.toLogstash(JsUtil.input((URI)options.valueOf(input)), options.has(appendStdio)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can't recognize " + jsFunc + " processor");
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String input(URI uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new String(Files.readAllBytes(Paths.get(uri)), StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("--input must be of schema file://");
    }

    private static void add(ScriptEngine engine, String file) throws IOException, ScriptException {
        try (InputStreamReader reader = new InputStreamReader(JsUtil.class.getResourceAsStream(file));){
            engine.eval(reader);
        }
    }

    static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }
}

