/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Provider;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(service={ModuleTypeRegistry.class}, immediate=true)
public class ModuleTypeRegistryImpl
extends AbstractRegistry<ModuleType, String, ModuleTypeProvider>
implements ModuleTypeRegistry {
    public ModuleTypeRegistryImpl() {
        super(ModuleTypeProvider.class);
    }

    protected void addProvider(Provider<ModuleType> provider) {
        if (provider instanceof ModuleTypeProvider) {
            super.addProvider(provider);
        }
    }

    public @Nullable ModuleType get(String typeUID) {
        return this.get(typeUID, null);
    }

    @Override
    public <T extends ModuleType> @Nullable T get(String moduleTypeUID, @Nullable Locale locale) {
        Map.Entry mType = this.getValueAndProvider(moduleTypeUID);
        if (mType == null) {
            return null;
        }
        ModuleType mt = locale == null ? (ModuleType)mType.getValue() : ((ModuleTypeProvider)mType.getKey()).getModuleType(((ModuleType)mType.getValue()).getUID(), locale);
        return (T)this.createCopy(mt);
    }

    @Override
    public <T extends ModuleType> Collection<T> getByTag(@Nullable String moduleTypeTag) {
        return this.getByTag(moduleTypeTag, null);
    }

    @Override
    public <T extends ModuleType> Collection<T> getByTag(@Nullable String moduleTypeTag, @Nullable Locale locale) {
        ArrayList result = new ArrayList(20);
        this.forEach((provider, mType) -> {
            ModuleType mtCopy;
            ModuleType mt;
            ModuleType moduleType = mt = locale == null ? mType : ((ModuleTypeProvider)provider).getModuleType(mType.getUID(), locale);
            if (mt != null && (moduleTypeTag == null || mt.getTags().contains(moduleTypeTag)) && (mtCopy = this.createCopy(mt)) != null) {
                result.add(mtCopy);
            }
        });
        return result;
    }

    @Override
    public <T extends ModuleType> Collection<T> getByTags(String ... tags) {
        return this.getByTags((Locale)null, tags);
    }

    @Override
    public <T extends ModuleType> Collection<T> getByTags(@Nullable Locale locale, String ... tags) {
        HashSet<String> tagSet = new HashSet<String>(Arrays.asList(tags));
        ArrayList result = new ArrayList(20);
        this.forEach((provider, mType) -> {
            ModuleType mtCopy;
            ModuleType mt;
            ModuleType moduleType = mt = locale == null ? mType : ((ModuleTypeProvider)provider).getModuleType(mType.getUID(), locale);
            if (mt != null && mt.getTags().containsAll(tagSet) && (mtCopy = this.createCopy(mt)) != null) {
                result.add(mtCopy);
            }
        });
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<TriggerType> getTriggers(@Nullable Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<TriggerType> triggerTypes = new ArrayList<TriggerType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof TriggerType)) continue;
            TriggerType cfr_ignored_0 = (TriggerType)moduleType;
            TriggerType cfr_ignored_1 = (TriggerType)moduleType;
            triggerTypes.add((TriggerType)type);
        }
        return triggerTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<TriggerType> getTriggers(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<TriggerType> triggerTypes = new ArrayList<TriggerType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof TriggerType)) continue;
            TriggerType cfr_ignored_0 = (TriggerType)moduleType;
            TriggerType cfr_ignored_1 = (TriggerType)moduleType;
            triggerTypes.add((TriggerType)type);
        }
        return triggerTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<ConditionType> getConditions(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<ConditionType> conditionTypes = new ArrayList<ConditionType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof ConditionType)) continue;
            ConditionType cfr_ignored_0 = (ConditionType)moduleType;
            ConditionType cfr_ignored_1 = (ConditionType)moduleType;
            conditionTypes.add((ConditionType)type);
        }
        return conditionTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<ConditionType> getConditions(@Nullable Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<ConditionType> conditionTypes = new ArrayList<ConditionType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof ConditionType)) continue;
            ConditionType cfr_ignored_0 = (ConditionType)moduleType;
            ConditionType cfr_ignored_1 = (ConditionType)moduleType;
            conditionTypes.add((ConditionType)type);
        }
        return conditionTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<ActionType> getActions(String ... tags) {
        Collection moduleTypes = this.getByTags(tags);
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof ActionType)) continue;
            ActionType cfr_ignored_0 = (ActionType)moduleType;
            ActionType cfr_ignored_1 = (ActionType)moduleType;
            actionTypes.add((ActionType)type);
        }
        return actionTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<ActionType> getActions(@Nullable Locale locale, String ... tags) {
        Collection moduleTypes = this.getByTags(locale, tags);
        ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
        for (ModuleType mt : moduleTypes) {
            void type;
            ModuleType moduleType = mt;
            if (!(moduleType instanceof ActionType)) continue;
            ActionType cfr_ignored_0 = (ActionType)moduleType;
            ActionType cfr_ignored_1 = (ActionType)moduleType;
            actionTypes.add((ActionType)type);
        }
        return actionTypes;
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable ModuleType createCopy(@Nullable ModuleType mType) {
        ModuleType result;
        if (mType == null) {
            return null;
        }
        ModuleType moduleType = mType;
        if (moduleType instanceof CompositeTriggerType) {
            void m;
            CompositeTriggerType compositeTriggerType = (CompositeTriggerType)moduleType;
            CompositeTriggerType cfr_ignored_0 = (CompositeTriggerType)moduleType;
            result = new CompositeTriggerType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs(), new ArrayList<Trigger>(m.getChildren()));
        } else {
            ModuleType moduleType2 = mType;
            if (moduleType2 instanceof TriggerType) {
                void m;
                TriggerType triggerType = (TriggerType)moduleType2;
                TriggerType cfr_ignored_1 = (TriggerType)moduleType2;
                result = new TriggerType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs());
            } else {
                ModuleType moduleType3 = mType;
                if (moduleType3 instanceof CompositeConditionType) {
                    void m;
                    CompositeConditionType compositeConditionType = (CompositeConditionType)moduleType3;
                    CompositeConditionType cfr_ignored_2 = (CompositeConditionType)moduleType3;
                    result = new CompositeConditionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), new ArrayList<Condition>(m.getChildren()));
                } else {
                    ModuleType moduleType4 = mType;
                    if (moduleType4 instanceof ConditionType) {
                        void m;
                        ConditionType conditionType = (ConditionType)moduleType4;
                        ConditionType cfr_ignored_3 = (ConditionType)moduleType4;
                        result = new ConditionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs());
                    } else {
                        ModuleType moduleType5 = mType;
                        if (moduleType5 instanceof CompositeActionType) {
                            void m;
                            CompositeActionType compositeActionType = (CompositeActionType)moduleType5;
                            CompositeActionType cfr_ignored_4 = (CompositeActionType)moduleType5;
                            result = new CompositeActionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs(), new ArrayList<Action>(m.getChildren()));
                        } else {
                            ModuleType moduleType6 = mType;
                            if (moduleType6 instanceof ActionType) {
                                void m;
                                ActionType actionType = (ActionType)moduleType6;
                                ActionType cfr_ignored_5 = (ActionType)moduleType6;
                                result = new ActionType(mType.getUID(), mType.getConfigurationDescriptions(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs());
                            } else {
                                throw new IllegalArgumentException("Invalid template type:" + String.valueOf(mType));
                            }
                        }
                    }
                }
            }
        }
        return result;
    }
}

