/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.session;

import com.intellij.completion.ml.personalization.session.CompletionQueryTracker;
import com.intellij.completion.ml.personalization.session.QueriesDuration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/intellij/completion/ml/personalization/session/CompletionQueryTrackerImpl;", "Lcom/intellij/completion/ml/personalization/session/CompletionQueryTracker;", "sessionStartedTimestamp", "", "<init>", "(J)V", "prefixShiftCount", "", "currentQuery", "", "uniqueQueries", "", "queriesCount", "currentQueryFrequency", "getCurrentQueryFrequency", "durations", "Lcom/intellij/completion/ml/personalization/session/QueriesDuration;", "getDurations", "()Lcom/intellij/completion/ml/personalization/session/QueriesDuration;", "getUniqueQueriesCount", "getTotalQueriesCount", "afterAppend", "", "c", "", "afterTruncate", "updateQuery", "newQuery", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nCompletionQueryTrackerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionQueryTrackerImpl.kt\ncom/intellij/completion/ml/personalization/session/CompletionQueryTrackerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class CompletionQueryTrackerImpl
implements CompletionQueryTracker {
    private int prefixShiftCount;
    @NotNull
    private String currentQuery = "";
    @NotNull
    private Map<Integer, Map<String, Integer>> uniqueQueries = new LinkedHashMap();
    private int queriesCount;
    private int currentQueryFrequency;
    @NotNull
    private final QueriesDuration durations;

    public CompletionQueryTrackerImpl(long sessionStartedTimestamp) {
        this.durations = new QueriesDuration(sessionStartedTimestamp);
        this.updateQuery("");
    }

    @Override
    public int getCurrentQueryFrequency() {
        return this.currentQueryFrequency;
    }

    @Override
    @NotNull
    public QueriesDuration getDurations() {
        return this.durations;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getUniqueQueriesCount() {
        Iterable iterable = this.uniqueQueries.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Map map = (Map)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        return n;
    }

    @Override
    public int getTotalQueriesCount() {
        return this.queriesCount;
    }

    public final void afterAppend(char c) {
        this.updateQuery(this.currentQuery + c);
    }

    public final void afterTruncate() {
        String query = this.currentQuery;
        if (((CharSequence)this.currentQuery).length() == 0) {
            ++this.prefixShiftCount;
        } else {
            query = StringsKt.dropLast((String)this.currentQuery, (int)1);
        }
        this.updateQuery(query);
    }

    private final void updateQuery(String newQuery) {
        Map map = this.uniqueQueries.computeIfAbsent(this.prefixShiftCount, arg_0 -> CompletionQueryTrackerImpl.updateQuery$lambda$2(CompletionQueryTrackerImpl::updateQuery$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map prefixMap = map;
        this.currentQueryFrequency = ((Number)prefixMap.getOrDefault(newQuery, 0)).intValue() + 1;
        prefixMap.put(newQuery, this.currentQueryFrequency);
        ++this.queriesCount;
        this.currentQuery = newQuery;
        this.getDurations().fireQueryChanged();
    }

    private static final Map updateQuery$lambda$1(Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map updateQuery$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }
}

