/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.settings;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import com.intellij.searchEverywhereMl.settings.SearchEverywhereMlSettingsStorage;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/searchEverywhereMl/settings/SearchEverywhereMlSettings;", "", "<init>", "()V", "isSortingByMlEnabledInAnyTab", "", "isSortingByMlEnabled", "tab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTabWithMlRanking;", "isSortingByMlEnabledByDefault", "getSettingsKey", "", "updateExperimentStateIfAllowed", "mlRankingEnabledByExperiment", "disableExperiment", "", "intellij.searchEverywhereMl"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMlSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMlSettings.kt\ncom/intellij/searchEverywhereMl/settings/SearchEverywhereMlSettings\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,54:1\n12574#2,2:55\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMlSettings.kt\ncom/intellij/searchEverywhereMl/settings/SearchEverywhereMlSettings\n*L\n10#1:55,2\n*E\n"})
public final class SearchEverywhereMlSettings {
    public final boolean isSortingByMlEnabledInAnyTab() {
        boolean bl;
        block1: {
            SearchEverywhereTabWithMlRanking[] $this$any$iv = SearchEverywhereTabWithMlRanking.values();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                SearchEverywhereTabWithMlRanking element$iv;
                SearchEverywhereTabWithMlRanking it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!this.isSortingByMlEnabled(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean isSortingByMlEnabled(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (tab == SearchEverywhereTabWithMlRanking.ALL) {
            return SearchEverywhereMlSettingsStorage.Companion.getInstance().getEnableMlRankingInAll();
        }
        if (tab == SearchEverywhereTabWithMlRanking.SYMBOLS) {
            return false;
        }
        String settingsKey = this.getSettingsKey(tab);
        return AdvancedSettings.Companion.getBoolean(settingsKey);
    }

    public final boolean isSortingByMlEnabledByDefault(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (tab == SearchEverywhereTabWithMlRanking.ALL) {
            return SearchEverywhereMlSettingsStorage.Companion.getInstance().getEnabledMlRankingInAllDefaultState();
        }
        if (tab == SearchEverywhereTabWithMlRanking.SYMBOLS) {
            return false;
        }
        String settingsKey = this.getSettingsKey(tab);
        return AdvancedSettings.Companion.getDefaultBoolean(settingsKey);
    }

    private final String getSettingsKey(SearchEverywhereTabWithMlRanking tab) {
        String string = tab.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "searcheverywhere.ml.sort." + string;
    }

    public final boolean updateExperimentStateIfAllowed(@NotNull SearchEverywhereTabWithMlRanking tab, boolean mlRankingEnabledByExperiment) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (tab == SearchEverywhereTabWithMlRanking.ALL) {
            return SearchEverywhereMlSettingsStorage.Companion.getInstance().updateExperimentStateInAllTabIfAllowed(mlRankingEnabledByExperiment);
        }
        return true;
    }

    public final void disableExperiment(@NotNull SearchEverywhereTabWithMlRanking tab) {
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        if (tab == SearchEverywhereTabWithMlRanking.ALL) {
            SearchEverywhereMlSettingsStorage.Companion.getInstance().disableExperimentInAllTab();
        }
    }
}

