/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0000\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\b\u0010\u000e\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_UI_RESPONSE_TIMEOUT", "", "navBarItemBackground", "Ljava/awt/Color;", "selected", "", "focused", "navBarItemForeground", "inactive", "defaultNavBarItemForeground", "navBarItemFont", "Ljava/awt/Font;", "navBarItemInsets", "Ljava/awt/Insets;", "navBarPopupItemInsets", "navBarItemPadding", "floating", "navBarPopupOffset", "", "firstItem", "intellij.platform.navbar.frontend"})
public final class UiKt {
    public static final long DEFAULT_UI_RESPONSE_TIMEOUT = 300L;

    @NotNull
    public static final Color navBarItemBackground(boolean selected, boolean focused) {
        Color color;
        if (selected && focused) {
            Color color2 = UIUtil.getListSelectionBackground((boolean)true);
            Intrinsics.checkNotNull((Object)color2);
            color = color2;
        } else {
            Color color3 = UIUtil.getListBackground();
            Intrinsics.checkNotNull((Object)color3);
            color = color3;
        }
        return color;
    }

    @Nullable
    public static final Color navBarItemForeground(boolean selected, boolean focused, boolean inactive) {
        return StartupUiUtil.isUnderDarcula() ? (inactive ? (Color)Gray._140 : UiKt.defaultNavBarItemForeground(selected, focused, false)) : UiKt.defaultNavBarItemForeground(selected, focused, inactive);
    }

    @Nullable
    public static final Color defaultNavBarItemForeground(boolean selected, boolean focused, boolean inactive) {
        return selected && focused ? NamedColorUtil.getListSelectionForeground((boolean)true) : (inactive ? NamedColorUtil.getInactiveTextColor() : null);
    }

    @Nullable
    public static final Font navBarItemFont() {
        if (!ExperimentalUI.Companion.isNewUI() && UISettings.Companion.getInstance().getUseSmallLabelsOnTabs()) {
            return RelativeFont.SMALL.derive(StartupUiUtil.getLabelFont());
        }
        return JBUI.CurrentTheme.StatusBar.font();
    }

    @NotNull
    public static final Insets navBarItemInsets() {
        Insets insets;
        if (ExperimentalUI.Companion.isNewUI()) {
            JBInsets jBInsets = JBUI.insets((String)"StatusBar.Breadcrumbs.itemBackgroundInsets", (JBInsets)(ExperimentalUI.Companion.isNewUI() ? JBUI.insets((int)2, (int)4) : JBUI.insets((int)1)));
            Intrinsics.checkNotNull((Object)jBInsets);
            insets = (Insets)jBInsets;
        } else {
            JBInsets jBInsets = JBInsets.emptyInsets();
            Intrinsics.checkNotNull((Object)jBInsets);
            insets = (Insets)jBInsets;
        }
        return insets;
    }

    @NotNull
    public static final Insets navBarPopupItemInsets() {
        JBInsets jBInsets = JBInsets.create((int)1, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(...)");
        return (Insets)jBInsets;
    }

    @NotNull
    public static final Insets navBarItemPadding(boolean floating) {
        if (!ExperimentalUI.Companion.isNewUI()) {
            JBInsets jBInsets = JBUI.insets((int)3);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            return (Insets)jBInsets;
        }
        if (floating) {
            JBInsets jBInsets = JBUI.insets((String)"StatusBar.Breadcrumbs.floatingItemInsets", (JBInsets)JBUI.insets((int)1));
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            return (Insets)jBInsets;
        }
        JBInsets jBInsets = JBUI.CurrentTheme.StatusBar.Breadcrumbs.itemInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"itemInsets(...)");
        return (Insets)jBInsets;
    }

    public static final int navBarPopupOffset(boolean firstItem) {
        return firstItem ? 0 : JBUIScale.scale((int)5);
    }
}

