/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.ShortCharAssociativeContainer;
import com.carrotsearch.hppc.ShortCharHashMap;
import com.carrotsearch.hppc.ShortCharMap;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.comparators.ShortCharComparator;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.ShortCharCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.ShortCharPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.ShortCharProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortCharHashMap
implements ShortCharMap {
    public final ShortCharHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortCharHashMap(ShortCharHashMap delegate2, ShortComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortCharHashMap(ShortCharHashMap delegate2, ShortCharComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortCharComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final char[] values;
            {
                this.keys = SortedIterationShortCharHashMap.this.delegate.keys;
                this.values = SortedIterationShortCharHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortCharCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortCharPredicate predicate) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortCharProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortCharPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        char[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public CharContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public char get(short key2) {
        return this.delegate.get(key2);
    }

    @Override
    public char getOrDefault(short key2, char defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public char put(short key2, char value) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortCharAssociativeContainer container) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortCharCursor> iterable) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public char putOrAdd(short key2, char putValue, char incrementValue) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public char addTo(short key2, char additionValue) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public char remove(short key2) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public char indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public char indexReplace(int index, char newValue) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key2, char value) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public char indexRemove(int index) {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortCharHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortCharCursor> {
        private final ShortCharCursor cursor = new ShortCharCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortCharCursor fetch() {
            if (this.index < SortedIterationShortCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortCharHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortCharHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCharCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortCharHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortCharHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final SortedIterationShortCharHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value) {
            for (ShortCharCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortCharHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationShortCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortCharHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortCharHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortCharHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortCharHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

