/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.StringItem;
import ca.sqlpower.swingui.querypen.CleanupPNode;
import ca.sqlpower.swingui.querypen.EditStyledTextListener;
import ca.sqlpower.swingui.querypen.EditablePStyledText;
import ca.sqlpower.swingui.querypen.EditablePStyledTextWithOptionBox;
import ca.sqlpower.swingui.querypen.QueryPen;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ConstantPNode
extends PNode
implements CleanupPNode {
    private static final Logger logger = Logger.getLogger(ConstantPNode.class);
    private static final int SPACING_SIZE = 8;
    private static final String LONG_EMPTY_STRING = "        ";
    private final Item item;
    private JCheckBox selectionCheckbox;
    private EditablePStyledText constantText;
    private EditablePStyledText aliasText;
    private EditablePStyledTextWithOptionBox whereText;
    private final List<PropertyChangeListener> changeListeners;
    private EditStyledTextListener removeItemListener = new EditStyledTextListener(){
        private String oldText;

        @Override
        public void editingStopping() {
            if (ConstantPNode.this.constantText.getEditorPane().getText().length() <= 0) {
                ConstantPNode.this.removeItem();
            } else if (ConstantPNode.this.item instanceof StringItem) {
                ((StringItem)ConstantPNode.this.item).setName(ConstantPNode.this.constantText.getEditorPane().getText());
            }
            for (PropertyChangeListener listener : ConstantPNode.this.changeListeners) {
                listener.propertyChange(new PropertyChangeEvent((Object)ConstantPNode.this.constantText, "ITEM", this.oldText, ConstantPNode.this.constantText.getEditorPane().getText().trim()));
            }
        }

        @Override
        public void editingStarting() {
            this.oldText = ConstantPNode.this.constantText.getEditorPane().getText();
        }
    };
    private final PropertyChangeListener itemChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selected")) {
                ConstantPNode.this.selectionCheckbox.setSelected(ConstantPNode.this.item.isSelected());
            } else if (evt.getPropertyName().equals("alias")) {
                ConstantPNode.this.aliasText.getEditorPane().setText(ConstantPNode.this.item.getAlias());
                ConstantPNode.this.aliasText.syncWithDocument();
            } else if (evt.getPropertyName().equals("where")) {
                ConstantPNode.this.whereText.getEditorPane().setText(ConstantPNode.this.item.getWhere());
                ConstantPNode.this.whereText.syncWithDocument();
            } else if (evt.getPropertyName().equals("ITEM")) {
                ConstantPNode.this.constantText.getEditorPane().setText(evt.getNewValue().toString());
                if (ConstantPNode.this.constantText.getEditorPane().getText().length() <= 0) {
                    ConstantPNode.this.removeItem();
                } else {
                    logger.debug((Object)"Model Name changed, updating view");
                    ConstantPNode.this.constantText.syncWithDocument();
                }
            }
            for (PropertyChangeListener l : ConstantPNode.this.changeListeners) {
                l.propertyChange(evt);
            }
        }
    };
    private final QueryPen queryPen;

    private void removeItem() {
        logger.debug((Object)"removing item");
        for (PropertyChangeListener l : this.changeListeners) {
            l.propertyChange(new PropertyChangeEvent(this, "ITEM_REMOVED", this.item, null));
        }
        this.item.getContainer().removeItem(this.item);
    }

    public ConstantPNode(Item source, QueryPen mouseStates, PCanvas canvas) {
        this(source, mouseStates, canvas, null);
    }

    public ConstantPNode(Item source, QueryPen mouseStates, PCanvas canvas, SPVariableHelper variables) {
        this.item = source;
        this.queryPen = mouseStates;
        this.item.addPropertyChangeListener(this.itemChangeListener);
        this.changeListeners = new ArrayList<PropertyChangeListener>();
        this.selectionCheckbox = new JCheckBox();
        this.selectionCheckbox.setOpaque(false);
        this.selectionCheckbox.setSelected(this.item.isSelected());
        PSwing swingCheckbox = new PSwing((JComponent)this.selectionCheckbox);
        this.addChild((PNode)swingCheckbox);
        this.selectionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConstantPNode.this.selectionCheckbox.isSelected()) {
                    ConstantPNode.this.queryPen.getModel().selectItem(ConstantPNode.this.item);
                } else {
                    ConstantPNode.this.queryPen.getModel().unselectItem(ConstantPNode.this.item);
                }
            }
        });
        this.constantText = new EditablePStyledText(source.getName(), mouseStates, canvas);
        this.constantText.addEditStyledTextListener(this.removeItemListener);
        double yPos = (swingCheckbox.getFullBounds().getHeight() - this.constantText.getHeight()) / 2.0;
        this.constantText.translate(swingCheckbox.getFullBounds().getWidth() + 8.0, yPos);
        this.addChild((PNode)this.constantText);
        this.aliasText = this.item.getAlias().trim().length() > 0 ? new EditablePStyledText(this.item.getAlias(), mouseStates, canvas, LONG_EMPTY_STRING.length()) : new EditablePStyledText(LONG_EMPTY_STRING, mouseStates, canvas, LONG_EMPTY_STRING.length());
        this.aliasText.addEditStyledTextListener(new EditStyledTextListener(){

            @Override
            public void editingStopping() {
                ConstantPNode.this.item.setAlias(ConstantPNode.this.aliasText.getEditorPane().getText().trim());
            }

            @Override
            public void editingStarting() {
            }
        });
        this.aliasText.translate(swingCheckbox.getFullBounds().getWidth() + this.constantText.getWidth() + 16.0, yPos);
        this.addChild((PNode)this.aliasText);
        this.whereText = this.item.getWhere().trim().length() > 0 ? new EditablePStyledTextWithOptionBox(this.item.getWhere(), mouseStates, canvas, LONG_EMPTY_STRING.length(), variables) : new EditablePStyledTextWithOptionBox(LONG_EMPTY_STRING, mouseStates, canvas, LONG_EMPTY_STRING.length(), variables);
        this.whereText.addEditStyledTextListener(new EditStyledTextListener(){

            @Override
            public void editingStopping() {
                ConstantPNode.this.item.setWhere(ConstantPNode.this.whereText.getEditorPane().getText().trim());
            }

            @Override
            public void editingStarting() {
            }
        });
        this.whereText.translate(swingCheckbox.getFullBounds().getWidth() + this.constantText.getWidth() + this.aliasText.getWidth() + 24.0, yPos);
        this.addChild((PNode)this.whereText);
    }

    public Item getItem() {
        return this.item;
    }

    public String getAlias() {
        return this.aliasText.getEditorPane().getText().trim();
    }

    public String getWhereText() {
        return this.whereText.getEditorPane().getText().trim();
    }

    public double getAliasOffset() {
        return (double)this.selectionCheckbox.getWidth() + this.constantText.getWidth() + 16.0;
    }

    public double getWhereOffset() {
        double offset = this.aliasText.getFullBounds().getX() + this.aliasText.getWidth() + 8.0;
        logger.debug((Object)("Returning where offset of " + offset + " where position is currently " + this.whereText.getFullBounds().getX()));
        return offset;
    }

    public void setAliasXPosition(double position) {
        this.aliasText.translate(position - this.aliasText.getFullBounds().getX(), 0.0);
        this.whereText.translate(position - this.aliasText.getFullBounds().getX(), 0.0);
    }

    public void setWhereXPosition(double position) {
        this.whereText.translate(position - this.whereText.getFullBounds().getX(), 0.0);
    }

    public void addChangeListener(PropertyChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(PropertyChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void setSelected(boolean selected) {
        this.selectionCheckbox.setSelected(selected);
        if (selected) {
            this.queryPen.getModel().selectItem(this.item);
        } else {
            this.queryPen.getModel().unselectItem(this.item);
        }
    }

    public boolean isInSelect() {
        return this.selectionCheckbox.isSelected();
    }

    @Override
    public void cleanup() {
        this.item.removePropertyChangeListener(this.itemChangeListener);
    }

    public Item getModel() {
        return this.item;
    }
}

