/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Security;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class C14N11Test
extends TestCase {
    private SignatureValidator validator;
    private File dir;
    private KeySelector sks;
    private static String[] vendors = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};

    public C14N11Test(String string) throws Exception {
        super(string);
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string3 + string2 + "data" + string2 + "org" + string2 + "w3c" + string2 + "www" + string2 + "interop" + string2 + "xmldsig" + string2 + "c14n11");
        this.validator = new SignatureValidator(this.dir);
        this.sks = new KeySelectors.SecretKeySelector("secret".getBytes("ASCII"));
    }

    public void test_xmlid_1() throws Exception {
        this.test_c14n11("xmlid-1");
    }

    public void test_xmlid_2() throws Exception {
        this.test_c14n11("xmlid-2");
    }

    public void test_xmlspace_1() throws Exception {
        this.test_c14n11("xmlspace-1");
    }

    public void test_xmlspace_2() throws Exception {
        this.test_c14n11("xmlspace-2");
    }

    public void test_xmlspace_3() throws Exception {
        this.test_c14n11("xmlspace-3");
    }

    public void test_xmlspace_4() throws Exception {
        this.test_c14n11("xmlspace-4");
    }

    public void test_xmllang_1() throws Exception {
        this.test_c14n11("xmllang-1");
    }

    public void test_xmllang_2() throws Exception {
        this.test_c14n11("xmllang-2");
    }

    public void test_xmllang_3() throws Exception {
        this.test_c14n11("xmllang-3");
    }

    public void test_xmllang_4() throws Exception {
        this.test_c14n11("xmllang-4");
    }

    public void test_xmlbase_prop_1() throws Exception {
        this.test_c14n11("xmlbase-prop-1");
    }

    public void test_xmlbase_prop_2() throws Exception {
        this.test_c14n11("xmlbase-prop-2");
    }

    public void test_xmlbase_prop_3() throws Exception {
        this.test_c14n11("xmlbase-prop-3");
    }

    public void test_xmlbase_prop_4() throws Exception {
        this.test_c14n11("xmlbase-prop-4");
    }

    public void test_xmlbase_prop_5() throws Exception {
        this.test_c14n11("xmlbase-prop-5");
    }

    public void test_xmlbase_prop_6() throws Exception {
        this.test_c14n11("xmlbase-prop-6");
    }

    public void test_xmlbase_prop_7() throws Exception {
        this.test_c14n11("xmlbase-prop-7");
    }

    public void test_xmlbase_c14n11spec_102() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};
        this.test_c14n11("xmlbase-c14n11spec-102", stringArray);
    }

    public void test_xmlbase_c14n11spec2_102() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN"};
        this.test_c14n11("xmlbase-c14n11spec2-102", stringArray);
    }

    public void test_xmlbase_c14n11spec3_103() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};
        this.test_c14n11("xmlbase-c14n11spec3-103", stringArray);
    }

    private void test_c14n11(String string) throws Exception {
        for (int i = 0; i < vendors.length; ++i) {
            String string2 = string + "-" + vendors[i] + ".xml";
            boolean bl = this.validator.validate(string2, this.sks);
            C14N11Test.assertTrue((String)(string2 + " failed core validation"), (boolean)bl);
        }
    }

    private void test_c14n11(String string, String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "-" + stringArray[i] + ".xml";
            boolean bl = this.validator.validate(string2, this.sks);
            C14N11Test.assertTrue((String)(string2 + " failed core validation"), (boolean)bl);
        }
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

