/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceSerializer;
import de.rub.nds.tlsattacker.core.workflow.action.ActivateEncryptionAction;
import de.rub.nds.tlsattacker.core.workflow.action.ApplyBufferedMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedGenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeCipherSuiteAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeClientRandomAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeCompressionAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeDefaultPreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangePreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeProtocolVersionAction;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeServerRandomAction;
import de.rub.nds.tlsattacker.core.workflow.action.ClearBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyBufferedMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyBufferedRecordsAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyClientRandomAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyContextFieldAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyPreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyServerRandomAction;
import de.rub.nds.tlsattacker.core.workflow.action.DeactivateEncryptionAction;
import de.rub.nds.tlsattacker.core.workflow.action.DeepCopyBufferedMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.DeepCopyBufferedRecordsAction;
import de.rub.nds.tlsattacker.core.workflow.action.DeepCopyBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.EsniKeyDnsRequestAction;
import de.rub.nds.tlsattacker.core.workflow.action.FindReceivedProtocolMessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.FlushSessionCacheAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardMessagesWithPrepareAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardRecordsAction;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.MultiReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopAndSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopAndSendMessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopAndSendRecordAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedMessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedRecordAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintLastHandledApplicationDataAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintProposedExtensionsAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintSecretsAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChCiphersAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChExtensionsAction;
import de.rub.nds.tlsattacker.core.workflow.action.RenegotiationAction;
import de.rub.nds.tlsattacker.core.workflow.action.ResetConnectionAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerCertificateAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendRaccoonCkeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.WaitAction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WorkflowTrace
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElements(value={@XmlElement(type=AliasedConnection.class, name="AliasedConnection"), @XmlElement(type=InboundConnection.class, name="InboundConnection"), @XmlElement(type=OutboundConnection.class, name="OutboundConnection")})
    private List<AliasedConnection> connections = new ArrayList<AliasedConnection>();
    @HoldsModifiableVariable
    @XmlElements(value={@XmlElement(type=ActivateEncryptionAction.class, name="ActivateEncryption"), @XmlElement(type=ApplyBufferedMessagesAction.class, name="ApplyBufferedMessages"), @XmlElement(type=BufferedGenericReceiveAction.class, name="BufferedGenericReceive"), @XmlElement(type=BufferedSendAction.class, name="BufferedSend"), @XmlElement(type=ChangeCipherSuiteAction.class, name="ChangeCipherSuite"), @XmlElement(type=ChangeClientRandomAction.class, name="ChangeClientRandom"), @XmlElement(type=ChangeCompressionAction.class, name="ChangeCompression"), @XmlElement(type=ChangeMasterSecretAction.class, name="ChangeMasterSecret"), @XmlElement(type=ChangePreMasterSecretAction.class, name="ChangePreMasterSecret"), @XmlElement(type=ChangeDefaultPreMasterSecretAction.class, name="ChangeDefaultPreMasterSecret"), @XmlElement(type=ChangeProtocolVersionAction.class, name="ChangeProtocolVersion"), @XmlElement(type=ChangeServerRandomAction.class, name="ChangeServerRandom"), @XmlElement(type=ClearBuffersAction.class, name="ClearBuffers"), @XmlElement(type=ConnectionBoundAction.class, name="ConnectionBound"), @XmlElement(type=CopyBufferedMessagesAction.class, name="CopyBufferedMessages"), @XmlElement(type=CopyBufferedRecordsAction.class, name="CopyBufferedRecords"), @XmlElement(type=CopyBuffersAction.class, name="CopyBuffers"), @XmlElement(type=CopyClientRandomAction.class, name="CopyClientRandom"), @XmlElement(type=CopyContextFieldAction.class, name="CopyContextField"), @XmlElement(type=CopyPreMasterSecretAction.class, name="CopyPreMasterSecret"), @XmlElement(type=CopyServerRandomAction.class, name="CopyServerRandom"), @XmlElement(type=DeactivateEncryptionAction.class, name="DeactivateEncryption"), @XmlElement(type=DeepCopyBufferedMessagesAction.class, name="DeepCopyBufferedMessages"), @XmlElement(type=DeepCopyBufferedRecordsAction.class, name="DeepCopyBufferedRecords"), @XmlElement(type=DeepCopyBuffersAction.class, name="DeepCopyBuffers"), @XmlElement(type=EsniKeyDnsRequestAction.class, name="EsniKeyDnsRequest"), @XmlElement(type=FindReceivedProtocolMessageAction.class, name="FindReceivedProtocolMessage"), @XmlElement(type=ForwardMessagesAction.class, name="ForwardMessages"), @XmlElement(type=ForwardMessagesWithPrepareAction.class, name="ForwardMessagesWithPrepare"), @XmlElement(type=ForwardRecordsAction.class, name="ForwardRecords"), @XmlElement(type=GenericReceiveAction.class, name="GenericReceive"), @XmlElement(type=ReceiveTillAction.class, name="ReceiveTill"), @XmlElement(type=MultiReceiveAction.class, name="MultiReceive"), @XmlElement(type=PopAndSendAction.class, name="PopAndSend"), @XmlElement(type=PopAndSendMessageAction.class, name="PopAndSendMessage"), @XmlElement(type=PopAndSendRecordAction.class, name="PopAndSendRecord"), @XmlElement(type=PopBuffersAction.class, name="PopBuffers"), @XmlElement(type=PopBufferedMessageAction.class, name="PopBufferedMessage"), @XmlElement(type=PopBufferedRecordAction.class, name="PopBufferedRecord"), @XmlElement(type=PrintLastHandledApplicationDataAction.class, name="PrintLastHandledApplicationData"), @XmlElement(type=PrintProposedExtensionsAction.class, name="PrintProposedExtensions"), @XmlElement(type=PrintSecretsAction.class, name="PrintSecrets"), @XmlElement(type=ReceiveAction.class, name="Receive"), @XmlElement(type=RemBufferedChCiphersAction.class, name="RemBufferedChCiphers"), @XmlElement(type=RemBufferedChExtensionsAction.class, name="RemBufferedChExtensions"), @XmlElement(type=RenegotiationAction.class, name="Renegotiation"), @XmlElement(type=ResetConnectionAction.class, name="ResetConnection"), @XmlElement(type=SendAction.class, name="Send"), @XmlElement(type=SendDynamicClientKeyExchangeAction.class, name="SendDynamicClientKeyExchange"), @XmlElement(type=SendDynamicServerKeyExchangeAction.class, name="SendDynamicServerKeyExchange"), @XmlElement(type=SendDynamicServerCertificateAction.class, name="SendDynamicCertificate"), @XmlElement(type=SendRaccoonCkeAction.class, name="SendRaccoonCke"), @XmlElement(type=WaitAction.class, name="Wait"), @XmlElement(type=SendAsciiAction.class, name="SendAscii"), @XmlElement(type=FlushSessionCacheAction.class, name="FlushSessionCache"), @XmlElement(type=GenericReceiveAsciiAction.class, name="GenericReceiveAscii"), @XmlElement(type=ReceiveAsciiAction.class, name="ReceiveAscii")})
    private List<TlsAction> tlsActions = new ArrayList<TlsAction>();
    private String name = null;
    private String description = null;
    @XmlTransient
    private boolean dirty = true;

    public static WorkflowTrace copy(WorkflowTrace orig) {
        WorkflowTrace copy = null;
        List<TlsAction> origActions = orig.getTlsActions();
        try {
            String origTraceStr = WorkflowTraceSerializer.write(orig);
            ByteArrayInputStream is = new ByteArrayInputStream(origTraceStr.getBytes(StandardCharsets.UTF_8.name()));
            copy = WorkflowTraceSerializer.read(is);
        }
        catch (IOException | JAXBException | XMLStreamException ex) {
            throw new ConfigurationException("Could not copy workflow trace: " + ex);
        }
        List<TlsAction> copiedActions = copy.getTlsActions();
        for (int i = 0; i < origActions.size(); ++i) {
            copiedActions.get(i).setSingleConnectionWorkflow(origActions.get(i).isSingleConnectionWorkflow());
        }
        return copy;
    }

    public WorkflowTrace() {
        this.tlsActions = new LinkedList<TlsAction>();
    }

    public WorkflowTrace(List<AliasedConnection> cons) {
        this.connections = cons;
    }

    public void reset() {
        for (TlsAction action : this.getTlsActions()) {
            action.reset();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TlsAction> getTlsActions() {
        return this.tlsActions;
    }

    public void addTlsAction(TlsAction action) {
        this.dirty = true;
        this.tlsActions.add(action);
    }

    public void addTlsActions(TlsAction ... actions) {
        this.addTlsActions(Arrays.asList(actions));
    }

    public void addTlsActions(List<TlsAction> actions) {
        for (TlsAction action : actions) {
            this.addTlsAction(action);
        }
    }

    public void addTlsAction(int position, TlsAction action) {
        this.dirty = true;
        this.tlsActions.add(position, action);
    }

    public TlsAction removeTlsAction(int index) {
        this.dirty = true;
        return this.tlsActions.remove(index);
    }

    public void setTlsActions(List<TlsAction> tlsActions) {
        this.dirty = true;
        this.tlsActions = tlsActions;
    }

    public void setTlsActions(TlsAction ... tlsActions) {
        this.setTlsActions(new ArrayList<TlsAction>(Arrays.asList(tlsActions)));
    }

    public List<AliasedConnection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<AliasedConnection> connections) {
        this.dirty = true;
        this.connections = connections;
    }

    public void addConnection(AliasedConnection connection) {
        this.dirty = true;
        this.connections.add(connection);
    }

    public List<MessageAction> getMessageActions() {
        LinkedList<MessageAction> messageActions = new LinkedList<MessageAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof MessageAction)) continue;
            messageActions.add((MessageAction)action);
        }
        return messageActions;
    }

    public List<ReceivingAction> getReceivingActions() {
        LinkedList<ReceivingAction> receiveActions = new LinkedList<ReceivingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof ReceivingAction)) continue;
            receiveActions.add((ReceivingAction)((Object)action));
        }
        return receiveActions;
    }

    public List<SendingAction> getSendingActions() {
        LinkedList<SendingAction> sendActions = new LinkedList<SendingAction>();
        for (TlsAction action : this.tlsActions) {
            if (!(action instanceof SendingAction)) continue;
            sendActions.add((SendingAction)((Object)action));
        }
        return sendActions;
    }

    public TlsAction getLastAction() {
        int size = this.tlsActions.size();
        if (size != 0) {
            return this.tlsActions.get(size - 1);
        }
        return null;
    }

    public MessageAction getLastMessageAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof MessageAction)) continue;
            return (MessageAction)this.tlsActions.get(i);
        }
        return null;
    }

    public SendingAction getLastSendingAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof SendingAction)) continue;
            return (SendingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public ReceivingAction getLastReceivingAction() {
        for (int i = this.tlsActions.size() - 1; i >= 0; --i) {
            if (!(this.tlsActions.get(i) instanceof ReceivingAction)) continue;
            return (ReceivingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public MessageAction getFirstMessageAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof MessageAction)) continue;
            return (MessageAction)this.tlsActions.get(i);
        }
        return null;
    }

    public SendingAction getFirstSendingAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof SendingAction)) continue;
            return (SendingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public ReceivingAction getFirstReceivingAction() {
        for (int i = 0; i < this.tlsActions.size(); ++i) {
            if (!(this.tlsActions.get(i) instanceof ReceivingAction)) continue;
            return (ReceivingAction)((Object)this.tlsActions.get(i));
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trace Actions:");
        for (TlsAction action : this.tlsActions) {
            sb.append("\n");
            sb.append(action.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.tlsActions);
        hash = 23 * hash + Objects.hashCode(this.name);
        hash = 23 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowTrace other = (WorkflowTrace)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.tlsActions, other.tlsActions);
    }

    public boolean executedAsPlanned() {
        for (TlsAction action : this.tlsActions) {
            if (!action.executedAsPlanned()) {
                LOGGER.debug("Action " + action.toCompactString() + " did not execute as planned");
                return false;
            }
            LOGGER.debug("Action " + action.toCompactString() + " executed as planned");
        }
        return true;
    }

    public boolean allActionsExecuted() {
        for (TlsAction action : this.tlsActions) {
            if (action.isExecuted()) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

