/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class OutsafeProtocolDecoder
extends BaseHttpProtocolDecoder {
    public OutsafeProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, json.getString("device"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date());
        position.setValid(true);
        position.setLatitude(json.getJsonNumber("latitude").doubleValue());
        position.setLongitude(json.getJsonNumber("longitude").doubleValue());
        position.setAltitude(json.getJsonNumber("altitude").doubleValue());
        position.setCourse(json.getJsonNumber("heading").intValue());
        position.set("rssi", json.getJsonNumber("rssi").intValue());
        position.set("origin", json.getString("origin"));
        JsonObject data = json.getJsonObject("data");
        for (Map.Entry entry : data.entrySet()) {
            this.decodeUnknownParam((String)entry.getKey(), (JsonValue)entry.getValue(), position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }

    private void decodeUnknownParam(String name, JsonValue value, Position position) {
        if (value instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)value;
            position.set(name, jsonNumber.doubleValue());
        } else if (value instanceof JsonString) {
            JsonString jsonString = (JsonString)value;
            position.set(name, jsonString.getString());
        } else if (value == JsonValue.TRUE || value == JsonValue.FALSE) {
            position.set(name, value == JsonValue.TRUE);
        }
    }
}

