/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.naming.NameUtility;
import javax.naming.InvalidNameException;

public class RDN {
    private int[] elements = null;
    private String ldapEscapedRDN;
    private int UNTESTED = 0;
    private int SINGLEVALUED = 1;
    private int MULTIVALUED = 2;
    private int status = this.UNTESTED;
    private static int MAXELEMENTS = 16;
    private boolean debug = false;

    public RDN() {
        this.ldapEscapedRDN = "";
    }

    public RDN(String rdn) {
        if (rdn == null) {
            rdn = "";
        } else {
            int len = rdn.length();
            rdn = rdn.indexOf(92) > -1 && len >= 2 && rdn.charAt(len - 2) == '\\' && rdn.charAt(len - 1) == ' ' ? this.specialSpaceHandling(rdn) : rdn.trim();
        }
        this.ldapEscapedRDN = rdn;
        if (this.debug) {
            System.out.println(" % NEW RDN: " + rdn);
        }
    }

    public RDN(RDN copyMe) {
        this(copyMe.ldapEscapedRDN);
    }

    private String specialSpaceHandling(String rdn) {
        int finalPos;
        int pos = finalPos = rdn.length() - 2;
        while (rdn.charAt(pos) == '\\') {
            --pos;
        }
        int numSlashesDeleted = finalPos - pos;
        int valuePos = rdn.indexOf(61) + 1;
        String att = rdn.substring(0, valuePos);
        String val = rdn.substring(valuePos);
        val = numSlashesDeleted % 2 == 0 ? val.trim() : val.trim() + " ";
        rdn = att + val;
        return rdn;
    }

    public boolean isEmpty() {
        return "".equals(this.ldapEscapedRDN);
    }

    public void addEscaped(String rdnfragment) throws InvalidNameException {
        this.validate();
        int equalpos = NameUtility.next(rdnfragment, 0, '=');
        if (equalpos <= 0 || equalpos == rdnfragment.length() - 1) {
            throw new InvalidNameException("RDN.add(): invalid rdn fragment '" + (rdnfragment == null ? "<null>" : rdnfragment) + "' (can't find equal sign)");
        }
        this.ldapEscapedRDN = this.ldapEscapedRDN.length() > 0 ? this.ldapEscapedRDN + "+" + rdnfragment : rdnfragment;
    }

    public void addRaw(String rdnfragment) throws InvalidNameException {
        int equalpos = NameUtility.next(rdnfragment, 0, '=');
        if (equalpos <= 0 || equalpos == rdnfragment.length() - 1) {
            throw new InvalidNameException("RDN.addRaw(): invalid rdn fragment '" + (rdnfragment == null ? "<null>" : rdnfragment) + "' (can't find equal sign)");
        }
        String attribute = rdnfragment.substring(0, equalpos);
        String value = rdnfragment.substring(equalpos + 1);
        this.addEscaped(attribute + "=" + NameUtility.escape(value));
    }

    public String toString() {
        return this.ldapEscapedRDN;
    }

    public void dump() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        System.out.println("DEBUG DUMP - RDN: " + this.ldapEscapedRDN + (this.status == this.MULTIVALUED ? " MULTI VALUED" : " SINGLE VALUED"));
        if (this.status == this.MULTIVALUED) {
            for (int i = 0; i < this.elements.length - 1; ++i) {
                System.out.println("element-m (" + (this.elements[i] + 1) + ") -> (" + this.elements[i + 1] + ") " + i + ": " + this.getElement(i));
            }
        } else {
            System.out.println("element-s 0: " + this.ldapEscapedRDN);
        }
        Thread.currentThread();
        Thread.dumpStack();
    }

    public String getElement(int i) {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (this.status == this.SINGLEVALUED && i == 0) {
            return this.ldapEscapedRDN;
        }
        if (i < 0 || this.elements == null || this.elements.length <= i + 1) {
            return "error VII";
        }
        return this.ldapEscapedRDN.substring(this.elements[i] + 1, this.elements[i + 1]);
    }

    public String[] getElements() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (this.status == this.SINGLEVALUED) {
            return new String[]{this.ldapEscapedRDN};
        }
        if (this.elements == null) {
            return new String[]{"error VIIB"};
        }
        String[] elementArray = new String[this.elements.length - 1];
        for (int i = 0; i < this.elements.length - 1; ++i) {
            elementArray[i] = this.ldapEscapedRDN.substring(this.elements[i] + 1, this.elements[i + 1]);
        }
        return elementArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int i, String ldapEscapedElement) throws InvalidNameException {
        this.validate();
        if (this.status == this.SINGLEVALUED) {
            if (i != 0) throw new InvalidNameException("cannot set non zero element of single valued rdn.");
            this.ldapEscapedRDN = ldapEscapedElement;
            return;
        } else {
            if (i < 0 || i >= this.size()) {
                throw new InvalidNameException("attempt to set element " + i + " of rdn: '" + this.ldapEscapedRDN + "' (size = " + this.size() + ")");
            }
            this.ldapEscapedRDN = this.ldapEscapedRDN.substring(0, this.elements[i] + 1) + ldapEscapedElement + this.ldapEscapedRDN.substring(this.elements[i + 1]);
            this.parseMultiValued();
        }
    }

    public String getAtt() {
        return this.getAtt(0);
    }

    public String getAtt(int i) {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (this.status == this.SINGLEVALUED && i != 0) {
            return "rdn error VIII";
        }
        String element = this.getElement(i);
        int pos = element.indexOf(61);
        if (pos == -1) {
            return "rdn error IX";
        }
        if (this.debug) {
            System.out.println("Debug = " + this.debug);
            Thread.currentThread();
            Thread.dumpStack();
            System.out.println(" % RDN -> found attribute as '" + element.substring(0, pos) + "'");
        }
        return element.substring(0, pos);
    }

    public String[] getAtts() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        String[] atts = this.getElements();
        for (int i = 0; i < atts.length; ++i) {
            int pos = atts[i].indexOf(61);
            if (pos == -1) {
                return new String[]{"rdn error IXB"};
            }
            atts[i] = atts[i].substring(0, pos);
        }
        return atts;
    }

    public boolean contains(String attributeType) {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (attributeType == null || attributeType.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!attributeType.equalsIgnoreCase(this.getAtt(i))) continue;
            return true;
        }
        return false;
    }

    public String getRawVal(String attributeType) {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (attributeType == null || attributeType.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!attributeType.equalsIgnoreCase(this.getAtt(i))) continue;
            return this.getRawVal(i);
        }
        return null;
    }

    public String getRawVal() {
        return this.getRawVal(0);
    }

    public String getRawVal(int i) {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        if (this.status == this.SINGLEVALUED && i != 0) {
            return "rdn error X";
        }
        String element = this.getElement(i);
        int pos = element.indexOf(61);
        if (pos == -1) {
            return "rdn error XI";
        }
        String raw = element.substring(pos + 1);
        try {
            return NameUtility.unescape(raw);
        }
        catch (Exception e) {
            return "rdn error XII";
        }
    }

    public String[] getRawVals() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        String[] vals = this.getElements();
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.getRawVal(i);
        }
        return vals;
    }

    public void setRawVal(String v) throws InvalidNameException {
        this.setRawVal(v, 0);
    }

    public void setRawVal(String v, int i) throws InvalidNameException {
        this.validate();
        String attval = this.getElement(i);
        String att = attval.substring(0, attval.indexOf(61));
        if (att == null || att.length() == 0) {
            throw new InvalidNameException("can't parse old RDN '" + this.ldapEscapedRDN);
        }
        String newElement = att + "=" + NameUtility.escape(v);
        this.setElement(i, newElement);
    }

    public int size() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        return this.status == this.SINGLEVALUED ? 1 : this.elements.length - 1;
    }

    public boolean isMultiValued() {
        if (this.status == this.UNTESTED) {
            this.checkForMultiValued();
        }
        return this.status == this.MULTIVALUED;
    }

    public boolean equals(RDN test) {
        if (test == null) {
            return false;
        }
        if (test.size() != this.size()) {
            return false;
        }
        if (this.isMultiValued()) {
            String[] atts = this.getAtts();
            String[] vals = this.getRawVals();
            String[] testAtts = test.getAtts();
            String[] testVals = test.getRawVals();
            for (int i = 0; i < this.size(); ++i) {
                if (this.elementsEqual(atts[i], testAtts[i], vals[i], testVals[i])) continue;
                return false;
            }
            return true;
        }
        return this.elementsEqual(this.getAtt(), test.getAtt(), this.getRawVal(), test.getRawVal());
    }

    private boolean elementsEqual(String att1, String att2, String val1, String val2) {
        if (!att1.equalsIgnoreCase(att2)) {
            return false;
        }
        return val1.equalsIgnoreCase(val2);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof RDN) {
            return this.equals((RDN)o);
        }
        return this.ldapEscapedRDN.equalsIgnoreCase(o.toString());
    }

    private void checkForMultiValued() {
        if (this.status != this.UNTESTED) {
            return;
        }
        if (NameUtility.next(this.ldapEscapedRDN, 0, '+') == -1) {
            this.status = this.SINGLEVALUED;
        } else {
            this.status = this.MULTIVALUED;
            this.parseMultiValued(MAXELEMENTS);
        }
    }

    private void parseMultiValued() {
        this.parseMultiValued(MAXELEMENTS);
    }

    private void parseMultiValued(int max) {
        if (max > 512) {
            System.err.println("wierd error in RDN - attempt to parse RDN with more than 512 sub units???");
            return;
        }
        try {
            int pos2;
            int pos1;
            int[] temp = new int[max];
            temp[0] = -1;
            int numElements = 0;
            int pos = 0;
            if (this.debug) {
                System.out.println("\n*** parsing multi valued rdn");
            }
            if (this.debug) {
                System.out.println("parsing " + this.ldapEscapedRDN);
            }
            while ((pos = NameUtility.next(this.ldapEscapedRDN, pos, '+')) > -1) {
                temp[++numElements] = pos;
                if (this.debug) {
                    System.out.println("found " + numElements + " -th element at " + pos);
                }
                pos1 = temp[numElements - 1] + 1;
                pos2 = temp[numElements];
                if (this.debug) {
                    System.out.println(" = string " + pos1 + " -> " + pos2 + " = ");
                }
                if (this.debug) {
                    System.out.println(this.ldapEscapedRDN.substring(pos1, pos2));
                }
                ++pos;
            }
            temp[++numElements] = this.ldapEscapedRDN.length();
            pos1 = temp[numElements - 1] + 1;
            pos2 = temp[numElements];
            if (this.debug) {
                System.out.println("found " + numElements + " -th element at " + pos + " = string " + pos1 + " -> " + pos2 + " final len: " + this.ldapEscapedRDN.length());
            }
            if (this.debug) {
                System.out.println(" = '" + this.ldapEscapedRDN.substring(pos1, pos2) + "'");
            }
            if (this.debug) {
                System.out.println("found total of " + numElements + " elements...\n*****\n");
            }
            this.elements = new int[numElements + 1];
            System.arraycopy(temp, 0, this.elements, 0, numElements + 1);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            System.err.println("huge number of multi-valued RDN units - increasing to: " + max * 2);
            this.parseMultiValued(max * 2);
        }
    }

    public boolean validate() {
        try {
            if (this.status == this.UNTESTED) {
                this.checkForMultiValued();
            }
            if (this.isEmpty()) {
                return false;
            }
            int noElements = this.size();
            for (int i = 0; i < noElements; ++i) {
                String att = this.getAtt(i);
                String val = this.getRawVal(i);
                if (att == null || att.length() == 0) {
                    return false;
                }
                if (val != null && val.length() != 0 && !val.startsWith("error ")) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

