/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.wildfly.security.ssl.AbstractDelegatingSSLServerSocket;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLServerSocket
extends AbstractDelegatingSSLServerSocket {
    private final SSLContext sslContext;
    private final SSLConfigurator sslConfigurator;

    ConfiguredSSLServerSocket(SSLServerSocket delegate, SSLContext sslContext, SSLConfigurator sslConfigurator) throws IOException {
        super(delegate);
        this.sslContext = sslContext;
        this.sslConfigurator = sslConfigurator;
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslConfigurator.setEnabledCipherSuites(this.sslContext, this.getDelegate(), suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslConfigurator.setEnabledProtocols(this.sslContext, this.getDelegate(), protocols);
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.sslConfigurator.setSSLParameters(this.sslContext, this.getDelegate(), params);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslConfigurator.setNeedClientAuth(this.sslContext, this.getDelegate(), need);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslConfigurator.setWantClientAuth(this.sslContext, this.getDelegate(), want);
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        this.sslConfigurator.setUseClientMode(this.sslContext, this.getDelegate(), clientMode);
    }

    @Override
    public void setEnableSessionCreation(boolean enabled) {
        this.sslConfigurator.setEnableSessionCreation(this.sslContext, this.getDelegate(), enabled);
    }
}

