/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.tlsattacker.core.certificate.CrlReason;
import de.rub.nds.tlsattacker.core.certificate.ObjectIdentifierTranslator;
import de.rub.nds.tlsattacker.core.certificate.ocsp.RevocationStatus;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.bouncycastle.util.encoders.Hex;

public class CertificateStatus {
    private Asn1Sequence certificateStatusSequence;
    private String hashAlgorithmIdentifier;
    private byte[] issuerNameHash;
    private byte[] issuerKeyHash;
    private BigInteger serialNumber;
    private Integer certificateStatus;
    private String revocationTime;
    private Integer revocationReason;
    private String timeOfLastUpdate;
    private String timeOfNextUpdate;

    public Asn1Sequence getCertificateStatusSequence() {
        return this.certificateStatusSequence;
    }

    public void setCertificateStatusSequence(Asn1Sequence certificateStatusSequence) {
        this.certificateStatusSequence = certificateStatusSequence;
    }

    public String getHashAlgorithmIdentifier() {
        return this.hashAlgorithmIdentifier;
    }

    public void setHashAlgorithmIdentifier(String hashAlgorithmIdentifier) {
        this.hashAlgorithmIdentifier = hashAlgorithmIdentifier;
    }

    public byte[] getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public void setIssuerNameHash(byte[] issuerNameHash) {
        this.issuerNameHash = issuerNameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public void setIssuerKeyHash(byte[] issuerKeyHash) {
        this.issuerKeyHash = issuerKeyHash;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Integer getCertificateStatus() {
        return this.certificateStatus;
    }

    public void setCertificateStatus(Integer certificateStatus) {
        this.certificateStatus = certificateStatus;
    }

    public String getRevocationTime() {
        return this.revocationTime;
    }

    public void setRevocationTime(String revocationTime) {
        this.revocationTime = revocationTime;
    }

    public String getTimeOfLastUpdate() {
        return this.timeOfLastUpdate;
    }

    public void setTimeOfLastUpdate(String timeOfLastUpdate) {
        this.timeOfLastUpdate = timeOfLastUpdate;
    }

    public String getTimeOfNextUpdate() {
        return this.timeOfNextUpdate;
    }

    public void setTimeOfNextUpdate(String timeOfNextUpdate) {
        this.timeOfNextUpdate = timeOfNextUpdate;
    }

    public Integer getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(Integer revocationReason) {
        this.revocationReason = revocationReason;
    }

    private String formatDate(String unformattedDateString) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss'Z'", Locale.ENGLISH);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        LocalDateTime date = LocalDateTime.parse(unformattedDateString, inputFormatter);
        return outputFormatter.format(date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate Status");
        if (this.certificateStatus != null) {
            sb.append("\n Hash Algorithm: ").append(ObjectIdentifierTranslator.translate(this.getHashAlgorithmIdentifier()));
            sb.append("\n Issuer Name Hash: ").append(Hex.toHexString((byte[])this.getIssuerNameHash()));
            sb.append("\n Issuer Key Hash: ").append(Hex.toHexString((byte[])this.getIssuerKeyHash()));
            sb.append("\n Serial Number: ").append(this.getSerialNumber().toString(16));
            sb.append("\n Certificate Status: ");
            sb.append(RevocationStatus.translate(this.getCertificateStatus()));
            if (this.getCertificateStatus().equals(RevocationStatus.translate("revoked"))) {
                sb.append("\n Revocation Time: ").append(this.formatDate(this.getRevocationTime()));
                if (this.getRevocationReason() != null) {
                    sb.append("\n Revocation Reason: ");
                    sb.append(CrlReason.translate(this.getRevocationReason()));
                }
            }
            sb.append("\n Last Update: ").append(this.formatDate(this.getTimeOfLastUpdate()));
            sb.append("\n Next Update: ").append(this.formatDate(this.getTimeOfNextUpdate()));
        }
        return sb.toString();
    }
}

