/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.PageContext;
import java.util.Objects;

public class ScopedAttributeELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        Object result = null;
        if (base == null && property != null) {
            String key = property.toString();
            PageContext page = (PageContext)context.getContext(JspContext.class);
            result = page.findAttribute(key);
            if (result != null) {
                context.setPropertyResolved(null, property);
            }
        }
        return result;
    }

    public Class<Object> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null) {
            context.setPropertyResolved(null, property);
            return Object.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base == null) {
            context.setPropertyResolved(null, property);
            if (property != null) {
                String key = property.toString();
                PageContext page = (PageContext)context.getContext(JspContext.class);
                int scope = page.getAttributesScope(key);
                if (scope != 0) {
                    page.setAttribute(key, value, scope);
                } else {
                    page.setAttribute(key, value);
                }
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base == null) {
            context.setPropertyResolved(null, property);
        }
        return false;
    }

    public Class<String> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }
}

