/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ColonyTest
extends FreeColTestCase {
    private static final BuildingType carpenterHouseType = ColonyTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType churchType = ColonyTest.spec().getBuildingType("model.building.church");
    private static final BuildingType depotType = ColonyTest.spec().getBuildingType("model.building.depot");
    private static final BuildingType lumberMillType = ColonyTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType townHallType = ColonyTest.spec().getBuildingType("model.building.townHall");
    private static final BuildingType warehouseType = ColonyTest.spec().getBuildingType("model.building.warehouse");
    private static final BuildingType warehouseExpansionType = ColonyTest.spec().getBuildingType("model.building.warehouseExpansion");
    private static final BuildingType weaversHouseType = ColonyTest.spec().getBuildingType("model.building.weaverHouse");
    private static final GoodsType bellsGoodsType = ColonyTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType clothGoodsType = ColonyTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType cottonGoodsType = ColonyTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType foodGoodsType = ColonyTest.spec().getPrimaryFoodType();
    private static final GoodsType grainGoodsType = ColonyTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammerGoodsType = ColonyTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType lumberGoodsType = ColonyTest.spec().getGoodsType("model.goods.lumber");
    private static final ResourceType cottonResourceType = ColonyTest.spec().getResourceType("model.resource.cotton");
    private static final TileImprovementType plowTileImprovementType = ColonyTest.spec().getTileImprovementType("model.improvement.plow");
    private static final Role soldierRole = ColonyTest.spec().getRole("model.role.soldier");
    private static final TileType arcticTileType = ColonyTest.spec().getTileType("model.tile.arctic");
    private static final TileType plainsTileType = ColonyTest.spec().getTileType("model.tile.plains");
    private static final TileType prairieTileType = ColonyTest.spec().getTileType("model.tile.prairie");
    private static final UnitType cottonPlanterType = ColonyTest.spec().getUnitType("model.unit.masterCottonPlanter");
    private static final UnitType elderStatesmanType = ColonyTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType freeColonistType = ColonyTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType masterWeaverType = ColonyTest.spec().getUnitType("model.unit.masterWeaver");
    private static final UnitType wagonTrainType = ColonyTest.spec().getUnitType("model.unit.wagonTrain");
    private static final UnitType braveType = ColonyTest.spec().getUnitType("model.unit.brave");

    public void testCurrentlyBuilding() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        colony.setCurrentlyBuilding(warehouseType);
        ColonyTest.assertEquals((String)"Colony should be building a warehouse", (Object)warehouseType, (Object)colony.getCurrentlyBuilding());
        colony.setCurrentlyBuilding(churchType);
        ColonyTest.assertEquals((String)"Colony should be building a church", (Object)churchType, (Object)colony.getCurrentlyBuilding());
    }

    public void testBuildQueueDoesNotAcceptBuildingDoubles() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        colony.setCurrentlyBuilding(warehouseType);
        ColonyTest.assertEquals((String)"Building queue should have 1 entry", (int)1, (int)colony.getBuildQueue().size());
        colony.setCurrentlyBuilding(warehouseType);
        ColonyTest.assertEquals((String)"Building queue should still have 1 entry", (int)1, (int)colony.getBuildQueue().size());
        colony.setCurrentlyBuilding(churchType);
        ColonyTest.assertEquals((String)"Building queue should have 2 entries", (int)2, (int)colony.getBuildQueue().size());
        colony.setCurrentlyBuilding(warehouseType);
        ColonyTest.assertEquals((String)"Building queue should still have 2 entries", (int)2, (int)colony.getBuildQueue().size());
    }

    public void testBuildQueueAcceptsUnitDoubles() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        colony.setCurrentlyBuilding(wagonTrainType);
        ColonyTest.assertEquals((String)"Building queue should have 2 entry", (int)2, (int)colony.getBuildQueue().size());
        colony.setCurrentlyBuilding(wagonTrainType);
        ColonyTest.assertEquals((String)"Building queue should have 3 entries", (int)3, (int)colony.getBuildQueue().size());
    }

    public void testOccupationWithFood() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        int population = 1;
        Colony colony = this.getStandardColony(population);
        ColonyTest.assertTrue((String)"colony should produce enough food", (colony.getFoodProduction() > colony.getFoodConsumption() + freeColonistType.getConsumptionOf(grainGoodsType) ? 1 : 0) != 0);
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertTrue((boolean)(colonist.getLocation() instanceof ColonyTile));
        ColonyTest.assertEquals((Object)grainGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(cottonGoodsType);
        colonist.modifyExperience(100);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertTrue((boolean)(colonist.getLocation() instanceof ColonyTile));
        ColonyTest.assertEquals((Object)cottonGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.setType(cottonPlanterType);
        colonist.changeWorkType(null);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertTrue((boolean)(colonist.getLocation() instanceof ColonyTile));
        ColonyTest.assertEquals((Object)cottonGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.setType(elderStatesmanType);
        colonist.changeWorkType(null);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertTrue((boolean)(colonist.getLocation() instanceof Building));
        ColonyTest.assertEquals((Object)townHallType, (Object)((Building)colonist.getLocation()).getType());
        ColonyTest.assertEquals((Object)bellsGoodsType, (Object)colonist.getWorkType());
    }

    private int countParties(Colony colony) {
        return CollectionUtils.count(colony.getModifiers("model.goods.bells"), m -> Specification.COLONY_GOODS_PARTY_SOURCE.equals(m.getSource()));
    }

    public void testTeaParty() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(5);
        Player player = colony.getOwner();
        ColonyTest.assertEquals((int)0, (int)this.countParties(colony));
        colony.addModifier(((ServerPlayer)player).makeTeaPartyModifier());
        ColonyTest.assertEquals((int)1, (int)this.countParties(colony));
        Modifier m = ((ServerPlayer)player).makeTeaPartyModifier();
        m.setFirstTurn(new Turn(game.getTurn().getNumber() + 1));
        colony.addModifier(m);
        ColonyTest.assertEquals((int)2, (int)this.countParties(colony));
    }

    public void testAddUnitToColony() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(arcticTileType, true));
        int population = 1;
        Colony colony = this.getStandardColony(population);
        ColonyTest.assertTrue((String)"colony should produce less food than it consumes", (colony.getFoodProduction() < colony.getFoodConsumption() + freeColonistType.getConsumptionOf(foodGoodsType) ? 1 : 0) != 0);
        ColonyTest.assertEquals((int)2, (int)freeColonistType.getConsumptionOf(foodGoodsType));
        ColonyTest.assertEquals((int)2, (int)masterWeaverType.getConsumptionOf(foodGoodsType));
        Unit colonist = colony.getUnitList().get(0);
        Building townHall = colony.getBuilding(townHallType);
        ColonyTest.assertEquals((Object)townHall, (Object)colonist.getLocation());
        ColonyTest.assertEquals((Object)townHall, (Object)colony.getWorkLocationFor(colonist));
        ColonyTest.assertEquals((Object)bellsGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(cottonGoodsType);
        colonist.modifyExperience(100);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertEquals((Object)townHall, (Object)colony.getWorkLocationFor(colonist));
        ColonyTest.assertEquals((Object)townHall, (Object)((Building)colonist.getLocation()));
        ColonyTest.assertEquals((Object)bellsGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        ServerUnit statesman = new ServerUnit(game, colony.getTile(), colony.getOwner(), elderStatesmanType);
        this.nonServerJoinColony(statesman, colony);
        ColonyTest.assertEquals((Object)townHall, (Object)statesman.getLocation());
        ColonyTest.assertEquals((Object)bellsGoodsType, (Object)statesman.getWorkType());
        Tile plainsTile = colony.getTile().getNeighbourOrNull(Direction.S);
        plainsTile.setType(plainsTileType);
        ColonyTile plainsColonyTile = colony.getColonyTile(plainsTile);
        ColonyTest.assertTrue((boolean)plainsColonyTile.isEmpty());
        Tile prairieTile = colony.getTile().getNeighbourOrNull(Direction.N);
        prairieTile.setType(prairieTileType);
        prairieTile.addResource(new Resource(game, prairieTile, cottonResourceType));
        ColonyTile prairieColonyTile = colony.getColonyTile(prairieTile);
        ColonyTest.assertTrue((boolean)prairieColonyTile.isEmpty());
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(cottonGoodsType);
        colonist.modifyExperience(100);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertEquals((Object)plainsColonyTile, (Object)colonist.getLocation());
        ColonyTest.assertEquals((Object)grainGoodsType, (Object)colonist.getWorkType());
        colony.getTile().changeType(plainsTileType);
        TileImprovement tileImprovement = new TileImprovement(game, colony.getTile(), plowTileImprovementType, null);
        tileImprovement.setTurnsToComplete(0);
        colony.getTile().add(tileImprovement);
        colony.invalidateCache();
        ColonyTest.assertTrue((String)"colony should produce more food than it consumes", (colony.getFoodProduction() >= colony.getFoodConsumption() + freeColonistType.getConsumptionOf(foodGoodsType) ? 1 : 0) != 0);
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(cottonGoodsType);
        colonist.modifyExperience(100);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertEquals((Object)prairieColonyTile, (Object)colonist.getLocation());
        ColonyTest.assertEquals((Object)cottonGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(null);
        colonist.setType(cottonPlanterType);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertEquals((Object)prairieColonyTile, (Object)colonist.getLocation());
        ColonyTest.assertEquals((Object)cottonGoodsType, (Object)colonist.getWorkType());
        colonist.setLocation(colony.getTile());
        colonist.changeWorkType(null);
        colonist.setType(masterWeaverType);
        colony.addGoods(cottonGoodsType, 100);
        this.nonServerJoinColony(colonist, colony);
        ColonyTest.assertTrue((boolean)(colonist.getLocation() instanceof Building));
        Building weaversHouse = colony.getBuilding(weaversHouseType);
        ColonyTest.assertEquals((Object)weaversHouse, (Object)((Building)colonist.getLocation()));
        ColonyTest.assertEquals((Object)clothGoodsType, (Object)colonist.getWorkType());
    }

    public void testFoundColony() {
        Game game = ColonyTest.getGame();
        Map map = ColonyTest.getCoastTestMap(plainsTileType);
        game.changeMap(map);
        Colony colony = this.getStandardColony(3, 1, 8);
        Player dutch = colony.getOwner();
        Tile colonyTile = colony.getTile();
        ColonyTest.assertEquals((Object)colonyTile.getType(), (Object)plainsTileType);
        Unit colonist = CollectionUtils.first(colony.getUnits());
        Tile workedTile = null;
        for (ColonyTile ct : colony.getColonyTiles()) {
            if (ct.isColonyCenterTile()) continue;
            workedTile = ct.getWorkTile();
            if (workedTile.isInUse()) break;
            if (workedTile.getType() != plainsTileType) continue;
            colonist.changeWorkType(ColonyTest.spec().getPrimaryFoodType());
            colonist.setLocation(ct);
            break;
        }
        ColonyTest.assertTrue((boolean)workedTile.isInUse());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.build();
        Player indianPlayer = camp.getOwner();
        Tile campTile = camp.getTile();
        ColonyTest.assertEquals((Object)campTile.getType(), (Object)plainsTileType);
        Tile nativeTile = null;
        for (Tile t : camp.getTile().getSurroundingTiles(1)) {
            if (t.getType() != plainsTileType) continue;
            nativeTile = t;
            break;
        }
        ColonyTest.assertEquals((Object)nativeTile.getOwner(), (Object)indianPlayer);
        Player french = game.getPlayerByNationId("model.nation.french");
        Colony frenchColony = this.getStandardColony(3, 9, 8);
        frenchColony.changeOwner(french);
        ColonyTest.assertEquals((Object)frenchColony.getTile().getType(), (Object)plainsTileType);
        Tile frenchTile = null;
        for (Tile t : frenchColony.getTile().getSurroundingTiles(1)) {
            if (t.getType() != plainsTileType) continue;
            frenchTile = t;
            break;
        }
        ColonyTest.assertEquals((Object)frenchTile.getOwner(), (Object)french);
        Tile landTile = map.getTile(1, 1);
        Tile lcrTile = map.getTile(2, 2);
        lcrTile.add(new LostCityRumour(game, lcrTile, LostCityRumour.RumourType.NO_SUCH_RUMOUR, "fake"));
        Tile waterTile = map.getTile(12, 12);
        ColonyTest.assertTrue((!waterTile.isLand() ? 1 : 0) != 0);
        ColonyTest.assertTrue((String)"Can own empty tile", (boolean)dutch.canOwnTile(landTile));
        ColonyTest.assertFalse((String)"Europeans can not own tile with an LCR on it", (boolean)dutch.canOwnTile(lcrTile));
        ColonyTest.assertTrue((String)"Natives can own tile with an LCR on it", (boolean)indianPlayer.canOwnTile(campTile));
        ColonyTest.assertTrue((String)"Europeans can own water tile", (boolean)dutch.canOwnTile(waterTile));
        ColonyTest.assertFalse((String)"Natives can not own water tile", (boolean)indianPlayer.canOwnTile(waterTile));
        ColonyTest.assertEquals((String)"Can found on land", (Object)Player.NoClaimReason.NONE, (Object)dutch.canClaimToFoundSettlementReason(landTile));
        ColonyTest.assertEquals((String)"Can found on unsettleable tile", (Object)Player.NoClaimReason.TERRAIN, (Object)dutch.canClaimToFoundSettlementReason(waterTile));
        ColonyTest.assertEquals((String)"Can not found on LCR", (Object)Player.NoClaimReason.RUMOUR, (Object)dutch.canClaimToFoundSettlementReason(lcrTile));
        ColonyTest.assertEquals((String)"Can not found on water", (Object)Player.NoClaimReason.TERRAIN, (Object)indianPlayer.canClaimToFoundSettlementReason(waterTile));
        ColonyTest.assertEquals((String)"Can not found on settlement", (Object)Player.NoClaimReason.SETTLEMENT, (Object)dutch.canClaimToFoundSettlementReason(campTile));
        ColonyTest.assertEquals((String)"Can not found on tile in use", (Object)Player.NoClaimReason.WORKED, (Object)dutch.canClaimToFoundSettlementReason(workedTile));
        ColonyTest.assertEquals((String)"Can not found on European tile", (Object)Player.NoClaimReason.EUROPEANS, (Object)dutch.canClaimToFoundSettlementReason(frenchTile));
        ColonyTest.assertEquals((String)"Might be able to found on native settlement tile", (Object)Player.NoClaimReason.NATIVES, (Object)dutch.canClaimToFoundSettlementReason(nativeTile));
        landTile.setOwner(indianPlayer);
        ColonyTest.assertEquals((String)"Might be able to found on loose native tile", (Object)Player.NoClaimReason.NATIVES, (Object)dutch.canClaimToFoundSettlementReason(landTile));
        landTile.setOwner(null);
        ColonyTest.assertEquals((String)"Can use land", (Object)Player.NoClaimReason.NONE, (Object)dutch.canClaimForSettlementReason(landTile));
        ColonyTest.assertEquals((String)"Can use unsettleable tile", (Object)Player.NoClaimReason.NONE, (Object)dutch.canClaimForSettlementReason(waterTile));
        ColonyTest.assertEquals((String)"Europeans can not use LCR", (Object)Player.NoClaimReason.RUMOUR, (Object)dutch.canClaimForSettlementReason(lcrTile));
        ColonyTest.assertEquals((String)"Natives can use LCR", (Object)Player.NoClaimReason.NONE, (Object)indianPlayer.canClaimForSettlementReason(lcrTile));
        ColonyTest.assertEquals((String)"Europeans can use water", (Object)Player.NoClaimReason.NONE, (Object)dutch.canClaimForSettlementReason(waterTile));
        ColonyTest.assertEquals((String)"Natives can not use water", (Object)Player.NoClaimReason.WATER, (Object)indianPlayer.canClaimForSettlementReason(waterTile));
        ColonyTest.assertEquals((String)"Can not use on settlement", (Object)Player.NoClaimReason.SETTLEMENT, (Object)dutch.canClaimForSettlementReason(campTile));
        ColonyTest.assertEquals((String)"Can not use tile in use", (Object)Player.NoClaimReason.WORKED, (Object)dutch.canClaimForSettlementReason(workedTile));
        ColonyTest.assertEquals((String)"Can not use European tile", (Object)Player.NoClaimReason.EUROPEANS, (Object)dutch.canClaimForSettlementReason(frenchTile));
        ColonyTest.assertEquals((String)"Can not use native tile", (Object)Player.NoClaimReason.NATIVES, (Object)dutch.canClaimForSettlementReason(nativeTile));
    }

    public void testUnderSiege() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(5);
        Tile tile = colony.getTile().getNeighbourOrNull(Direction.N);
        Player iroquois = game.getPlayerByNationId("model.nation.iroquois");
        ColonyTest.assertFalse((String)"No enemy units present.", (boolean)colony.isUnderSiege());
        ServerUnit brave = new ServerUnit(game, tile, iroquois, braveType);
        ColonyTest.assertFalse((String)"Not at war with the Iroquois.", (boolean)colony.isUnderSiege());
        colony.getOwner().setStance(iroquois, Stance.WAR);
        iroquois.setStance(colony.getOwner(), Stance.WAR);
        ColonyTest.assertTrue((String)"At war with the Iroquois.", (boolean)colony.isUnderSiege());
        Role soldierRole = ColonyTest.spec().getRole("model.role.soldier");
        ServerUnit soldier = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType, soldierRole);
        ColonyTest.assertFalse((String)"Equal number of friendly and enemy combat units.", (boolean)colony.isUnderSiege());
        ServerUnit brave2 = new ServerUnit(game, tile, iroquois, braveType);
        ColonyTest.assertTrue((String)"Enemy combat units outnumber friendly combat units.", (boolean)colony.isUnderSiege());
        ServerUnit colonist = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        ColonyTest.assertTrue((String)"Enemy combat units outnumber friendly combat units.", (boolean)colony.isUnderSiege());
        colonist.changeRole(soldierRole, 1);
        ColonyTest.assertFalse((String)"Equal number of friendly and enemy combat units.", (boolean)colony.isUnderSiege());
    }

    public void testUpkeep() {
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(5);
        ColonyTest.assertEquals((String)"New colonies should not require upkeep.", (int)0, (int)colony.getUpkeep());
        int churchUpkeep = churchType.getUpkeep();
        colony.getBuilding(churchType).upgrade();
        ColonyTest.assertEquals((int)churchUpkeep, (int)colony.getUpkeep());
        int lumberMillUpkeep = lumberMillType.getUpkeep();
        colony.getBuilding(carpenterHouseType).upgrade();
        ColonyTest.assertEquals((int)(churchUpkeep + lumberMillUpkeep), (int)colony.getUpkeep());
    }

    public void testCopyColony() {
        Tile oct;
        Game game = ColonyTest.getGame();
        game.changeMap(ColonyTest.getTestMap(true));
        Colony colony = this.getStandardColony(2);
        Player player = colony.getOwner();
        Colony copied = colony.copyColony();
        ColonyTest.assertNotNull((Object)copied);
        ColonyTest.assertFalse((colony == copied ? 1 : 0) != 0);
        ColonyTest.assertTrue((boolean)colony.equals(copied));
        ColonyTest.assertEquals((String)colony.getId(), (String)copied.getId());
        ColonyTest.assertEquals((String)colony.getName(), (String)copied.getName());
        for (Settlement s : player.getSettlementList()) {
            ColonyTest.assertFalse((s == copied ? 1 : 0) != 0);
        }
        Tile ct = colony.getTile();
        ColonyTest.assertFalse((ct == (oct = copied.getTile()) ? 1 : 0) != 0);
        ColonyTest.assertEquals((String)ct.getId(), (String)oct.getId());
        ColonyTest.assertEquals((int)ct.getUnitCount(), (int)oct.getUnitCount());
        ColonyTest.assertEquals((Object)ct.getType(), (Object)oct.getType());
        ColonyTest.assertEquals((Object)oct.getColony(), (Object)copied);
        ColonyTest.assertEquals((Object)oct.getOwningSettlement(), (Object)copied);
        for (WorkLocation wl : colony.getAllWorkLocationsList()) {
            WorkLocation owl = copied.getCorresponding(wl);
            ColonyTest.assertNotNull((Object)owl);
            ColonyTest.assertFalse((wl == owl ? 1 : 0) != 0);
            ColonyTest.assertEquals((String)wl.getId(), (String)owl.getId());
            Tile wt = wl.getWorkTile();
            if (wt != null) {
                Tile owt = owl.getWorkTile();
                ColonyTest.assertFalse((wt == owt ? 1 : 0) != 0);
                ColonyTest.assertEquals((String)wt.getId(), (String)owt.getId());
                ColonyTest.assertEquals((Object)wt.getType(), (Object)owt.getType());
                ColonyTest.assertEquals((Object)owt.getOwningSettlement(), (Object)copied);
            }
            ColonyTest.assertEquals((int)wl.getUnitCount(), (int)owl.getUnitCount());
            for (Unit u : wl.getUnitList()) {
                Unit ou = copied.getCorresponding(u);
                ColonyTest.assertNotNull((Object)ou);
                ColonyTest.assertFalse((u == ou ? 1 : 0) != 0);
                ColonyTest.assertEquals((String)u.getId(), (String)ou.getId());
                ColonyTest.assertEquals((Object)u.getType(), (Object)ou.getType());
                ColonyTest.assertEquals((Object)u.getRole(), (Object)ou.getRole());
                ColonyTest.assertEquals((Object)game.getFreeColGameObject(u.getId()), (Object)u);
                ColonyTest.assertEquals((Object)u.getOwner(), (Object)ou.getOwner());
            }
        }
    }
}

