/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBBasicComboBoxRenderer;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBListSelector;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.search.BuildFilterPanel;
import com.ca.directory.jxplorer.search.JoinFilterPanel;
import com.ca.directory.jxplorer.search.ReturnAttributesDialog;
import com.ca.directory.jxplorer.search.SearchExecute;
import com.ca.directory.jxplorer.search.SearchModel;
import com.ca.directory.jxplorer.search.TextFilterPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchGUI
extends CBDialog {
    final JXplorer jx;
    protected JTabbedPane tabbedPane;
    JCheckBox aliasSearchCheckBox;
    JCheckBox aliasFindingCheckBox;
    JTextField baseDNTextField;
    JTextField filterNameTextField;
    CBJComboBox andOrCombo;
    CBJComboBox searchLevelCombo;
    CBJComboBox returnAttributesCombo;
    static final String[] andOrArray = new String[]{CBIntText.get("And"), CBIntText.get("Or")};
    static final String[] searchLevelArray = new String[]{CBIntText.get("Search Base Object"), CBIntText.get("Search Next Level"), CBIntText.get("Search Full Subtree")};
    static final int BASEOBJECTSEARCH = 0;
    static final int ONELEVELSEARCH = 1;
    static final int FULLSUBTREESEARCH = 2;
    CBButton btnSave;
    CBButton btnLoad;
    CBButton btnMore;
    CBButton btnLess;
    CBButton btnView;
    BuildFilterPanel build;
    JoinFilterPanel join;
    TextFilterPanel text;
    SearchModel searchModel;
    String buildName = "Untitled";
    String joinName = "Untitled";
    String textName = "Untitled";
    String dirImages;
    CBButton[] btnEdit = new CBButton[50];
    int buttonCounter = 0;
    String[] returnAttrs = null;
    private static Logger log = Logger.getLogger(SearchGUI.class.getName());

    public SearchGUI(DN baseDN, JXplorer jxplorer) {
        super((Frame)jxplorer, CBIntText.get("Search"), "search");
        this.jx = jxplorer;
        this.dirImages = JXplorer.getProperty("dir.images");
        this.build = new BuildFilterPanel(this.jx);
        this.join = new JoinFilterPanel(this.getEditButton());
        this.text = new TextFilterPanel();
        ++this.buttonCounter;
        this.searchModel = new SearchModel();
        CBPanel panel = this.getMainPanel(baseDN);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(CBIntText.get("Build Filter"), new ImageIcon(this.dirImages + "build.gif"), this.build, CBIntText.get("Build a filter from scratch."));
        this.tabbedPane.addTab(CBIntText.get("Join Filters"), new ImageIcon(this.dirImages + "join.gif"), this.join, CBIntText.get("Join filters that have been made in the Build tab."));
        this.tabbedPane.addTab(CBIntText.get("Text Filter"), new ImageIcon(this.dirImages + "text.gif"), this.text, CBIntText.get("Type or paste a filter into the field in plain text."));
        this.OK.setText(CBIntText.get("Search"));
        this.display.makeHeavy();
        this.display.addln(panel);
        this.display.add(this.tabbedPane);
        this.display.makeLight();
        this.display.add(this.getButtonPanel());
        CBButton btnAttrs = new CBButton(CBIntText.get("Return Attrs"), CBIntText.get("Select Returning Attributes."));
        btnAttrs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList list = CBListSelector.getSelectedValues(SearchGUI.this.jx, SearchGUI.this.build.getAttributes(), CBIntText.get("Select Returning Attributes"), "search");
                if (list != null) {
                    SearchGUI.this.returnAttrs = list.toArray(new String[list.size()]);
                }
            }
        });
        this.setSize(550, 400);
        CBUtility.center(this, this.jx);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index = SearchGUI.this.tabbedPane.getSelectedIndex();
                if (index == 0) {
                    SearchGUI.this.filterNameTextField.setText(SearchGUI.this.buildName);
                    SearchGUI.this.setButtons(true);
                } else if (index == 1) {
                    SearchGUI.this.filterNameTextField.setText(SearchGUI.this.joinName);
                    SearchGUI.this.setButtons(true);
                } else if (index == 2) {
                    SearchGUI.this.filterNameTextField.setText(SearchGUI.this.textName);
                    SearchGUI.this.setButtons(false);
                }
            }
        });
    }

    public CBPanel getMainPanel(DN baseDN) {
        CBPanel panel = new CBPanel();
        panel.add(new JLabel(CBIntText.get("Filter Name") + ": "));
        panel.makeWide();
        this.filterNameTextField = new JTextField("Untitled");
        panel.add(this.filterNameTextField);
        panel.makeLight();
        panel.newLine();
        panel.add(new JLabel(CBIntText.get("Start Searching From") + ": "));
        panel.makeWide();
        if (baseDN == null) {
            this.baseDNTextField = new JTextField("");
            panel.add(this.baseDNTextField);
        } else {
            this.baseDNTextField = new JTextField(baseDN.toString());
            panel.add(this.baseDNTextField);
        }
        panel.makeLight();
        panel.newLine();
        CBPanel optionsPanel = new CBPanel();
        CBPanel aliasPanel = new CBPanel();
        aliasPanel.setBorder(new TitledBorder(CBIntText.get(" Alias Options ")));
        aliasPanel.makeWide();
        this.aliasSearchCheckBox = new JCheckBox(CBIntText.get("Resolve aliases while searching."));
        aliasPanel.addln(this.aliasSearchCheckBox);
        this.aliasSearchCheckBox.setToolTipText(CBIntText.get("Resolve aliases while searching."));
        this.aliasFindingCheckBox = new JCheckBox(CBIntText.get("Resolve aliases when finding base object."));
        aliasPanel.addln(this.aliasFindingCheckBox);
        this.aliasFindingCheckBox.setToolTipText(CBIntText.get("Resolve aliases when finding base object."));
        CBPanel searchLevelPanel = new CBPanel();
        searchLevelPanel.setBorder(new TitledBorder(CBIntText.get(" Search Level ")));
        searchLevelPanel.addln(new JLabel(CBIntText.get("Select Search Level:  ")));
        searchLevelPanel.makeWide();
        this.searchLevelCombo = new CBJComboBox(searchLevelArray);
        searchLevelPanel.addln(this.searchLevelCombo);
        this.searchLevelCombo.setSelectedIndex(2);
        optionsPanel.add(aliasPanel);
        optionsPanel.makeWide();
        optionsPanel.addln(searchLevelPanel);
        panel.makeWide();
        panel.addln(optionsPanel);
        CBPanel returnAttrsPanel = new CBPanel();
        this.returnAttributesCombo = new CBJComboBox(ReturnAttributesDialog.getSavedListNames());
        this.returnAttributesCombo.setSelectedItem("None");
        returnAttrsPanel.makeLight();
        returnAttrsPanel.add(new JLabel(CBIntText.get("Information to retrieve:    ")));
        returnAttrsPanel.makeWide();
        returnAttrsPanel.addln(this.returnAttributesCombo);
        panel.addln(returnAttrsPanel);
        return panel;
    }

    public void setBaseDN(DN baseDN) {
        if (baseDN != null) {
            this.baseDNTextField.setText(baseDN.toString());
        }
    }

    public CBPanel getButtonPanel() {
        CBPanel panel = new CBPanel();
        this.btnMore = new CBButton(CBIntText.get("More"), CBIntText.get("Add a Line to the search window."));
        this.btnMore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SearchGUI.this.isFilterValid()) {
                    if (SearchGUI.this.tabbedPane.getSelectedIndex() == 0) {
                        SearchGUI.this.build.addFilterRow();
                    } else if (SearchGUI.this.tabbedPane.getSelectedIndex() == 1 && SearchGUI.this.buttonCounter < 50) {
                        SearchGUI.this.join.addFilterRow(SearchGUI.this.getEditButton());
                        ++SearchGUI.this.buttonCounter;
                    }
                } else {
                    SearchGUI.this.showMessage(CBIntText.get("There is an error in the filter; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly,\nthen try to add more rows."), CBIntText.get("Missing Information"));
                }
            }
        });
        this.btnLess = new CBButton(CBIntText.get("Less"), CBIntText.get("Remove a Line from the search window."));
        this.btnLess.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SearchGUI.this.tabbedPane.getSelectedIndex() == 0) {
                    SearchGUI.this.build.removeFilterRow();
                } else if (SearchGUI.this.tabbedPane.getSelectedIndex() == 1 && SearchGUI.this.buttonCounter > 1) {
                    --SearchGUI.this.buttonCounter;
                    SearchGUI.this.join.removeFilterRow(SearchGUI.this.btnEdit[SearchGUI.this.buttonCounter]);
                }
            }
        });
        this.btnSave = new CBButton(CBIntText.get("Save"), CBIntText.get("Save this filter."));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SearchGUI.this.isFilterValid()) {
                    SearchGUI.this.save();
                } else {
                    SearchGUI.this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
                }
            }
        });
        this.btnLoad = new CBButton(CBIntText.get("Load"), CBIntText.get("Load a previously saved filter."));
        this.btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SearchGUI.this.tabbedPane.getSelectedIndex() == 0) {
                    SearchGUI.this.loadBuild();
                } else if (SearchGUI.this.tabbedPane.getSelectedIndex() == 1) {
                    SearchGUI.this.loadJoin();
                } else if (SearchGUI.this.tabbedPane.getSelectedIndex() == 2) {
                    SearchGUI.this.loadText();
                }
            }
        });
        this.btnView = new CBButton(CBIntText.get("View"), CBIntText.get("View this search filter as text."));
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!SearchGUI.this.isFilterValid()) {
                    SearchGUI.this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
                } else {
                    if (SearchGUI.this.tabbedPane.getSelectedIndex() == 1 && SearchGUI.this.recursiveFilterCheck(null, SearchGUI.this.join.getFilter(), "View")) {
                        return;
                    }
                    SearchGUI.this.showDialog(CBIntText.get("Current Filter"), SearchGUI.this.getLDAPFilter());
                }
            }
        });
        panel.makeHigh();
        panel.addln(new JLabel(" "));
        panel.makeLight();
        panel.addln(this.btnMore);
        panel.addln(this.btnLess);
        panel.addln(this.btnSave);
        panel.addln(this.btnLoad);
        panel.addln(this.btnView);
        return panel;
    }

    protected void setButtons(boolean state) {
        this.btnMore.setEnabled(state);
        this.btnLess.setEnabled(state);
        this.btnView.setEnabled(state);
    }

    protected void showDialog(String title, String filter) {
        JTextArea area = new JTextArea(filter);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(area);
        scrollPane.setPreferredSize(new Dimension(300, 60));
        scrollPane.setHorizontalScrollBarPolicy(31);
        JOptionPane.showMessageDialog(this, scrollPane, title, 1);
    }

    protected CBButton getEditButton() {
        this.btnEdit[this.buttonCounter] = new CBButton(CBIntText.get("Edit"), CBIntText.get("Edit this filter."));
        this.btnEdit[this.buttonCounter].setPreferredSize(new Dimension(55, 21));
        this.btnEdit[this.buttonCounter].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBButton item = (CBButton)e.getSource();
                for (int i = 0; i < SearchGUI.this.buttonCounter; ++i) {
                    if (item != SearchGUI.this.btnEdit[i]) continue;
                    SearchGUI.this.edit(i);
                }
            }
        });
        return this.btnEdit[this.buttonCounter];
    }

    protected void edit(int row) {
        ArrayList list = this.searchModel.getFilterNames(1);
        String filter = this.join.getFilterComboValue(row);
        if (filter == null) {
            this.showMessage(CBIntText.get("There are no filters available to edit"), CBIntText.get("Nothing to Edit"));
            return;
        }
        try {
            if (list.contains(filter)) {
                this.buildName = filter;
                this.tabbedPane.setSelectedIndex(0);
                this.build.displayFilter(this.searchModel.getFilter(filter));
            } else {
                String value = this.searchModel.getFilter(filter);
                this.setNumberOfRows(this.build.getOccurrences(this.searchModel.getFilter(filter), "JXFilter"));
                ArrayList aList = this.searchModel.getJoinFilterNames(value);
                if (!this.join.displayFilter(aList, value)) {
                    this.showMessage(CBIntText.get("Your filter cannot be edited."), CBIntText.get("Edit Unsuccessful"));
                } else {
                    this.joinName = filter;
                    this.filterNameTextField.setText(this.joinName);
                }
            }
        }
        catch (Exception e) {
            this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
            return;
        }
    }

    protected void setNumberOfRows(int rows) {
        block3: {
            block2: {
                if (this.buttonCounter <= rows) break block2;
                while (this.buttonCounter > rows) {
                    --this.buttonCounter;
                    this.join.removeFilterRow(this.btnEdit[this.buttonCounter]);
                }
                break block3;
            }
            if (this.buttonCounter >= rows) break block3;
            while (this.buttonCounter < rows) {
                this.join.addFilterRow(this.getEditButton());
                ++this.buttonCounter;
            }
        }
    }

    protected void save() {
        String name = this.filterNameTextField.getText();
        boolean exists = false;
        if (name == null || name.trim().length() <= 0 || name.equalsIgnoreCase("Untitled")) {
            this.showMessage(CBIntText.get("Please enter a name in the 'Filter Name' field for the filter that you are trying to save."), CBIntText.get("Name Required"));
            return;
        }
        if (name.startsWith("JXFilter")) {
            this.showMessage(CBIntText.get("The name ''{0}'' is a reserved name.  Please enter a different name.", new String[]{name}), CBIntText.get("Naming Error"));
            return;
        }
        if (this.searchModel.exists(name)) {
            int response = JOptionPane.showConfirmDialog(this, CBIntText.get("The name ''{0}'' already exists.  Do you want to replace it?", new String[]{name}), CBIntText.get("Select Filter"), 0);
            if (response != 0) {
                return;
            }
            exists = true;
        }
        try {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.buildName = name;
                this.searchModel.saveFilter(name, this.getLDAPFilter());
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                String filter = this.join.getFilter();
                if (this.recursiveFilterCheck(name, filter, "Save")) {
                    return;
                }
                this.joinName = name;
                this.searchModel.saveFilter(name, filter);
            } else if (this.tabbedPane.getSelectedIndex() == 2) {
                this.textName = name;
                this.searchModel.saveTextFilter(name, this.text.getFilter());
            }
        }
        catch (Exception e) {
            this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
            return;
        }
        this.save(name);
        if (!exists) {
            this.join.updateFilterCombo(name);
        }
        this.jx.getMainMenu().updateSearchMenu();
        this.showMessage(CBIntText.get("Your filter ''{0}'' was saved successfully.", new String[]{name}), CBIntText.get("Successful Save."));
    }

    protected void save(String name) {
        String baseDN = this.baseDNTextField.getText().trim().length() <= 0 ? this.jx.getTree().getRootDN().toString() : this.baseDNTextField.getText();
        this.searchModel.saveValue(name, "baseDN", baseDN);
        this.searchModel.saveValue(name, "retAttrs", this.returnAttributesCombo.getSelectedItem().toString());
        this.searchModel.saveSearchLevel(name, this.searchLevelCombo.getSelectedIndex());
        this.searchModel.saveAlias(name, "find", this.aliasFindingCheckBox.isSelected());
        this.searchModel.saveAlias(name, "search", this.aliasSearchCheckBox.isSelected());
    }

    protected void loadBuild() {
        ArrayList list = this.searchModel.getFilterNames(1);
        if (list.size() == 0) {
            this.showMessage(CBIntText.get("There are no filters available to load."), CBIntText.get("Nothing to Load"));
            return;
        }
        Object[] listOb = list.toArray();
        Arrays.sort(listOb, new SearchModel.StringComparator());
        CBJComboBox loadCombo = new CBJComboBox(listOb);
        loadCombo.setRenderer(new CBBasicComboBoxRenderer(listOb));
        loadCombo.setPreferredSize(new Dimension(140, 20));
        int response = JOptionPane.showConfirmDialog(this, loadCombo, CBIntText.get("Select Filter"), 2);
        if (response != 0) {
            return;
        }
        if (loadCombo.getSelectedItem() != null) {
            String filter = null;
            try {
                filter = this.searchModel.getFilter(loadCombo.getSelectedItem().toString());
            }
            catch (Exception e) {
                this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
                return;
            }
            if (!this.build.displayFilter(filter)) {
                this.showMessage(CBIntText.get("Your filter cannot be displayed."), CBIntText.get("Load Unsuccessful"));
            } else {
                this.buildName = loadCombo.getSelectedItem().toString();
                this.filterNameTextField.setText(this.buildName);
            }
        } else {
            this.showMessage(CBIntText.get("Problem loading; there are no filters selected."), CBIntText.get("Nothing to Load"));
        }
        this.load(loadCombo.getSelectedItem().toString());
    }

    protected void loadJoin() {
        ArrayList list = this.searchModel.getFilterNames(3);
        if (list.size() == 0) {
            this.showMessage(CBIntText.get("There are no filters available to load."), CBIntText.get("Nothing to Load"));
            return;
        }
        CBJComboBox loadCombo = new CBJComboBox(list.toArray());
        loadCombo.setRenderer(new CBBasicComboBoxRenderer(list.toArray()));
        loadCombo.setPreferredSize(new Dimension(140, 20));
        int response = JOptionPane.showConfirmDialog(this, loadCombo, CBIntText.get("Select Filter"), 2);
        if (response != 0) {
            return;
        }
        if (loadCombo.getSelectedItem() != null) {
            String filter = loadCombo.getSelectedItem().toString();
            try {
                this.setNumberOfRows(this.build.getOccurrences(this.searchModel.getFilter(filter), "JXFilter"));
                list = this.searchModel.getJoinFilterNames(this.searchModel.getFilter(filter));
                if (!this.join.displayFilter(list, this.searchModel.getFilter(filter))) {
                    this.showMessage(CBIntText.get("Your filter cannot be displayed."), CBIntText.get("Load Unsuccessful"));
                }
                this.joinName = loadCombo.getSelectedItem().toString();
                this.filterNameTextField.setText(this.joinName);
            }
            catch (Exception e) {
                this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
                return;
            }
        } else {
            this.showMessage(CBIntText.get("Problem loading; there are no filters selected."), CBIntText.get("Nothing to Load"));
        }
        this.load(loadCombo.getSelectedItem().toString());
    }

    protected void loadText() {
        ArrayList list = this.searchModel.getFilterNames(4);
        if (list.size() == 0) {
            this.showMessage(CBIntText.get("There are no filters available to load."), CBIntText.get("Nothing to Load"));
            return;
        }
        CBJComboBox loadCombo = new CBJComboBox(list.toArray());
        loadCombo.setRenderer(new CBBasicComboBoxRenderer(list.toArray()));
        loadCombo.setPreferredSize(new Dimension(140, 20));
        int response = JOptionPane.showConfirmDialog(this, loadCombo, CBIntText.get("Select Filter"), 2);
        if (response != 0) {
            return;
        }
        if (loadCombo.getSelectedItem() != null) {
            this.textName = loadCombo.getSelectedItem().toString();
            this.text.displayFilter(this.searchModel.getTextFilter(this.textName));
            this.filterNameTextField.setText(this.textName);
        } else {
            this.showMessage(CBIntText.get("Problem loading; there are no filters selected."), CBIntText.get("Nothing to Load"));
        }
        this.load(loadCombo.getSelectedItem().toString());
    }

    protected void load(String name) {
        String search;
        String find;
        String retAttrs;
        int searchLevel = 2;
        try {
            searchLevel = Integer.parseInt(this.searchModel.getValue(name + "." + "searchLevel"));
            this.searchLevelCombo.setSelectedIndex(searchLevel);
        }
        catch (NumberFormatException e) {
            this.searchLevelCombo.setSelectedIndex(2);
        }
        String dn = this.searchModel.getValue(name + "." + "baseDN");
        if (dn != null) {
            this.baseDNTextField.setText(dn);
        }
        if ((retAttrs = this.searchModel.getValue(name + "." + "retAttrs")) != null) {
            Object[] temp = ReturnAttributesDialog.getSavedListNames();
            for (int i = 0; i < temp.length; ++i) {
                if (!((String)temp[i]).equalsIgnoreCase(retAttrs)) continue;
                this.returnAttributesCombo.setSelectedItem(temp[i]);
                break;
            }
        }
        if ((find = this.searchModel.getValue(name + "." + "find")) != null) {
            if (find.equalsIgnoreCase("true")) {
                this.aliasFindingCheckBox.setSelected(true);
            } else {
                this.aliasFindingCheckBox.setSelected(false);
            }
        }
        if ((search = this.searchModel.getValue(name + "." + "search")) != null) {
            if (search.equalsIgnoreCase("true")) {
                this.aliasSearchCheckBox.setSelected(true);
            } else {
                this.aliasSearchCheckBox.setSelected(false);
            }
        }
    }

    protected boolean isFilterValid() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            return this.build.isFilterValid();
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            return this.join.isFilterValid();
        }
        if (this.tabbedPane.getSelectedIndex() == 2) {
            return this.text.isFilterValid();
        }
        return false;
    }

    protected String getLDAPFilter() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            return this.build.getFilter();
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            return this.searchModel.getJoinFilter(this.join.getFilter());
        }
        if (this.tabbedPane.getSelectedIndex() == 2) {
            return this.text.getFilter();
        }
        return "";
    }

    protected void showMessage(String message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void doOK() {
        if (this.isFilterValid()) {
            if (this.tabbedPane.getSelectedIndex() == 1 && this.recursiveFilterCheck(null, this.join.getFilter(), "Search")) {
                return;
            }
            this.setAliasOptions();
            String returnAttrs = this.returnAttributesCombo.getSelectedItem().toString();
            if (!returnAttrs.equalsIgnoreCase("None")) {
                this.closeSearchGUI();
                String[] attrNames = ReturnAttributesDialog.getReturnAttributes(returnAttrs);
                this.searchModel.openRetAttrDisplay(this.jx, attrNames, this.jx.getSearchTree().getDataSource());
                SearchExecute.run(this.jx.getSearchTree(), new DN(this.baseDNTextField.getText()), this.getLDAPFilter(), attrNames, this.searchLevelCombo.getSelectedIndex(), this.jx.getSearchBroker());
            } else {
                this.closeSearchGUI();
                SearchExecute.run(this.jx.getSearchTree(), new DN(this.baseDNTextField.getText()), this.getLDAPFilter(), new String[]{"objectClass"}, this.searchLevelCombo.getSelectedIndex(), this.jx.getSearchBroker());
            }
            this.jx.getTreeTabPane().setSelectedComponent(this.jx.getResultsPanel());
        } else {
            this.showMessage(CBIntText.get("The filter cannot be constructed; there appears to be missing information.\nPlease make sure you have entered all the information for the filter correctly."), CBIntText.get("Missing Information"));
        }
    }

    public void doCancel() {
        this.closeSearchGUI();
    }

    public void closeSearchGUI() {
        this.filterNameTextField.setText("Untitled");
        this.setVisible(false);
    }

    public void setAliasOptions() {
        String aliasOption = "always";
        if (!this.aliasSearchCheckBox.isSelected() && !this.aliasFindingCheckBox.isSelected()) {
            aliasOption = "never";
        } else if (this.aliasSearchCheckBox.isSelected() && !this.aliasFindingCheckBox.isSelected()) {
            aliasOption = "searching";
        } else if (!this.aliasSearchCheckBox.isSelected() && this.aliasFindingCheckBox.isSelected()) {
            aliasOption = "finding";
        }
        log.fine("Setting search alias option to: [" + aliasOption + "]");
        JXplorer.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
    }

    protected boolean recursiveFilterCheck(String filterName, String filter, String type) {
        if (this.recursiveFilterCheck(filterName, filter)) {
            this.showMessage(CBIntText.get("The filter you are trying to {0} is not valid.  You may be trying to construct a filter within itself which will cause an infinite loop.", new String[]{type.toLowerCase()}), CBIntText.get(type + " Error"));
            return true;
        }
        return false;
    }

    protected boolean recursiveFilterCheck(String filterName, String filter) {
        boolean recursive = false;
        ArrayList list = this.searchModel.getJoinFilterNames(filter);
        for (int i = 0; i < list.size(); ++i) {
            String temp = list.get(i).toString();
            if (filterName != null && filterName.compareTo(temp) == 0) {
                recursive = true;
                break;
            }
            String value = this.searchModel.getFilter(temp);
            if (value != null && value.indexOf("JXFilter") != -1) {
                recursive = this.recursiveFilterCheck(filterName, value);
            }
            if (!recursive) continue;
            return true;
        }
        return recursive;
    }
}

