/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionAuthTokenProvider;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.JvmPlatform;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.persistence.NoopPersistenceManager;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.utilities.DefaultRunLoop;
import java.util.concurrent.ScheduledExecutorService;

public class Context {
    private static final long DEFAULT_CACHE_SIZE = 0xA00000L;
    FirebaseApp firebaseApp;
    EventTarget eventTarget;
    AuthTokenProvider authTokenProvider;
    RunLoop runLoop;
    String persistenceKey;
    boolean persistenceEnabled;
    long cacheSize = 0xA00000L;
    private String userAgent;
    private boolean frozen = false;
    private boolean stopped = false;
    private Platform platform;

    private static ConnectionAuthTokenProvider wrapAuthTokenProvider(final AuthTokenProvider provider) {
        return new ConnectionAuthTokenProvider(){

            @Override
            public void getToken(boolean forceRefresh, final ConnectionAuthTokenProvider.GetTokenCallback callback) {
                provider.getToken(forceRefresh, new AuthTokenProvider.GetTokenCompletionListener(){

                    @Override
                    public void onSuccess(String token) {
                        callback.onSuccess(token);
                    }

                    @Override
                    public void onError(String error) {
                        callback.onError(error);
                    }
                });
            }
        };
    }

    private Platform getPlatform() {
        if (this.platform == null) {
            this.platform = new JvmPlatform(this.firebaseApp);
        }
        return this.platform;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    synchronized void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            this.initServices();
        }
    }

    public void requireStarted() {
        if (this.stopped) {
            this.restartServices();
            this.stopped = false;
        }
    }

    private void initServices() {
        this.getPlatform();
        this.ensureUserAgent();
        this.ensureEventTarget();
        this.ensureRunLoop();
        this.ensureSessionIdentifier();
        this.ensureAuthTokenProvider();
    }

    private void restartServices() {
        this.eventTarget.restart();
        this.runLoop.restart();
    }

    void stop() {
        this.stopped = true;
        if (this.eventTarget != null) {
            this.eventTarget.shutdown();
        }
        if (this.runLoop != null) {
            this.runLoop.shutdown();
        }
    }

    void assertUnfrozen() {
        if (this.frozen) {
            throw new DatabaseException("Modifications to DatabaseConfig objects must occur before they are in use");
        }
    }

    public ConnectionContext getConnectionContext() {
        return new ConnectionContext(Context.wrapAuthTokenProvider(this.getAuthTokenProvider()), this.getExecutorService(), this.isPersistenceEnabled(), FirebaseDatabase.getSdkVersion(), this.getUserAgent(), ImplFirebaseTrampolines.getThreadFactory(this.firebaseApp));
    }

    PersistenceManager getPersistenceManager(String firebaseId) {
        if (this.persistenceEnabled) {
            PersistenceManager cache = this.platform.createPersistenceManager(this, firebaseId);
            if (cache == null) {
                throw new IllegalArgumentException("You have enabled persistence, but persistence is not supported on this platform.");
            }
            return cache;
        }
        return new NoopPersistenceManager();
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public long getPersistenceCacheSizeBytes() {
        return this.cacheSize;
    }

    public EventTarget getEventTarget() {
        return this.eventTarget;
    }

    public RunLoop getRunLoop() {
        return this.runLoop;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public AuthTokenProvider getAuthTokenProvider() {
        return this.authTokenProvider;
    }

    public PersistentConnection newPersistentConnection(HostInfo info, PersistentConnection.Delegate delegate) {
        return this.getPlatform().newPersistentConnection(this, this.getConnectionContext(), info, delegate);
    }

    private ScheduledExecutorService getExecutorService() {
        RunLoop loop = this.getRunLoop();
        if (!(loop instanceof DefaultRunLoop)) {
            throw new RuntimeException("Custom run loops are not supported!");
        }
        return ((DefaultRunLoop)loop).getExecutorService();
    }

    private void ensureRunLoop() {
        if (this.runLoop == null) {
            this.runLoop = this.platform.newRunLoop(this);
        }
    }

    private void ensureEventTarget() {
        if (this.eventTarget == null) {
            this.eventTarget = this.getPlatform().newEventTarget(this);
        }
    }

    private void ensureUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = this.buildUserAgent(this.getPlatform().getUserAgent(this));
        }
    }

    private void ensureAuthTokenProvider() {
        if (this.authTokenProvider == null) {
            this.authTokenProvider = this.getPlatform().newAuthTokenProvider(this.getExecutorService());
        }
    }

    private void ensureSessionIdentifier() {
        if (this.persistenceKey == null) {
            this.persistenceKey = "default";
        }
    }

    private String buildUserAgent(String platformAgent) {
        StringBuilder sb = new StringBuilder().append("Firebase/").append("5").append("/").append(FirebaseDatabase.getSdkVersion()).append("/").append(platformAgent);
        return sb.toString();
    }

    public void setCustomCredentials(GoogleCredentials customCredentials, boolean autoRefresh) {
        this.getPlatform();
        this.ensureRunLoop();
        this.authTokenProvider = new JvmAuthTokenProvider(this.firebaseApp, this.getExecutorService(), autoRefresh, customCredentials);
    }
}

