/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.MastersReplicasListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;

public class MastersReplicasProtocol
extends MasterProtocol {
    protected boolean masterConnection = false;
    private boolean mustBeMasterConnection = false;

    public MastersReplicasProtocol(UrlParser url, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        super(url, globalInfo, lock, traceCache);
    }

    public static void loop(MastersReplicasListener listener, GlobalStateInfo globalInfo, List<HostAddress> addresses, SearchFilter searchFilter) throws SQLException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(addresses);
        if (loopAddresses.isEmpty()) {
            MastersReplicasProtocol.resetHostList(listener, loopAddresses);
        }
        int maxConnectionTry = listener.getRetriesAllDown();
        SQLException lastQueryException = null;
        boolean firstLoop = true;
        while (!loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
            MastersReplicasProtocol protocol = MastersReplicasProtocol.getNewProtocol(listener.getProxy(), globalInfo, listener.getUrlParser());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFailReconnect() && !listener.isMasterHostFailReconnect()) {
                return;
            }
            --maxConnectionTry;
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                    if (MastersReplicasProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (listener.isSecondaryHostFailReconnect() && !protocol.isMasterConnection()) {
                    if (MastersReplicasProtocol.foundSecondary(listener, protocol, searchFilter)) {
                        return;
                    }
                } else {
                    protocol.close();
                }
            }
            catch (SQLException e) {
                lastQueryException = e;
                listener.addToBlacklist(protocol.getHostAddress());
            }
            if (!listener.isMasterHostFailReconnect() && !listener.isSecondaryHostFailReconnect()) {
                return;
            }
            if (loopAddresses.isEmpty() && listener.isMasterHostFailReconnect() && listener.urlParser.getOptions().allowMasterDownConnection && !listener.isSecondaryHostFailReconnect()) {
                return;
            }
            if (loopAddresses.isEmpty() && searchFilter.isInitialConnection() && !listener.isMasterHostFailReconnect()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
            MastersReplicasProtocol.resetHostList(listener, loopAddresses);
            if (firstLoop) {
                firstLoop = false;
                continue;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        if (listener.isMasterHostFailReconnect() || listener.isSecondaryHostFailReconnect()) {
            String error = "No active connection found for replica";
            if (listener.isMasterHostFailReconnect()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new SQLException(error + " : " + lastQueryException.getMessage(), lastQueryException.getSQLState(), lastQueryException.getErrorCode(), lastQueryException);
            }
            throw new SQLException(error);
        }
    }

    private static void resetHostList(MastersReplicasListener listener, Deque<HostAddress> loopAddresses) {
        ArrayList<HostAddress> servers = new ArrayList<HostAddress>();
        servers.addAll(listener.getUrlParser().getHostAddresses());
        Collections.shuffle(servers);
        servers.removeAll(listener.connectedHosts());
        loopAddresses.clear();
        loopAddresses.addAll(servers);
    }

    protected static boolean foundMaster(MastersReplicasListener listener, MastersReplicasProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        if (listener.isMasterHostFailReconnect()) {
            listener.foundActiveMaster(protocol);
        } else {
            protocol.close();
        }
        if (!listener.isSecondaryHostFailReconnect()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFailReconnect();
    }

    protected static boolean foundSecondary(MastersReplicasListener listener, MastersReplicasProtocol protocol, SearchFilter searchFilter) throws SQLException {
        protocol.setMustBeMasterConnection(false);
        if (listener.isSecondaryHostFailReconnect()) {
            listener.foundActiveSecondary(protocol);
        } else {
            protocol.close();
        }
        if (!listener.isMasterHostFailReconnect()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyReplica() || !listener.isMasterHostFailReconnect();
    }

    private static MastersReplicasProtocol getNewProtocol(FailoverProxy proxy, GlobalStateInfo globalInfo, UrlParser urlParser) {
        MastersReplicasProtocol newProtocol = new MastersReplicasProtocol(urlParser, globalInfo, proxy.lock, proxy.traceCache);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean mustBeMasterConnection() {
        return this.mustBeMasterConnection;
    }

    public void setMustBeMasterConnection(boolean mustBeMasterConnection) {
        this.mustBeMasterConnection = mustBeMasterConnection;
    }
}

