/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Language;
import gnu.expr.Mangling;
import gnu.expr.PrimProcedure;
import gnu.mapping.MethodProc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import kawa.SourceMethodType;

public class CompiledProc
extends MethodProc {
    protected int numArgs;
    private Object module;

    public Object getModule() {
        return this.module;
    }

    public Class getModuleClass() {
        try {
            return MethodHandles.lookup().revealDirect(this.getApplyMethod()).getDeclaringClass();
        }
        catch (Exception exception) {
            if (this.module == null || this.module instanceof Class) {
                return (Class)this.module;
            }
            return this.module.getClass();
        }
    }

    public CompiledProc(Object module, boolean resultGoesToConsumer, MethodHandle applyMethod, Object name, int numArgs) {
        this.init(resultGoesToConsumer, applyMethod, name, numArgs);
        this.module = module;
    }

    public CompiledProc(boolean resultGoesToConsumer, MethodHandle applyMethod, Object name, int numArgs, Object argTypes) {
        this.init(resultGoesToConsumer, applyMethod, name, numArgs);
        this.argTypes = argTypes;
    }

    public static CompiledProc makeResultToObject(Object module, MethodHandle applyMethod, Object name, int numArgs) {
        return new CompiledProc(module, false, applyMethod, name, numArgs);
    }

    public static CompiledProc makeResultToConsumer(Object module, MethodHandle applyMethod, Object name, int numArgs) {
        return new CompiledProc(module, true, applyMethod, name, numArgs);
    }

    public void initResultToObject(Object module, MethodHandle applyMethod, Object name, int numArgs) {
        this.init(false, applyMethod, name, numArgs);
        this.module = module;
    }

    public void initResultToConsumer(Object module, MethodHandle applyMethod, Object name, int numArgs) {
        this.init(true, applyMethod, name, numArgs);
        this.module = module;
    }

    public CompiledProc init(boolean resultGoesToConsumer, MethodHandle applyMethod, Object name, int numArgs) {
        if (resultGoesToConsumer) {
            this.applyToConsumerMethod = applyMethod;
            this.applyToObjectMethod = applyToObjectDefault;
        } else {
            this.applyToObjectMethod = applyMethod;
            this.applyToConsumerMethod = applyToConsumerDefault;
        }
        this.numArgs = numArgs;
        if (name != null) {
            this.setSymbol(name);
        }
        return this;
    }

    @Override
    protected void resolveParameterTypes() {
        block9: {
            Method method = null;
            String name = this.getName();
            if (name != null) {
                try {
                    String[] annotTypes;
                    Language lang;
                    Class moduleClass = this.getModuleClass();
                    Method[] methods = moduleClass.getDeclaredMethods();
                    String mangledName = Mangling.mangleMethod(name);
                    int i = methods.length;
                    while (--i >= 0) {
                        if (!methods[i].getName().equals(mangledName)) continue;
                        if (method != null) {
                            method = null;
                            break;
                        }
                        method = methods[i];
                    }
                    if (method == null || (lang = Language.getDefaultLanguage()) == null) break block9;
                    Class<?>[] parameterClasses = method.getParameterTypes();
                    int numParamTypes = parameterClasses.length;
                    Type[] atypes = new Type[numParamTypes];
                    try {
                        SourceMethodType sourceType = method.getAnnotation(SourceMethodType.class);
                        annotTypes = sourceType == null ? null : sourceType.value();
                    }
                    catch (Throwable ex) {
                        annotTypes = null;
                    }
                    int i2 = numParamTypes;
                    while (--i2 >= 0) {
                        atypes[i2] = lang.getTypeFor(parameterClasses[i2]);
                        if (annotTypes == null) continue;
                        atypes[i2] = PrimProcedure.decodeType(atypes[i2], annotTypes, i2 + 1, null, lang);
                    }
                    this.argTypes = atypes;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.argTypes == null) {
            super.resolveParameterTypes();
        }
    }

    @Override
    public int numArgs() {
        return this.numArgs;
    }
}

