require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/types.ph';
require 'sys/queue.ph';
require 'machine/bus.ph';
require 'dev/pcmcia/pcmciachip.ph';
eval 'sub PCMCIA_IO_ALLOCATED () {0x1;}' unless defined(&PCMCIA_IO_ALLOCATED);
eval 'sub PCMCIA_CFE_MWAIT_REQUIRED () {0x1;}' unless defined(&PCMCIA_CFE_MWAIT_REQUIRED);
eval 'sub PCMCIA_CFE_RDYBSY_ACTIVE () {0x2;}' unless defined(&PCMCIA_CFE_RDYBSY_ACTIVE);
eval 'sub PCMCIA_CFE_WP_ACTIVE () {0x4;}' unless defined(&PCMCIA_CFE_WP_ACTIVE);
eval 'sub PCMCIA_CFE_BVD_ACTIVE () {0x8;}' unless defined(&PCMCIA_CFE_BVD_ACTIVE);
eval 'sub PCMCIA_CFE_IO8 () {0x10;}' unless defined(&PCMCIA_CFE_IO8);
eval 'sub PCMCIA_CFE_IO16 () {0x20;}' unless defined(&PCMCIA_CFE_IO16);
eval 'sub PCMCIA_CFE_IRQSHARE () {0x40;}' unless defined(&PCMCIA_CFE_IRQSHARE);
eval 'sub PCMCIA_CFE_IRQPULSE () {0x80;}' unless defined(&PCMCIA_CFE_IRQPULSE);
eval 'sub PCMCIA_CFE_IRQLEVEL () {0x100;}' unless defined(&PCMCIA_CFE_IRQLEVEL);
eval 'sub PCMCIA_CFE_POWERDOWN () {0x200;}' unless defined(&PCMCIA_CFE_POWERDOWN);
eval 'sub PCMCIA_CFE_READONLY () {0x400;}' unless defined(&PCMCIA_CFE_READONLY);
eval 'sub PCMCIA_CFE_AUDIO () {0x800;}' unless defined(&PCMCIA_CFE_AUDIO);
eval 'sub pf_ccrt () { ($pf_pcmh->{memt});}' unless defined(&pf_ccrt);
eval 'sub pf_ccrh () { ($pf_pcmh->{memh});}' unless defined(&pf_ccrh);
eval 'sub pf_ccr_mhandle () { ($pf_pcmh->{mhandle});}' unless defined(&pf_ccr_mhandle);
eval 'sub pf_ccr_realsize () { ($pf_pcmh->{realsize});}' unless defined(&pf_ccr_realsize);
eval 'sub PFF_ENABLED () {0x1;}' unless defined(&PFF_ENABLED);
eval 'sub PFF_FAKE () {0x2;}' unless defined(&PFF_FAKE);
eval 'sub PCMCIA_VENDOR_INVALID () {0xffff;}' unless defined(&PCMCIA_VENDOR_INVALID);
eval 'sub PCMCIA_PRODUCT_INVALID () {0xffff;}' unless defined(&PCMCIA_PRODUCT_INVALID);
eval 'sub PCMCIA_CIS_INVALID () {{  &NULL,  &NULL,  &NULL,  &NULL };}' unless defined(&PCMCIA_CIS_INVALID);
eval 'sub PTF_INDIRECT () {0x1;}' unless defined(&PTF_INDIRECT);
unless(defined(&pcmcia_tuple_read_1)) {
    sub pcmcia_tuple_read_1 {
	my($tuple, $idx1) = @_;
	eval q(( &pcmcia_cis_read_1(($tuple), (($tuple)-> &ptr+(2+($idx1))))));
    }
}
unless(defined(&pcmcia_tuple_read_2)) {
    sub pcmcia_tuple_read_2 {
	my($tuple, $idx2) = @_;
	eval q(( &pcmcia_tuple_read_1(($tuple), ($idx2)) | ( &pcmcia_tuple_read_1(($tuple), ($idx2)+1)<<8)));
    }
}
unless(defined(&pcmcia_tuple_read_3)) {
    sub pcmcia_tuple_read_3 {
	my($tuple, $idx3) = @_;
	eval q(( &pcmcia_tuple_read_1(($tuple), ($idx3)) | ( &pcmcia_tuple_read_1(($tuple), ($idx3)+1)<<8) | ( &pcmcia_tuple_read_1(($tuple), ($idx3)+2)<<16)));
    }
}
unless(defined(&pcmcia_tuple_read_4)) {
    sub pcmcia_tuple_read_4 {
	my($tuple, $idx4) = @_;
	eval q(( &pcmcia_tuple_read_1(($tuple), ($idx4)) | ( &pcmcia_tuple_read_1(($tuple), ($idx4)+1)<<8) | ( &pcmcia_tuple_read_1(($tuple), ($idx4)+2)<<16) | ( &pcmcia_tuple_read_1(($tuple), ($idx4)+3)<<24)));
    }
}
unless(defined(&pcmcia_tuple_read_n)) {
    sub pcmcia_tuple_read_n {
	my($tuple, $n, $idxn) = @_;
	eval q(((($n)==1)? &pcmcia_tuple_read_1(($tuple), ($idxn)) : ((($n)==2)? &pcmcia_tuple_read_2(($tuple), ($idxn)) : ((($n)==3)? &pcmcia_tuple_read_3(($tuple), ($idxn)) :  &pcmcia_tuple_read_4(($tuple), ($idxn))))));
    }
}
eval 'sub PCMCIA_SPACE_MEMORY () {1;}' unless defined(&PCMCIA_SPACE_MEMORY);
eval 'sub PCMCIA_SPACE_IO () {2;}' unless defined(&PCMCIA_SPACE_IO);
unless(defined(&pcmcia_mfc)) {
    sub pcmcia_mfc {
	my($sc) = @_;
	eval q(( &SIMPLEQ_FIRST(($sc)-> ($card->{pf_head}))  &&  &SIMPLEQ_NEXT( &SIMPLEQ_FIRST(($sc)-> ($card->{pf_head})),  &pf_list)));
    }
}
unless(defined(&pcmcia_io_alloc)) {
    sub pcmcia_io_alloc {
	my($pf, $start, $size, $align, $pciop) = @_;
	eval q(( &pcmcia_chip_io_alloc(($pf)-> ($sc->{pct}),  ($pf->{sc}->{pch}), ($start), ($size), ($align), ($pciop))));
    }
}
unless(defined(&pcmcia_io_unmap)) {
    sub pcmcia_io_unmap {
	my($pf, $window) = @_;
	eval q(( &pcmcia_chip_io_unmap(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($window))));
    }
}
unless(defined(&pcmcia_io_free)) {
    sub pcmcia_io_free {
	my($pf, $pciop) = @_;
	eval q(( &pcmcia_chip_io_free(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($pciop))));
    }
}
unless(defined(&pcmcia_mem_alloc)) {
    sub pcmcia_mem_alloc {
	my($pf, $size, $pcmhp) = @_;
	eval q(( &pcmcia_chip_mem_alloc(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($size), ($pcmhp))));
    }
}
unless(defined(&pcmcia_mem_free)) {
    sub pcmcia_mem_free {
	my($pf, $pcmhp) = @_;
	eval q(( &pcmcia_chip_mem_free(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($pcmhp))));
    }
}
unless(defined(&pcmcia_mem_map)) {
    sub pcmcia_mem_map {
	my($pf, $kind, $card_addr, $size, $pcmhp, $offsetp, $windowp) = @_;
	eval q(( &pcmcia_chip_mem_map(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($kind), ($card_addr), ($size), ($pcmhp), ($offsetp), ($windowp))));
    }
}
unless(defined(&pcmcia_mem_unmap)) {
    sub pcmcia_mem_unmap {
	my($pf, $window) = @_;
	eval q(( &pcmcia_chip_mem_unmap(($pf)-> ($sc->{pct}), ($pf)-> ($sc->{pch}), ($window))));
    }
}
1;
