require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_VIDEOMODE_EDIDREG_H)) {
    eval 'sub _DEV_VIDEOMODE_EDIDREG_H () {1;}' unless defined(&_DEV_VIDEOMODE_EDIDREG_H);
    eval 'sub EDID_OFFSET_SIGNATURE () {0x;}' unless defined(&EDID_OFFSET_SIGNATURE);
    eval 'sub EDID_OFFSET_MANUFACTURER_ID () {0x8;}' unless defined(&EDID_OFFSET_MANUFACTURER_ID);
    eval 'sub EDID_OFFSET_PRODUCT_ID () {0xa;}' unless defined(&EDID_OFFSET_PRODUCT_ID);
    eval 'sub EDID_OFFSET_SERIAL_NUMBER () {0xc;}' unless defined(&EDID_OFFSET_SERIAL_NUMBER);
    eval 'sub EDID_OFFSET_MANUFACTURE_WEEK () {0x10;}' unless defined(&EDID_OFFSET_MANUFACTURE_WEEK);
    eval 'sub EDID_OFFSET_MANUFACTURE_YEAR () {0x11;}' unless defined(&EDID_OFFSET_MANUFACTURE_YEAR);
    eval 'sub EDID_OFFSET_VERSION () {0x12;}' unless defined(&EDID_OFFSET_VERSION);
    eval 'sub EDID_OFFSET_REVISION () {0x13;}' unless defined(&EDID_OFFSET_REVISION);
    eval 'sub EDID_OFFSET_VIDEO_INPUT () {0x14;}' unless defined(&EDID_OFFSET_VIDEO_INPUT);
    eval 'sub EDID_OFFSET_MAX_HSIZE () {0x15;}' unless defined(&EDID_OFFSET_MAX_HSIZE);
    eval 'sub EDID_OFFSET_MAX_VSIZE () {0x16;}' unless defined(&EDID_OFFSET_MAX_VSIZE);
    eval 'sub EDID_OFFSET_GAMMA () {0x17;}' unless defined(&EDID_OFFSET_GAMMA);
    eval 'sub EDID_OFFSET_FEATURE () {0x18;}' unless defined(&EDID_OFFSET_FEATURE);
    eval 'sub EDID_OFFSET_CHROMA () {0x19;}' unless defined(&EDID_OFFSET_CHROMA);
    eval 'sub EDID_OFFSET_EST_TIMING_1 () {0x23;}' unless defined(&EDID_OFFSET_EST_TIMING_1);
    eval 'sub EDID_OFFSET_EST_TIMING_2 () {0x24;}' unless defined(&EDID_OFFSET_EST_TIMING_2);
    eval 'sub EDID_OFFSET_MFG_TIMING () {0x25;}' unless defined(&EDID_OFFSET_MFG_TIMING);
    eval 'sub EDID_OFFSET_STD_TIMING () {0x26;}' unless defined(&EDID_OFFSET_STD_TIMING);
    eval 'sub EDID_OFFSET_DESC_BLOCK () {0x36;}' unless defined(&EDID_OFFSET_DESC_BLOCK);
    eval 'sub EDID_SIGNATURE () {{ 0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0};}' unless defined(&EDID_SIGNATURE);
    eval 'sub EDID_VENDOR_ID {
        my($ptr) = @_;
	    eval q((((($ptr)[8]) << 8) + $ptr->[9]));
    }' unless defined(&EDID_VENDOR_ID);
    eval 'sub EDID_MANFID_0 {
        my($x) = @_;
	    eval q((((($x) >> 10) & 0x1f) + ord(\'@\')));
    }' unless defined(&EDID_MANFID_0);
    eval 'sub EDID_MANFID_1 {
        my($x) = @_;
	    eval q((((($x) >> 5) & 0x1f) + ord(\'@\')));
    }' unless defined(&EDID_MANFID_1);
    eval 'sub EDID_MANFID_2 {
        my($x) = @_;
	    eval q((((($x) >> 0) & 0x1f) + ord(\'@\')));
    }' unless defined(&EDID_MANFID_2);
    eval 'sub EDID_PRODUCT_ID {
        my($ptr) = @_;
	    eval q(((($ptr)[10]) | ((($ptr)[11]) << 8)));
    }' unless defined(&EDID_PRODUCT_ID);
    eval 'sub EDID_SERIAL_NUMBER {
        my($ptr) = @_;
	    eval q(((($ptr)[12] << 24) + (($ptr)[13] << 16) + (($ptr)[14] << 8) + ($ptr)[15]));
    }' unless defined(&EDID_SERIAL_NUMBER);
    eval 'sub EDID_WEEK {
        my($ptr) = @_;
	    eval q((($ptr)[16]));
    }' unless defined(&EDID_WEEK);
    eval 'sub EDID_YEAR {
        my($ptr) = @_;
	    eval q(((($ptr)[17]) + 1990));
    }' unless defined(&EDID_YEAR);
    eval 'sub EDID_VERSION {
        my($ptr) = @_;
	    eval q((($ptr)[18]));
    }' unless defined(&EDID_VERSION);
    eval 'sub EDID_REVISION {
        my($ptr) = @_;
	    eval q((($ptr)[19]));
    }' unless defined(&EDID_REVISION);
    eval 'sub EDID_VIDEO_INPUT {
        my($ptr) = @_;
	    eval q((($ptr)[20]));
    }' unless defined(&EDID_VIDEO_INPUT);
    eval 'sub EDID_VIDEO_INPUT_DIGITAL () {0x80;}' unless defined(&EDID_VIDEO_INPUT_DIGITAL);
    eval 'sub EDID_VIDEO_INPUT_DFP1_COMPAT () {0x1;}' unless defined(&EDID_VIDEO_INPUT_DFP1_COMPAT);
    eval 'sub EDID_VIDEO_INPUT_BLANK_TO_BLACK () {0x10;}' unless defined(&EDID_VIDEO_INPUT_BLANK_TO_BLACK);
    eval 'sub EDID_VIDEO_INPUT_SEPARATE_SYNCS () {0x8;}' unless defined(&EDID_VIDEO_INPUT_SEPARATE_SYNCS);
    eval 'sub EDID_VIDEO_INPUT_COMPOSITE_SYNC () {0x4;}' unless defined(&EDID_VIDEO_INPUT_COMPOSITE_SYNC);
    eval 'sub EDID_VIDEO_INPUT_SYNC_ON_GRN () {0x2;}' unless defined(&EDID_VIDEO_INPUT_SYNC_ON_GRN);
    eval 'sub EDID_VIDEO_INPUT_SERRATION () {0x1;}' unless defined(&EDID_VIDEO_INPUT_SERRATION);
    eval 'sub EDID_VIDEO_INPUT_LEVEL {
        my($x) = @_;
	    eval q(((($x) & 0x60) >> 5));
    }' unless defined(&EDID_VIDEO_INPUT_LEVEL);
    eval 'sub EDID_MAX_HSIZE {
        my($ptr) = @_;
	    eval q((($ptr)[21]));
    }' unless defined(&EDID_MAX_HSIZE);
    eval 'sub EDID_MAX_VSIZE {
        my($ptr) = @_;
	    eval q((($ptr)[22]));
    }' unless defined(&EDID_MAX_VSIZE);
    eval 'sub _GAMMA {
        my($x) = @_;
	    eval q((($x) == 0xff ? 100: (($x) + 100)));
    }' unless defined(&_GAMMA);
    eval 'sub EDID_GAMMA {
        my($ptr) = @_;
	    eval q( &_GAMMA($ptr->[23]));
    }' unless defined(&EDID_GAMMA);
    eval 'sub EDID_FEATURES {
        my($ptr) = @_;
	    eval q((($ptr)[24]));
    }' unless defined(&EDID_FEATURES);
    eval 'sub EDID_FEATURES_STANDBY () {0x80;}' unless defined(&EDID_FEATURES_STANDBY);
    eval 'sub EDID_FEATURES_SUSPEND () {0x40;}' unless defined(&EDID_FEATURES_SUSPEND);
    eval 'sub EDID_FEATURES_ACTIVE_OFF () {0x20;}' unless defined(&EDID_FEATURES_ACTIVE_OFF);
    eval 'sub EDID_FEATURES_DISP_TYPE {
        my($x) = @_;
	    eval q(((($x) & 0x18) >> 3));
    }' unless defined(&EDID_FEATURES_DISP_TYPE);
    eval 'sub EDID_FEATURES_DISP_TYPE_MONO () {0;}' unless defined(&EDID_FEATURES_DISP_TYPE_MONO);
    eval 'sub EDID_FEATURES_DISP_TYPE_RGB () {1;}' unless defined(&EDID_FEATURES_DISP_TYPE_RGB);
    eval 'sub EDID_FEATURES_DISP_TYPE_NON_RGB () {2;}' unless defined(&EDID_FEATURES_DISP_TYPE_NON_RGB);
    eval 'sub EDID_FEATURES_DISP_TYPE_UNDEFINED () {3;}' unless defined(&EDID_FEATURES_DISP_TYPE_UNDEFINED);
    eval 'sub EDID_FEATURES_STD_COLOR () {0x4;}' unless defined(&EDID_FEATURES_STD_COLOR);
    eval 'sub EDID_FEATURES_PREFERRED_TIMING () {0x2;}' unless defined(&EDID_FEATURES_PREFERRED_TIMING);
    eval 'sub EDID_FEATURES_DEFAULT_GTF () {0x1;}' unless defined(&EDID_FEATURES_DEFAULT_GTF);
    eval 'sub _CHLO {
        my($byt, $shft) = @_;
	    eval q(((($byt) >> ($shft)) & 0x3));
    }' unless defined(&_CHLO);
    eval 'sub _CHHI {
        my($byt) = @_;
	    eval q((($byt) << 2));
    }' unless defined(&_CHHI);
    eval 'sub _CHHILO {
        my($ptr, $l, $s, $h) = @_;
	    eval q(( &_CHLO(($ptr)[$l], $s) |  &_CHHI(($ptr)[$h])));
    }' unless defined(&_CHHILO);
    eval 'sub _CHROMA {
        my($ptr, $l, $s, $h) = @_;
	    eval q((( &_CHHILO($ptr, $l, $s, $h) * 1000) / 1024));
    }' unless defined(&_CHROMA);
    eval 'sub EDID_CHROMA_REDX {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 25, 6, 27)));
    }' unless defined(&EDID_CHROMA_REDX);
    eval 'sub EDID_CHROMA_REDY {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 25, 4, 28)));
    }' unless defined(&EDID_CHROMA_REDY);
    eval 'sub EDID_CHROMA_GREENX {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 25, 2, 29)));
    }' unless defined(&EDID_CHROMA_GREENX);
    eval 'sub EDID_CHROMA_GREENY {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 25, 0, 30)));
    }' unless defined(&EDID_CHROMA_GREENY);
    eval 'sub EDID_CHROMA_BLUEX {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 26, 6, 31)));
    }' unless defined(&EDID_CHROMA_BLUEX);
    eval 'sub EDID_CHROMA_BLUEY {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 26, 4, 32)));
    }' unless defined(&EDID_CHROMA_BLUEY);
    eval 'sub EDID_CHROMA_WHITEX {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 26, 2, 33)));
    }' unless defined(&EDID_CHROMA_WHITEX);
    eval 'sub EDID_CHROMA_WHITEY {
        my($ptr) = @_;
	    eval q(( &_CHROMA($ptr, 26, 0, 34)));
    }' unless defined(&EDID_CHROMA_WHITEY);
    eval 'sub EDID_EST_TIMING {
        my($ptr) = @_;
	    eval q(((($ptr)[35] << 8) | ($ptr)[36]));
    }' unless defined(&EDID_EST_TIMING);
    eval 'sub EDID_EST_TIMING_720_400_70 () {0x8000;}' unless defined(&EDID_EST_TIMING_720_400_70);
    eval 'sub EDID_EST_TIMING_720_400_88 () {0x4000;}' unless defined(&EDID_EST_TIMING_720_400_88);
    eval 'sub EDID_EST_TIMING_640_480_60 () {0x2000;}' unless defined(&EDID_EST_TIMING_640_480_60);
    eval 'sub EDID_EST_TIMING_640_480_67 () {0x1000;}' unless defined(&EDID_EST_TIMING_640_480_67);
    eval 'sub EDID_EST_TIMING_640_480_72 () {0x800;}' unless defined(&EDID_EST_TIMING_640_480_72);
    eval 'sub EDID_EST_TIMING_640_480_75 () {0x400;}' unless defined(&EDID_EST_TIMING_640_480_75);
    eval 'sub EDID_EST_TIMING_800_600_56 () {0x200;}' unless defined(&EDID_EST_TIMING_800_600_56);
    eval 'sub EDID_EST_TIMING_800_600_60 () {0x100;}' unless defined(&EDID_EST_TIMING_800_600_60);
    eval 'sub EDID_EST_TIMING_800_600_72 () {0x80;}' unless defined(&EDID_EST_TIMING_800_600_72);
    eval 'sub EDID_EST_TIMING_800_600_75 () {0x40;}' unless defined(&EDID_EST_TIMING_800_600_75);
    eval 'sub EDID_EST_TIMING_832_624_75 () {0x20;}' unless defined(&EDID_EST_TIMING_832_624_75);
    eval 'sub EDID_EST_TIMING_1024_768_87I () {0x10;}' unless defined(&EDID_EST_TIMING_1024_768_87I);
    eval 'sub EDID_EST_TIMING_1024_768_60 () {0x8;}' unless defined(&EDID_EST_TIMING_1024_768_60);
    eval 'sub EDID_EST_TIMING_1024_768_70 () {0x4;}' unless defined(&EDID_EST_TIMING_1024_768_70);
    eval 'sub EDID_EST_TIMING_1024_768_75 () {0x2;}' unless defined(&EDID_EST_TIMING_1024_768_75);
    eval 'sub EDID_EST_TIMING_1280_1024_75 () {0x1;}' unless defined(&EDID_EST_TIMING_1280_1024_75);
    eval 'sub EDID_STD_TIMING_HRES {
        my($ptr) = @_;
	    eval q((((($ptr)[0]) * 8) + 248));
    }' unless defined(&EDID_STD_TIMING_HRES);
    eval 'sub EDID_STD_TIMING_VFREQ {
        my($ptr) = @_;
	    eval q((((($ptr)[1]) & 0x3f) + 60));
    }' unless defined(&EDID_STD_TIMING_VFREQ);
    eval 'sub EDID_STD_TIMING_RATIO {
        my($ptr) = @_;
	    eval q((($ptr)[1] & 0xc0));
    }' unless defined(&EDID_STD_TIMING_RATIO);
    eval 'sub EDID_STD_TIMING_RATIO_16_10 () {0x;}' unless defined(&EDID_STD_TIMING_RATIO_16_10);
    eval 'sub EDID_STD_TIMING_RATIO_4_3 () {0x40;}' unless defined(&EDID_STD_TIMING_RATIO_4_3);
    eval 'sub EDID_STD_TIMING_RATIO_5_4 () {0x80;}' unless defined(&EDID_STD_TIMING_RATIO_5_4);
    eval 'sub EDID_STD_TIMING_RATIO_16_9 () {0xc0;}' unless defined(&EDID_STD_TIMING_RATIO_16_9);
    eval 'sub EDID_STD_TIMING_SIZE () {16;}' unless defined(&EDID_STD_TIMING_SIZE);
    eval 'sub EDID_STD_TIMING_COUNT () {8;}' unless defined(&EDID_STD_TIMING_COUNT);
    eval 'sub EDID_BLOCK_SIZE () {18;}' unless defined(&EDID_BLOCK_SIZE);
    eval 'sub EDID_BLOCK_COUNT () {4;}' unless defined(&EDID_BLOCK_COUNT);
    eval 'sub EDID_BLOCK_IS_DET_TIMING {
        my($ptr) = @_;
	    eval q((($ptr)[0] | ($ptr)[1]));
    }' unless defined(&EDID_BLOCK_IS_DET_TIMING);
    eval 'sub EDID_DET_TIMING_DOT_CLOCK {
        my($ptr) = @_;
	    eval q(((($ptr)[0] | (($ptr)[1] << 8)) * 10000));
    }' unless defined(&EDID_DET_TIMING_DOT_CLOCK);
    eval 'sub _HACT_LO {
        my($ptr) = @_;
	    eval q((($ptr)[2]));
    }' unless defined(&_HACT_LO);
    eval 'sub _HBLK_LO {
        my($ptr) = @_;
	    eval q((($ptr)[3]));
    }' unless defined(&_HBLK_LO);
    eval 'sub _HACT_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[4] & 0xf0) << 4));
    }' unless defined(&_HACT_HI);
    eval 'sub _HBLK_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[4] & 0xf) << 8));
    }' unless defined(&_HBLK_HI);
    eval 'sub EDID_DET_TIMING_HACTIVE {
        my($ptr) = @_;
	    eval q(( &_HACT_LO($ptr) |  &_HACT_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_HACTIVE);
    eval 'sub EDID_DET_TIMING_HBLANK {
        my($ptr) = @_;
	    eval q(( &_HBLK_LO($ptr) |  &_HBLK_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_HBLANK);
    eval 'sub _VACT_LO {
        my($ptr) = @_;
	    eval q((($ptr)[5]));
    }' unless defined(&_VACT_LO);
    eval 'sub _VBLK_LO {
        my($ptr) = @_;
	    eval q((($ptr)[6]));
    }' unless defined(&_VBLK_LO);
    eval 'sub _VACT_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[7] & 0xf0) << 4));
    }' unless defined(&_VACT_HI);
    eval 'sub _VBLK_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[7] & 0xf) << 8));
    }' unless defined(&_VBLK_HI);
    eval 'sub EDID_DET_TIMING_VACTIVE {
        my($ptr) = @_;
	    eval q(( &_VACT_LO($ptr) |  &_VACT_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_VACTIVE);
    eval 'sub EDID_DET_TIMING_VBLANK {
        my($ptr) = @_;
	    eval q(( &_VBLK_LO($ptr) |  &_VBLK_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_VBLANK);
    eval 'sub _HOFF_LO {
        my($ptr) = @_;
	    eval q((($ptr)[8]));
    }' unless defined(&_HOFF_LO);
    eval 'sub _HWID_LO {
        my($ptr) = @_;
	    eval q((($ptr)[9]));
    }' unless defined(&_HWID_LO);
    eval 'sub _VOFF_LO {
        my($ptr) = @_;
	    eval q((($ptr)[10] >> 4));
    }' unless defined(&_VOFF_LO);
    eval 'sub _VWID_LO {
        my($ptr) = @_;
	    eval q((($ptr)[10] & 0xf));
    }' unless defined(&_VWID_LO);
    eval 'sub _HOFF_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[11] & 0xc0) << 2));
    }' unless defined(&_HOFF_HI);
    eval 'sub _HWID_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[11] & 0x30) << 4));
    }' unless defined(&_HWID_HI);
    eval 'sub _VOFF_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[11] & 0xc) << 2));
    }' unless defined(&_VOFF_HI);
    eval 'sub _VWID_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[11] & 0x3) << 4));
    }' unless defined(&_VWID_HI);
    eval 'sub EDID_DET_TIMING_HSYNC_OFFSET {
        my($ptr) = @_;
	    eval q(( &_HOFF_LO($ptr) |  &_HOFF_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_HSYNC_OFFSET);
    eval 'sub EDID_DET_TIMING_HSYNC_WIDTH {
        my($ptr) = @_;
	    eval q(( &_HWID_LO($ptr) |  &_HWID_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_HSYNC_WIDTH);
    eval 'sub EDID_DET_TIMING_VSYNC_OFFSET {
        my($ptr) = @_;
	    eval q(( &_VOFF_LO($ptr) |  &_VOFF_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_VSYNC_OFFSET);
    eval 'sub EDID_DET_TIMING_VSYNC_WIDTH {
        my($ptr) = @_;
	    eval q(( &_VWID_LO($ptr) |  &_VWID_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_VSYNC_WIDTH);
    eval 'sub _HSZ_LO {
        my($ptr) = @_;
	    eval q((($ptr)[12]));
    }' unless defined(&_HSZ_LO);
    eval 'sub _VSZ_LO {
        my($ptr) = @_;
	    eval q((($ptr)[13]));
    }' unless defined(&_VSZ_LO);
    eval 'sub _HSZ_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[14] & 0xf0) << 4));
    }' unless defined(&_HSZ_HI);
    eval 'sub _VSZ_HI {
        my($ptr) = @_;
	    eval q(((($ptr)[14] & 0xf) << 8));
    }' unless defined(&_VSZ_HI);
    eval 'sub EDID_DET_TIMING_HSIZE {
        my($ptr) = @_;
	    eval q(( &_HSZ_LO($ptr) |  &_HSZ_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_HSIZE);
    eval 'sub EDID_DET_TIMING_VSIZE {
        my($ptr) = @_;
	    eval q(( &_VSZ_LO($ptr) |  &_VSZ_HI($ptr)));
    }' unless defined(&EDID_DET_TIMING_VSIZE);
    eval 'sub EDID_DET_TIMING_HBORDER {
        my($ptr) = @_;
	    eval q((($ptr)[15]));
    }' unless defined(&EDID_DET_TIMING_HBORDER);
    eval 'sub EDID_DET_TIMING_VBORDER {
        my($ptr) = @_;
	    eval q((($ptr)[16]));
    }' unless defined(&EDID_DET_TIMING_VBORDER);
    eval 'sub EDID_DET_TIMING_FLAGS {
        my($ptr) = @_;
	    eval q((($ptr)[17]));
    }' unless defined(&EDID_DET_TIMING_FLAGS);
    eval 'sub EDID_DET_TIMING_FLAG_INTERLACE () {0x80;}' unless defined(&EDID_DET_TIMING_FLAG_INTERLACE);
    eval 'sub EDID_DET_TIMING_FLAG_STEREO () {0x60;}' unless defined(&EDID_DET_TIMING_FLAG_STEREO);
    eval 'sub EDID_DET_TIMING_FLAG_SYNC_SEPARATE () {0x18;}' unless defined(&EDID_DET_TIMING_FLAG_SYNC_SEPARATE);
    eval 'sub EDID_DET_TIMING_FLAG_HSYNC_POSITIVE () {0x4;}' unless defined(&EDID_DET_TIMING_FLAG_HSYNC_POSITIVE);
    eval 'sub EDID_DET_TIMING_FLAG_VSYNC_POSITIVE () {0x2;}' unless defined(&EDID_DET_TIMING_FLAG_VSYNC_POSITIVE);
    eval 'sub EDID_DET_TIMING_FLAG_STEREO1 () {0x1;}' unless defined(&EDID_DET_TIMING_FLAG_STEREO1);
    eval 'sub EDID_BLOCK_TYPE {
        my($ptr) = @_;
	    eval q((($ptr)[3]));
    }' unless defined(&EDID_BLOCK_TYPE);
    eval 'sub EDID_DESC_BLOCK_SIZE () {18;}' unless defined(&EDID_DESC_BLOCK_SIZE);
    eval 'sub EDID_DESC_BLOCK_TYPE_SERIAL () {0xff;}' unless defined(&EDID_DESC_BLOCK_TYPE_SERIAL);
    eval 'sub EDID_DESC_BLOCK_TYPE_ASCII () {0xfe;}' unless defined(&EDID_DESC_BLOCK_TYPE_ASCII);
    eval 'sub EDID_DESC_BLOCK_TYPE_RANGE () {0xfd;}' unless defined(&EDID_DESC_BLOCK_TYPE_RANGE);
    eval 'sub EDID_DESC_BLOCK_TYPE_NAME () {0xfc;}' unless defined(&EDID_DESC_BLOCK_TYPE_NAME);
    eval 'sub EDID_DESC_BLOCK_TYPE_COLOR_POINT () {0xfb;}' unless defined(&EDID_DESC_BLOCK_TYPE_COLOR_POINT);
    eval 'sub EDID_DESC_BLOCK_TYPE_STD_TIMING () {0xfa;}' unless defined(&EDID_DESC_BLOCK_TYPE_STD_TIMING);
    eval 'sub EDID_DESC_ASCII_DATA_OFFSET () {5;}' unless defined(&EDID_DESC_ASCII_DATA_OFFSET);
    eval 'sub EDID_DESC_ASCII_DATA_LEN () {13;}' unless defined(&EDID_DESC_ASCII_DATA_LEN);
    eval 'sub EDID_DESC_RANGE_MIN_VFREQ {
        my($ptr) = @_;
	    eval q((($ptr)[5]));
    }' unless defined(&EDID_DESC_RANGE_MIN_VFREQ);
    eval 'sub EDID_DESC_RANGE_MAX_VFREQ {
        my($ptr) = @_;
	    eval q((($ptr)[6]));
    }' unless defined(&EDID_DESC_RANGE_MAX_VFREQ);
    eval 'sub EDID_DESC_RANGE_MIN_HFREQ {
        my($ptr) = @_;
	    eval q((($ptr)[7]));
    }' unless defined(&EDID_DESC_RANGE_MIN_HFREQ);
    eval 'sub EDID_DESC_RANGE_MAX_HFREQ {
        my($ptr) = @_;
	    eval q((($ptr)[8]));
    }' unless defined(&EDID_DESC_RANGE_MAX_HFREQ);
    eval 'sub EDID_DESC_RANGE_MAX_CLOCK {
        my($ptr) = @_;
	    eval q(((($ptr)[9]) * 10));
    }' unless defined(&EDID_DESC_RANGE_MAX_CLOCK);
    eval 'sub EDID_DESC_RANGE_HAVE_GTF2 {
        my($ptr) = @_;
	    eval q(((($ptr)[10]) == 0x2));
    }' unless defined(&EDID_DESC_RANGE_HAVE_GTF2);
    eval 'sub EDID_DESC_RANGE_GTF2_HFREQ {
        my($ptr) = @_;
	    eval q(((($ptr)[12]) * 2));
    }' unless defined(&EDID_DESC_RANGE_GTF2_HFREQ);
    eval 'sub EDID_DESC_RANGE_GTF2_C {
        my($ptr) = @_;
	    eval q(((($ptr)[13]) / 2));
    }' unless defined(&EDID_DESC_RANGE_GTF2_C);
    eval 'sub EDID_DESC_RANGE_GTF2_M {
        my($ptr) = @_;
	    eval q((($ptr)[14] + (($ptr)[15] << 8)));
    }' unless defined(&EDID_DESC_RANGE_GTF2_M);
    eval 'sub EDID_DESC_RANGE_GTF2_K {
        my($ptr) = @_;
	    eval q((($ptr)[16]));
    }' unless defined(&EDID_DESC_RANGE_GTF2_K);
    eval 'sub EDID_DESC_RANGE_GTF2_J {
        my($ptr) = @_;
	    eval q((($ptr)[17] / 2));
    }' unless defined(&EDID_DESC_RANGE_GTF2_J);
    eval 'sub EDID_DESC_COLOR_WHITEX {
        my($ptr) = @_;
	    eval q();
    }' unless defined(&EDID_DESC_COLOR_WHITEX);
    eval 'sub EDID_DESC_COLOR_WHITE_INDEX_1 {
        my($ptr) = @_;
	    eval q((($ptr)[5]));
    }' unless defined(&EDID_DESC_COLOR_WHITE_INDEX_1);
    eval 'sub EDID_DESC_COLOR_WHITEX_1 {
        my($ptr) = @_;
	    eval q( &_CHROMA($ptr, 6, 2, 7));
    }' unless defined(&EDID_DESC_COLOR_WHITEX_1);
    eval 'sub EDID_DESC_COLOR_WHITEY_1 {
        my($ptr) = @_;
	    eval q( &_CHROMA($ptr, 6, 0, 8));
    }' unless defined(&EDID_DESC_COLOR_WHITEY_1);
    eval 'sub EDID_DESC_COLOR_GAMMA_1 {
        my($ptr) = @_;
	    eval q( &_GAMMA($ptr->[9]));
    }' unless defined(&EDID_DESC_COLOR_GAMMA_1);
    eval 'sub EDID_DESC_COLOR_WHITE_INDEX_2 {
        my($ptr) = @_;
	    eval q((($ptr)[10]));
    }' unless defined(&EDID_DESC_COLOR_WHITE_INDEX_2);
    eval 'sub EDID_DESC_COLOR_WHITEX_2 {
        my($ptr) = @_;
	    eval q( &_CHROMA($ptr, 11, 2, 12));
    }' unless defined(&EDID_DESC_COLOR_WHITEX_2);
    eval 'sub EDID_DESC_COLOR_WHITEY_2 {
        my($ptr) = @_;
	    eval q( &_CHROMA($ptr, 11, 0, 13));
    }' unless defined(&EDID_DESC_COLOR_WHITEY_2);
    eval 'sub EDID_DESC_COLOR_GAMMA_2 {
        my($ptr) = @_;
	    eval q( &_GAMMA($ptr->[14]));
    }' unless defined(&EDID_DESC_COLOR_GAMMA_2);
    eval 'sub EDID_DESC_STD_TIMING_START () {5;}' unless defined(&EDID_DESC_STD_TIMING_START);
    eval 'sub EDID_DESC_STD_TIMING_COUNT () {6;}' unless defined(&EDID_DESC_STD_TIMING_COUNT);
}
1;
