/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class WriterInterceptorMBW
implements WriterInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WriterInterceptorMBW.class);
    private MessageBodyWriter<Object> writer;
    private Message m;

    public WriterInterceptorMBW(MessageBodyWriter<Object> writer, Message m) {
        this.writer = writer;
        this.m = m;
    }

    public MessageBodyWriter<Object> getMBW() {
        return this.writer;
    }

    public void aroundWriteTo(WriterInterceptorContext c) throws IOException, WebApplicationException {
        MultivaluedMap headers = c.getHeaders();
        Object mtObject = headers.getFirst((Object)"Content-Type");
        MediaType entityMt = mtObject == null ? c.getMediaType() : JAXRSUtils.toMediaType(mtObject.toString());
        this.m.put((Object)"Content-Type", (Object)entityMt.toString());
        Class entityCls = c.getType();
        Type entityType = c.getGenericType();
        Annotation[] entityAnns = c.getAnnotations();
        if (this.writer == null || this.m.get((Object)"provider.selection.property.changed") == Boolean.TRUE && !this.writer.isWriteable(entityCls, entityType, entityAnns, entityMt)) {
            this.writer = ProviderFactory.getInstance(this.m).createMessageBodyWriter(entityCls, entityType, entityAnns, entityMt, this.m);
        }
        if (this.writer == null) {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem("NO_MSG_WRITER", entityCls, entityMt);
            throw new ProcessingException(errorMessage);
        }
        HttpUtils.convertHeaderValuesToString((Map<String, List<Object>>)headers, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Response EntityProvider is: " + this.writer.getClass().getName());
        }
        this.writer.writeTo(c.getEntity(), c.getType(), c.getGenericType(), c.getAnnotations(), entityMt, headers, c.getOutputStream());
    }
}

