/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FirebaseProcessEnvironment {
    private static final Map<String, String> localCache = new ConcurrentHashMap<String, String>();

    public static String getenv(String name) {
        String cachedValue = localCache.get(name);
        if (!Strings.isNullOrEmpty((String)cachedValue)) {
            return cachedValue;
        }
        return System.getenv(name);
    }

    public static void setenv(String name, String value) {
        localCache.put(name, value);
    }

    public static void clearCache() {
        localCache.clear();
    }
}

