/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedRole
extends AbstractRevisioned
implements InRealm {
    protected final String name;
    protected final String realm;
    protected final String description;
    protected final boolean composite;
    protected final Set<String> composites = new HashSet<String>();
    private final LazyLoader<RoleModel, MultivaluedHashMap<String, String>> attributes;

    public CachedRole(Long revision, RoleModel model, RealmModel realm) {
        super(revision, model.getId());
        this.composite = model.isComposite();
        this.description = model.getDescription();
        this.name = model.getName();
        this.realm = realm.getId();
        if (this.composite) {
            this.composites.addAll(model.getCompositesStream().map(RoleModel::getId).collect(Collectors.toSet()));
        }
        this.attributes = new DefaultLazyLoader<RoleModel, MultivaluedHashMap>(roleModel -> new MultivaluedHashMap(roleModel.getAttributes()), MultivaluedHashMap::new);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public Set<String> getComposites() {
        return this.composites;
    }

    public MultivaluedHashMap<String, String> getAttributes(KeycloakSession session, Supplier<RoleModel> roleModel) {
        return this.attributes.get(session, roleModel);
    }
}

