/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import org.hibernate.Incubating;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;

public interface MetadataBuildingContext {
    public BootstrapContext getBootstrapContext();

    public MetadataBuildingOptions getBuildingOptions();

    public MappingDefaults getMappingDefaults();

    public InFlightMetadataCollector getMetadataCollector();

    public ObjectNameNormalizer getObjectNameNormalizer();

    @Incubating
    default public int getPreferredSqlTypeCodeForBoolean() {
        return ConfigurationHelper.getPreferredSqlTypeCodeForBoolean(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public int getPreferredSqlTypeCodeForDuration() {
        return ConfigurationHelper.getPreferredSqlTypeCodeForDuration(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public int getPreferredSqlTypeCodeForUuid() {
        return ConfigurationHelper.getPreferredSqlTypeCodeForUuid(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public int getPreferredSqlTypeCodeForInstant() {
        return ConfigurationHelper.getPreferredSqlTypeCodeForInstant(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public int getPreferredSqlTypeCodeForArray() {
        return ConfigurationHelper.getPreferredSqlTypeCodeForArray(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return MetadataBuildingContext.isPreferJavaTimeJdbcTypesEnabled(this.getBootstrapContext().getServiceRegistry());
    }

    @Incubating
    default public boolean isPreferNativeEnumTypesEnabled() {
        return MetadataBuildingContext.isPreferNativeEnumTypesEnabled(this.getBootstrapContext().getServiceRegistry());
    }

    public static boolean isPreferJavaTimeJdbcTypesEnabled(ServiceRegistry serviceRegistry) {
        return MetadataBuildingContext.isPreferJavaTimeJdbcTypesEnabled(serviceRegistry.requireService(ConfigurationService.class));
    }

    public static boolean isPreferNativeEnumTypesEnabled(ServiceRegistry serviceRegistry) {
        return MetadataBuildingContext.isPreferNativeEnumTypesEnabled(serviceRegistry.requireService(ConfigurationService.class));
    }

    public static boolean isPreferJavaTimeJdbcTypesEnabled(ConfigurationService configurationService) {
        return ConfigurationHelper.getBoolean("hibernate.type.java_time_use_direct_jdbc", configurationService.getSettings(), false);
    }

    public static boolean isPreferNativeEnumTypesEnabled(ConfigurationService configurationService) {
        return ConfigurationHelper.getBoolean("hibernate.type.prefer_native_enum_types", configurationService.getSettings(), false);
    }

    public TypeDefinitionRegistry getTypeDefinitionRegistry();

    public String getCurrentContributorName();
}

