/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.conn;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.shared.common.i18n.MessageService;

public class ConnectionUtil {
    public static LanguageConnectionContext getCurrentLCC() throws SQLException {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ConnectionUtil.getContextOrNull("LanguageConnectionContext");
        if (lcc == null) {
            throw new SQLException(MessageService.getTextMessage((String)"08003", (Object[])new Object[0]), "08003", 40000);
        }
        return lcc;
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }
}

