/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.api.core.ApiFuture;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Pair;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.PushIdGenerator;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.database.utilities.Validation;
import com.google.firebase.database.utilities.encoding.CustomClassMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static DatabaseConfig defaultConfig;

    DatabaseReference(Repo repo, Path path) {
        super(repo, path);
    }

    DatabaseReference(String url, DatabaseConfig config) {
        this(Utilities.parseUrl(url), config);
    }

    private DatabaseReference(ParsedUrl parsedUrl, DatabaseConfig config) {
        this(RepoManager.getRepo(config, parsedUrl.repoInfo), parsedUrl.path);
    }

    public static void goOffline() {
        DatabaseReference.goOffline(DatabaseReference.getDefaultConfig());
    }

    static void goOffline(DatabaseConfig config) {
        RepoManager.interrupt(config);
    }

    public static void goOnline() {
        DatabaseReference.goOnline(DatabaseReference.getDefaultConfig());
    }

    static void goOnline(DatabaseConfig config) {
        RepoManager.resume(config);
    }

    private static synchronized DatabaseConfig getDefaultConfig() {
        if (defaultConfig == null) {
            defaultConfig = new DatabaseConfig();
        }
        return defaultConfig;
    }

    public DatabaseReference child(String pathString) {
        if (pathString == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.getPath().isEmpty()) {
            Validation.validateRootPathString(pathString);
        } else {
            Validation.validatePathString(pathString);
        }
        Path childPath = this.getPath().child(new Path(pathString));
        return new DatabaseReference(this.repo, childPath);
    }

    public DatabaseReference push() {
        String childNameStr = PushIdGenerator.generatePushChildName(this.repo.getServerTime());
        ChildKey childKey = ChildKey.fromString(childNameStr);
        return new DatabaseReference(this.repo, this.getPath().child(childKey));
    }

    public ApiFuture<Void> setValueAsync(Object value) {
        return this.setValueInternal(value, PriorityUtilities.parsePriority(this.path, null), null);
    }

    public ApiFuture<Void> setValueAsync(Object value, Object priority) {
        return this.setValueInternal(value, PriorityUtilities.parsePriority(this.path, priority), null);
    }

    public void setValue(Object value, CompletionListener listener) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(this.path, null), listener);
    }

    public void setValue(Object value, Object priority, CompletionListener listener) {
        this.setValueInternal(value, PriorityUtilities.parsePriority(this.path, priority), listener);
    }

    private ApiFuture<Void> setValueInternal(Object value, Node priority, CompletionListener optListener) {
        Validation.validateWritablePath(this.getPath());
        ValidationPath.validateWithObject(this.getPath(), value);
        Object bouncedValue = CustomClassMapper.convertToPlainJavaTypes(value);
        Validation.validateWritableObject(bouncedValue);
        final Node node = NodeUtilities.NodeFromJSON(bouncedValue, priority);
        final Pair<ApiFuture<Void>, CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.repo.setValue(DatabaseReference.this.getPath(), node, (CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }

    public ApiFuture<Void> setPriorityAsync(Object priority) {
        return this.setPriorityInternal(PriorityUtilities.parsePriority(this.path, priority), null);
    }

    public void setPriority(Object priority, CompletionListener listener) {
        this.setPriorityInternal(PriorityUtilities.parsePriority(this.path, priority), listener);
    }

    private ApiFuture<Void> setPriorityInternal(final Node priority, CompletionListener optListener) {
        Validation.validateWritablePath(this.getPath());
        final Pair<ApiFuture<Void>, CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.repo.setValue(DatabaseReference.this.getPath().child(ChildKey.getPriorityKey()), priority, (CompletionListener)wrapped.getSecond());
            }
        });
        return wrapped.getFirst();
    }

    public ApiFuture<Void> updateChildrenAsync(Map<String, Object> update) {
        return this.updateChildrenInternal(update, null);
    }

    public void updateChildren(Map<String, Object> update, CompletionListener listener) {
        this.updateChildrenInternal(update, listener);
    }

    private ApiFuture<Void> updateChildrenInternal(Map<String, Object> update, CompletionListener optListener) {
        if (update == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> bouncedUpdate = CustomClassMapper.convertToPlainJavaTypes(update);
        Map<Path, Node> parsedUpdate = Validation.parseAndValidateUpdate(this.getPath(), bouncedUpdate);
        final CompoundWrite merge = CompoundWrite.fromPathMerge(parsedUpdate);
        final Pair<ApiFuture<Void>, CompletionListener> wrapped = Utilities.wrapOnComplete(optListener);
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.repo.updateChildren(DatabaseReference.this.getPath(), merge, (CompletionListener)wrapped.getSecond(), bouncedUpdate);
            }
        });
        return wrapped.getFirst();
    }

    public ApiFuture<Void> removeValueAsync() {
        return this.setValueAsync(null);
    }

    public void removeValue(CompletionListener listener) {
        this.setValue(null, listener);
    }

    public OnDisconnect onDisconnect() {
        Validation.validateWritablePath(this.getPath());
        return new OnDisconnect(this.repo, this.getPath());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean fireLocalEvents) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        Validation.validateWritablePath(this.getPath());
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.repo.startTransaction(DatabaseReference.this.getPath(), handler, fireLocalEvents);
            }
        });
    }

    public FirebaseDatabase getDatabase() {
        return this.repo.getDatabase();
    }

    public String toString() {
        DatabaseReference parent = this.getParent();
        if (parent == null) {
            return this.repo.toString();
        }
        try {
            return parent.toString() + "/" + URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new DatabaseException("Failed to URLEncode key: " + this.getKey(), e);
        }
    }

    public DatabaseReference getParent() {
        Path parentPath = this.getPath().getParent();
        if (parentPath != null) {
            return new DatabaseReference(this.repo, parentPath);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.repo, new Path(""));
    }

    public String getKey() {
        if (this.getPath().isEmpty()) {
            return null;
        }
        return this.getPath().getBack().asString();
    }

    public boolean equals(Object other) {
        return other instanceof DatabaseReference && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    void setHijackHash(final boolean hijackHash) {
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.repo.setHijackHash(hijackHash);
            }
        });
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

