/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class StaticCredentialsProvider
implements AwsCredentialsProvider {
    private static final String PROVIDER_NAME = "StaticCredentialsProvider";
    private final AwsCredentials credentials;

    private StaticCredentialsProvider(AwsCredentials credentials) {
        Validate.notNull((Object)credentials, (String)"Credentials must not be null.", (Object[])new Object[0]);
        this.credentials = this.withProviderName(credentials);
    }

    private AwsCredentials withProviderName(AwsCredentials credentials) {
        if (credentials instanceof AwsBasicCredentials) {
            return ((AwsBasicCredentials)credentials).copy(c -> c.providerName(PROVIDER_NAME));
        }
        if (credentials instanceof AwsSessionCredentials) {
            return ((AwsSessionCredentials)credentials).copy(c -> c.providerName(PROVIDER_NAME));
        }
        return credentials;
    }

    public static StaticCredentialsProvider create(AwsCredentials credentials) {
        return new StaticCredentialsProvider(credentials);
    }

    @Override
    public AwsCredentials resolveCredentials() {
        return this.credentials;
    }

    public String toString() {
        return ToString.builder((String)PROVIDER_NAME).add("credentials", (Object)this.credentials).build();
    }
}

