/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.content;

import java.io.IOException;
import java.time.Instant;
import java.util.Set;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public HttpField getContentType();

    public HttpField getContentEncoding();

    public HttpField getContentLength();

    public HttpField getLastModified();

    public HttpField getETag();

    public String getCharacterEncoding();

    public MimeTypes.Type getMimeType();

    public Instant getLastModifiedInstant();

    public long getContentLengthValue();

    public Resource getResource();

    public void writeTo(Content.Sink var1, long var2, long var4, Callback var6);

    public Set<CompressedContentFormat> getPreCompressedContentFormats();

    default public String getContentTypeValue() {
        HttpField contentType = this.getContentType();
        return contentType == null ? null : contentType.getValue();
    }

    default public String getContentEncodingValue() {
        HttpField contentEncoding = this.getContentEncoding();
        return contentEncoding == null ? null : contentEncoding.getValue();
    }

    default public String getETagValue() {
        HttpField eTag = this.getETag();
        return eTag == null ? null : eTag.getValue();
    }

    public static class Wrapper
    implements HttpContent {
        private final HttpContent _delegate;

        public Wrapper(HttpContent content) {
            this._delegate = content;
        }

        public HttpContent getWrapped() {
            return this._delegate;
        }

        @Override
        public HttpField getContentType() {
            return this._delegate.getContentType();
        }

        @Override
        public String getCharacterEncoding() {
            return this._delegate.getCharacterEncoding();
        }

        @Override
        public MimeTypes.Type getMimeType() {
            return this._delegate.getMimeType();
        }

        @Override
        public HttpField getContentEncoding() {
            return this._delegate.getContentEncoding();
        }

        @Override
        public HttpField getContentLength() {
            return this._delegate.getContentLength();
        }

        @Override
        public long getContentLengthValue() {
            return this._delegate.getContentLengthValue();
        }

        @Override
        public Instant getLastModifiedInstant() {
            return this._delegate.getLastModifiedInstant();
        }

        @Override
        public HttpField getLastModified() {
            return this._delegate.getLastModified();
        }

        @Override
        public HttpField getETag() {
            return this._delegate.getETag();
        }

        @Override
        public Resource getResource() {
            return this._delegate.getResource();
        }

        @Override
        public void writeTo(Content.Sink sink, long offset, long length, Callback callback) {
            this._delegate.writeTo(sink, offset, length, callback);
        }

        @Override
        public Set<CompressedContentFormat> getPreCompressedContentFormats() {
            return this._delegate.getPreCompressedContentFormats();
        }

        public String toString() {
            return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._delegate);
        }
    }

    public static interface Factory {
        public HttpContent getContent(String var1) throws IOException;
    }
}

